/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ms.MultishelfLayoutEditDialog;
import cerent.cms.ui.shelf.AbstractShelfTablePane;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class NppMultishelfLayoutPane
extends AbstractShelfTablePane
implements ActionListener {
    private final int SHELF_ID_IDX = 0;
    private final int RACK_NUM_IDX = 1;
    private final int RACK_POS_IDX = 2;
    protected ChassisModels chassisModels;
    private JButton editB;
    private static final SDebug db = new SDebug("NppMultishelfLayoutPane");
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$sShelfInfoSubset;

    public NppMultishelfLayoutPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.chassisModels = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getChassisModelsInstance();
        this.tvObs = this.chassisModels;
    }

    private JPanel getButtonBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel3.add(new CSHelpButton(CSHelpConst.NppMultishelfLayoutPane));
        this.editB = new JButton("Edit");
        this.editB.addActionListener(this);
        jPanel2.add(this.editB);
        WindowHelper.setEnabled((JComponent)this.editB, (boolean)this.isUserAuthorized());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new ShelfIdColumnRenderer(), new RackNumColumnRenderer(), new RackPosColumnRenderer()};
        this.model = new SortableRowTableModel((RowDataSource)new ShelfRowSource(), columnRendererArray);
    }

    protected void refreshMyLines(Object object) {
        this.repopulateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        ArrayList arrayList = this.tableData;
        synchronized (arrayList) {
            this.tableData = new ArrayList();
            sShelfInfoSubset[] sShelfInfoSubsetArray = this.chassisModels.getShelfInfoList();
            for (int i = 0; i < sShelfInfoSubsetArray.length; ++i) {
                this.tableData.add(sShelfInfoSubsetArray[i]);
            }
        }
    }

    public void repopulateTable() {
        super.repopulateTable();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.model.getRowCount()) {
            this.clearTableSelection();
        }
    }

    protected void registerWithModels() {
        this.getObservableManager().addObservable((Observable)((Object)this.chassisModels));
        IChassisModel[] iChassisModelArray = this.chassisModels.getChassisModelsArray();
        for (int i = 0; i < iChassisModelArray.length; ++i) {
            this.getObservableManager().addObservable((Observable)((Object)iChassisModelArray[i]));
        }
    }

    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.getButtonBar(), "South");
        this.setDataSourceControl();
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public Short[] getRacks() {
        return new Short[]{new Short(1), new Short(2), new Short(3), new Short(4), new Short(5), new Short(6), new Short(7), new Short(8)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public sShelfInfoSubset[] getShelfLayoutInfo() {
        sShelfInfoSubset[] sShelfInfoSubsetArray = null;
        ArrayList arrayList = this.tableData;
        synchronized (arrayList) {
            sShelfInfoSubsetArray = this.tableData.toArray(new sShelfInfoSubset[this.tableData.size()]);
        }
        return sShelfInfoSubsetArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.editB)) {
            MultishelfLayoutEditDialog multishelfLayoutEditDialog = MultishelfLayoutEditDialog.instance(this);
            multishelfLayoutEditDialog.show();
            multishelfLayoutEditDialog.dispose();
        }
    }

    public void destroy() {
        db.info("destroy");
        this.chassisModels = null;
        super.destroy();
    }

    class RackPosColumnRenderer
    extends BaseColumnRenderer {
        RackPosColumnRenderer() {
        }

        public String getName() {
            return "Rack Position";
        }

        public int getWidth() {
            return 150;
        }
    }

    class RackNumColumnRenderer
    extends BaseColumnRenderer {
        RackNumColumnRenderer() {
        }

        public String getName() {
            return "Rack Number";
        }

        public int getWidth() {
            return 150;
        }
    }

    class ShelfIdColumnRenderer
    extends BaseColumnRenderer {
        ShelfIdColumnRenderer() {
        }

        public String getName() {
            return "Shelf ID";
        }

        public int getWidth() {
            return 100;
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        protected BaseColumnRenderer() {
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 0;
        }

        protected String getStringValue(sShelfInfoSubset sShelfInfoSubset2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    string = "Shelf " + NppMultishelfLayoutPane.this.chassisModels.getShelfIdByChassisIndex(sShelfInfoSubset2.chassisIndex);
                    break;
                }
                case 1: {
                    string = Integer.toString(sShelfInfoSubset2.position.rackNumber);
                    break;
                }
                case 2: {
                    string = Integer.toString(sShelfInfoSubset2.position.positionInRack);
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sShelfInfoSubset sShelfInfoSubset2 = (sShelfInfoSubset)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sShelfInfoSubset2, n2);
            JLabel jLabel = new JLabel(string);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.black);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sShelfInfoSubset)object, n);
            String string2 = this.getStringValue((sShelfInfoSubset)object2, n);
            return string.compareTo(string2);
        }
    }

    class ShelfRowSource
    extends AbstractRowDataSource {
        ShelfRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            ArrayList arrayList = NppMultishelfLayoutPane.this.tableData;
            synchronized (arrayList) {
                var2_2 = NppMultishelfLayoutPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            ArrayList arrayList = NppMultishelfLayoutPane.this.tableData;
            synchronized (arrayList) {
                n = NppMultishelfLayoutPane.this.tableData.size();
            }
            return n;
        }

        public Collection getAllObjects() {
            return NppMultishelfLayoutPane.this.tableData;
        }

        public Class getRowObjectClass() {
            return class$cerent$cms$idl$Equipment$sShelfInfoSubset == null ? (class$cerent$cms$idl$Equipment$sShelfInfoSubset = NppMultishelfLayoutPane.class$("cerent.cms.idl.Equipment.sShelfInfoSubset")) : class$cerent$cms$idl$Equipment$sShelfInfoSubset;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            this.getObservableManager().reset();
            NppMultishelfLayoutPane.this.registerWithModels();
            this.getObservableManager().setActive(true);
            this.initedOM = true;
            db.fine("initObservabledManager() done");
        }

        public void refreshFromModel() throws Exception {
            db.fine("InnerDsc::refreshFromModel()");
            if (!this.initedOM) {
                this.initObservableManager();
            }
            NppMultishelfLayoutPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)NppMultishelfLayoutPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

