/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.MultishelfViewPanel;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public class RackViewPanel
extends JPanel
implements ActionListener,
Observer {
    private MultishelfViewPanel parent;
    private short rackNumber;
    private HashMap bayMap = new HashMap();
    private JPopupMenu popup;
    private ActionOrganizer actOrg;
    public final short MAX_BAYS;
    private static final String CMD_REM_RACK = "Delete Rack";
    private static final int BORDER_SPACE = 5;
    private static Border RACK_IN_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private static Border RACK_OUT_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    protected static final SDebug db = new SDebug("RackViewPanel");

    public RackViewPanel(MultishelfViewPanel multishelfViewPanel, boolean bl, short s) {
        db.fine("<init>");
        this.MAX_BAYS = (short)(bl ? 3 : 4);
        this.rackNumber = s;
        this.parent = multishelfViewPanel;
        this.setBorder(BorderFactory.createCompoundBorder(RACK_OUT_BORDER, RACK_IN_BORDER));
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.gray);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JLabel jLabel = new JLabel("Rack " + s);
        jPanel.add(jLabel);
        this.add(jPanel);
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalGlue());
        for (short s2 = 0; s2 < this.MAX_BAYS; s2 = (short)(s2 + 1)) {
            BayViewPanel bayViewPanel = new BayViewPanel(this, (short)(s2 + 1));
            bayViewPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add(bayViewPanel);
            this.bayMap.put(new Integer(s2 + 1), bayViewPanel);
            if (s2 + 1 >= this.MAX_BAYS) continue;
            this.add(Box.createVerticalGlue());
            this.add(Box.createVerticalStrut(5));
            this.add(Box.createVerticalGlue());
        }
        this.popup = new JPopupMenu();
        this.actOrg = new ActionOrganizer(this);
        this.actOrg.addMenuItem((JComponent)this.popup, null, CMD_REM_RACK, 68);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public short getRackNum() {
        return this.rackNumber;
    }

    public NodeModelDelegate getNodeModel() {
        return this.parent.getNodeModel();
    }

    protected AbstractViewController getViewController() {
        return this.parent.getViewController();
    }

    public IUiToolkit getUiToolkit() {
        return this.parent.getUiToolkit();
    }

    public BayViewPanel getBay(int n) {
        return (BayViewPanel)this.bayMap.get(new Integer(n));
    }

    public void update(Observable observable, Object object) {
        db.fine("update(" + observable + ", " + (object == ModelUpdateType.DELETED ? "DELETED" : (object == ModelUpdateType.ADDED ? "ADDED" : object.toString())) + ")");
        this.actOrg.getMenuItem(CMD_REM_RACK).setEnabled(true);
        for (int i = 0; i < this.MAX_BAYS; ++i) {
            BayViewPanel bayViewPanel = this.getBay(i + 1);
            if (bayViewPanel.isEmpty()) continue;
            this.actOrg.getMenuItem(CMD_REM_RACK).setEnabled(false);
            break;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_REM_RACK) {
            this.bayMap.clear();
            this.parent.removeRack(this);
        }
    }

    public MultishelfViewPanel getMVP() {
        return this.parent;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                RackViewPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

