/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class ShelfBehavior {
    public static final String DELETE_SHELF = "Delete Shelf";
    public static final String OPEN_SHELF = "Open Shelf";
    public static final String ADD_SHELF = "Add Shelf";
    public static final String UNDELETE_SHELF = "Undelete Shelf";
    private NodeModelDelegate nmd;
    protected SDebug db;

    public ShelfBehavior(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.nmd = nodeModelDelegate;
        this.db = sDebug;
    }

    public void addShelf(final Component component, final short s, final short s2, final short s3) {
        new Thread("Shelf Provisioner"){

            public void run() {
                try {
                    EntityTableModel entityTableModel = ShelfBehavior.this.nmd.getEntityTableModel();
                    if (entityTableModel != null) {
                        entityTableModel.provisionShelf(s, s2, s3);
                    }
                }
                catch (InvalidData invalidData) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug cfr_ignored_0 = ShelfBehavior.this.db;
                        SDebug.printStackTrace((Throwable)invalidData);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)("shelf ID " + s + " is invalid."));
                }
                catch (ProvisionError provisionError) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug cfr_ignored_1 = ShelfBehavior.this.db;
                        SDebug.printStackTrace((Throwable)provisionError);
                    }
                    ErrorMsg.displayError((Component)component, (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
                }
                catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                    if (ShelfBehavior.this.db.on()) {
                        SDebug cfr_ignored_2 = ShelfBehavior.this.db;
                        SDebug.printStackTrace((Throwable)notSupportedOnEquipment);
                    }
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_ADD_PARAM_1, (Object)"the equipment does not support multishelf.");
                }
            }
        }.start();
    }

    public void unDeleteShelf(Component component, IChassisModel iChassisModel) {
        this.addShelf(component, (short)iChassisModel.getShelfId(), iChassisModel.getShelfInfo().getRackNum(), iChassisModel.getShelfInfo().getRackPos());
    }

    public boolean deleteShelf(Component component, IChassisModel iChassisModel) {
        boolean bl = false;
        if (iChassisModel.getShelfId() == 1) {
            bl = false;
            ErrorMsg.displayError((Component)component, (EID)EMC.NOT_DELETE_NC);
            return bl;
        }
        if (CerentDialog.yesNoDialog((Component)component, (String)"Are you sure?", (String)"Deleting Shelf")) {
            try {
                bl = false;
                iChassisModel.unprovision();
                bl = true;
            }
            catch (ResourceInUse resourceInUse) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("it is in use.");
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_DELETE_PARAM_1, (Object)stringBuffer.toString());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_SHELF_DELETE_PARAM_1, (Object)"provision error");
            }
        }
        return bl;
    }
}

