/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.IMsShelfLayout;
import cerent.cms.ui.ms.MsCardPanel;
import cerent.cms.ui.ms.MultishelfViewPanel;
import cerent.util.SDebug;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class ShelfTransferHandler
extends TransferHandler {
    private DataFlavor shelfIdFlavor = DataFlavor.stringFlavor;
    private BayViewPanel source = null;
    private final ChassisModels cms;
    private final MultishelfViewPanel mvp;
    private static final SDebug db = new SDebug("ShelfTransferHandler");

    public ShelfTransferHandler(ChassisModels chassisModels, MultishelfViewPanel multishelfViewPanel) {
        this.cms = chassisModels;
        this.mvp = multishelfViewPanel;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        block13: {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                BayViewPanel bayViewPanel = this.getBVPForComponent(jComponent);
                if (this.source == bayViewPanel) {
                    return true;
                }
                sShelfInfoSubset[] sShelfInfoSubsetArray = this.cms.getShelfInfoList();
                try {
                    int n;
                    int n2 = Integer.parseInt((String)transferable.getTransferData(this.shelfIdFlavor));
                    IChassisModel iChassisModel = this.cms.getChassisByShelfId(n2);
                    IChassisModel iChassisModel2 = bayViewPanel.getChassis();
                    for (n = 0; n < sShelfInfoSubsetArray.length; ++n) {
                        if (iChassisModel.getEntityIndex() != sShelfInfoSubsetArray[n].chassisIndex) continue;
                        this.source = this.mvp.getRack(sShelfInfoSubsetArray[n].position.rackNumber).getBay(sShelfInfoSubsetArray[n].position.positionInRack);
                        break;
                    }
                    bayViewPanel.update((Observable)((Object)iChassisModel), ModelUpdateType.ADDED);
                    bayViewPanel.alertUserToChange();
                    if (iChassisModel2 != null && this.source != null) {
                        this.source.update((Observable)((Object)iChassisModel2), ModelUpdateType.ADDED);
                        this.source.alertUserToChange();
                    } else {
                        this.source.update((Observable)((Object)iChassisModel), ModelUpdateType.DELETED);
                    }
                    for (n = 0; n < sShelfInfoSubsetArray.length; ++n) {
                        if (iChassisModel.getEntityIndex() == sShelfInfoSubsetArray[n].chassisIndex) {
                            sShelfInfoSubsetArray[n].position.rackNumber = bayViewPanel.getRVP().getRackNum();
                            sShelfInfoSubsetArray[n].position.positionInRack = bayViewPanel.getBayNum();
                        }
                        if (iChassisModel2 == null || iChassisModel2.getEntityIndex() != sShelfInfoSubsetArray[n].chassisIndex) continue;
                        sShelfInfoSubsetArray[n].position.rackNumber = this.source.getRVP().getRackNum();
                        sShelfInfoSubsetArray[n].position.positionInRack = this.source.getBayNum();
                    }
                    this.cms.setShelfInfoList(sShelfInfoSubsetArray);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    db.fine("Caught " + unsupportedFlavorException + " in importData");
                    if (!db.on()) break block13;
                    SDebug.printStackTrace((Throwable)unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    db.fine("Caught " + iOException + " in importData");
                    if (!db.on()) break block13;
                    SDebug.printStackTrace((Throwable)iOException);
                }
                catch (InvalidData invalidData) {
                    db.fine("Caught " + (Object)((Object)invalidData) + " in importData");
                    if (!db.on()) break block13;
                    SDebug.printStackTrace((Throwable)invalidData);
                }
                catch (ProvisionError provisionError) {
                    db.fine("Caught " + (Object)((Object)provisionError) + " in importData");
                    if (!db.on()) break block13;
                    SDebug.printStackTrace((Throwable)provisionError);
                    for (int i = 0; i < sShelfInfoSubsetArray.length; ++i) {
                        db.println(Integer.toHexString(sShelfInfoSubsetArray[i].chassisIndex) + " -> (" + sShelfInfoSubsetArray[i].position.rackNumber + ", " + sShelfInfoSubsetArray[i].position.positionInRack + ")");
                    }
                }
            }
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        this.source = this.getBVPForComponent(jComponent);
        return new ShelfTransferable(this.source.getChassis().getShelfId());
    }

    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    private BayViewPanel getBVPForComponent(JComponent jComponent) {
        BayViewPanel bayViewPanel = null;
        if (jComponent instanceof BayViewPanel) {
            bayViewPanel = (BayViewPanel)jComponent;
        } else if (jComponent instanceof IMsShelfLayout) {
            IMsShelfLayout iMsShelfLayout = (IMsShelfLayout)((Object)jComponent);
            bayViewPanel = iMsShelfLayout.getBayViewPanel();
        } else if (jComponent instanceof MsCardPanel) {
            MsCardPanel msCardPanel = (MsCardPanel)jComponent;
            IMsShelfLayout iMsShelfLayout = (IMsShelfLayout)((Object)msCardPanel.getShelfLayout());
            bayViewPanel = iMsShelfLayout.getBayViewPanel();
        }
        return bayViewPanel;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        this.source = null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!this.shelfIdFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    class ShelfTransferable
    implements Transferable {
        private final String shelfId;

        ShelfTransferable(int n) {
            this.shelfId = Integer.toString(n);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.shelfId;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ShelfTransferHandler.this.shelfIdFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return ShelfTransferHandler.this.shelfIdFlavor.equals(dataFlavor);
        }
    }
}

