/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nedefaults;

import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.ui.nedefaults.DefaultsTableCellRenderer;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

class DefaultsDataSource
extends AbstractRowDataSource {
    private ArrayList _values = new ArrayList();
    private DefaultsTableCellRenderer _renderer = new DefaultsTableCellRenderer();
    public static final int NAME_MODEL_INDEX = 0;
    public static final int VALUE_MODEL_INDEX = 1;
    public static final int DOMAIN_MODEL_INDEX = 2;
    public static final int SIDE_EFFECTS_MODEL_INDEX = 3;
    public static final String DOMAIN_NAME = "Default Domain";
    public static final String SIDE_EFFECTS_NAME = "Side Effects";
    public static final String[] _columnNames = new String[]{"Default Name", "Default Value", "Default Domain", "Side Effects"};
    private static final Class[] _columnClasses = new Class[]{String.class, String.class, String.class, String.class};
    private static final SDebug db = new SDebug("DefaultsDataSource");

    DefaultsDataSource() {
        if (db.on()) {
            db.println("empty");
        }
    }

    void refreshFromModel(SortableRowTableModel sortableRowTableModel, Collection collection) {
        block5: {
            try {
                Iterator iterator = collection.iterator();
                ArrayList<DefaultsInfo> arrayList = new ArrayList<DefaultsInfo>();
                while (iterator.hasNext()) {
                    arrayList.add(new DefaultsInfo((IDefaultsElement)iterator.next()));
                }
                Refresher refresher = new Refresher(sortableRowTableModel, arrayList);
                if (SwingUtilities.isEventDispatchThread()) {
                    refresher.run();
                } else {
                    SwingUtilities.invokeAndWait(refresher);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("exception: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    ColumnRenderer[] getRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[_columnNames.length];
        for (int i = 0; i < _columnNames.length; ++i) {
            columnRendererArray[i] = new Renderer(i);
        }
        return columnRendererArray;
    }

    public synchronized Object getObjectAtRow(int n) {
        return this._values.get(n);
    }

    public synchronized int getRowCount() {
        return this._values.size();
    }

    public Class getRowObjectClass() {
        return DefaultsInfo.class;
    }

    private class Renderer
    implements ColumnRenderer {
        private final int _column;

        Renderer(int n) {
            this._column = n;
        }

        public String getName() {
            return _columnNames[this._column];
        }

        public int getWidth() {
            return 96;
        }

        public int getAlignment() {
            return 2;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DefaultsInfo defaultsInfo = (DefaultsInfo)object;
            db.fine("row=" + n + " col=" + n2 + " name=" + defaultsInfo.getValueAt(0) + " value=" + defaultsInfo.getValueAt(1));
            return DefaultsDataSource.this._renderer.getTableCellRendererComponent(jTable, defaultsInfo.getModel(), bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof DefaultsInfo) {
                if (object2 instanceof DefaultsInfo) {
                    return ((DefaultsInfo)object).cmpValueAt((DefaultsInfo)object2, n);
                }
                return -1;
            }
            return 1;
        }
    }

    private class Refresher
    implements Runnable {
        private SortableRowTableModel _tm;
        private ArrayList _newValues;

        Refresher(SortableRowTableModel sortableRowTableModel, ArrayList arrayList) {
            this._tm = sortableRowTableModel;
            this._newValues = arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DefaultsDataSource defaultsDataSource = DefaultsDataSource.this;
            synchronized (defaultsDataSource) {
                DefaultsDataSource.this._values = this._newValues;
            }
            this._tm.dataSourceChanged();
            this._tm = null;
            this._newValues = null;
        }
    }

    static class DefaultsInfo {
        private IDefaultsElement _element;

        DefaultsInfo(IDefaultsElement iDefaultsElement) {
            this._element = iDefaultsElement;
        }

        IDefaultsElement getModel() {
            return this._element;
        }

        String getName() {
            return this._element.getName();
        }

        String getValue() {
            return this._element.getValue();
        }

        String getEdit() {
            return this._element.getEdit();
        }

        String getSideEffects() {
            return this._element.getSideEffects();
        }

        Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.getName();
                }
                case 1: {
                    return this.getValue();
                }
                case 2: {
                    return this.getEdit();
                }
                case 3: {
                    return this.getSideEffects();
                }
            }
            return null;
        }

        int cmpValueAt(DefaultsInfo defaultsInfo, int n) {
            switch (n) {
                case 0: {
                    return this.getName().compareTo(defaultsInfo.getName());
                }
                case 1: {
                    return this.getValue().compareTo(defaultsInfo.getValue());
                }
                case 2: {
                    return this.getEdit().compareTo(defaultsInfo.getEdit());
                }
                case 3: {
                    return this.getSideEffects().compareTo(defaultsInfo.getSideEffects());
                }
            }
            return -1;
        }
    }
}

