/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.SDebug;
import java.awt.Color;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class AnpManager
extends WzTask
implements Observer {
    private int shelfId;
    private int rackNum;
    private int rackPos;
    private int pos;
    private NsdWizardInfo wzInfo;
    private NsdWizardInfo.ColorPane logArea;
    private NsdWizardInfo.CtmLog logCtm;
    private NodeModelDelegate node;
    private ChassisModels cms;
    private IChassisModel[] ent = null;
    private EntityModel entS = null;
    private EntityModel backplane = null;
    private List lst = null;
    private List slots = null;
    private int cardCounter;
    private boolean searching = false;
    private Vector modelHandles = new Vector();
    private static final SDebug db = new SDebug("AnpManager");

    public AnpManager(NsdWizardInfo nsdWizardInfo, int n, NodeModelDelegate nodeModelDelegate) {
        this.shelfId = Integer.parseInt(((NsdWizardInfo.NodeStructure)nsdWizardInfo.getAnp().elementAt((int)n)).shelf);
        this.rackNum = Integer.parseInt(((NsdWizardInfo.NodeStructure)nsdWizardInfo.getAnp().elementAt((int)n)).rackNum);
        this.rackPos = Integer.parseInt(((NsdWizardInfo.NodeStructure)nsdWizardInfo.getAnp().elementAt((int)n)).rackPos);
        this.pos = n;
        this.wzInfo = nsdWizardInfo;
        if (nsdWizardInfo.isCtm()) {
            this.logCtm = nsdWizardInfo.getCtmLog();
        } else {
            this.logArea = nsdWizardInfo.getLogArea();
        }
        this.node = nodeModelDelegate;
        this.cms = nodeModelDelegate.getChassisModelsInstance();
        NsdWizardInfo.NodeStructure nodeStructure = (NsdWizardInfo.NodeStructure)nsdWizardInfo.getAnp().elementAt(this.pos);
        this.cardCounter = nodeStructure.slot.size();
        this.status = "idle";
    }

    public synchronized void doTask() {
        this.status = "working";
        if (this.pos == 0) {
            if (this.wzInfo.isCtm()) {
                this.logCtm.append(">> Starting Automatic Node Provisioning...\n");
                this.logCtm.append(">> Provisioning Shelf #" + this.shelfId + "..." + "\n");
            } else {
                this.logArea.append(Color.BLUE, ">> Starting Automatic Node Provisioning...\n");
                this.logArea.append(Color.BLUE, ">> Provisioning Shelf #" + this.shelfId + "..." + "\n");
            }
        }
        if (this.prepare()) {
            if (this.pos != 0) {
                if (this.wzInfo.isCtm()) {
                    this.logCtm.append("\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
                } else {
                    this.logArea.append(Color.BLUE, "\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
                }
            }
            this.provisionShelf();
            if (this.wzInfo.isCtm()) {
                this.logCtm.append("------------------------------------------------\n");
            } else {
                this.logArea.append(Color.BLUE, "------------------------------------------------\n");
            }
        }
    }

    public String getStatus() {
        return this.status;
    }

    private boolean prepare() {
        if (this.node.isMultishelf()) {
            boolean bl = false;
            this.ent = (IChassisModel[])this.node.getChassisModels();
            for (int i = 0; i < this.ent.length && !bl; ++i) {
                if (this.ent[i].getShelfId() != this.shelfId) continue;
                this.lst = ((EntityModel)((Object)this.ent[i])).getChildrenOfType(eClass.BACKPLANE);
                bl = true;
            }
            if (!bl) {
                if (!this.searching) {
                    this.cms.addObserver(this);
                    try {
                        EntityTableModel entityTableModel = this.node.getEntityTableModel();
                        if (entityTableModel != null) {
                            entityTableModel.provisionShelf((short)this.shelfId, (short)this.rackNum, (short)this.rackPos);
                        }
                        this.searching = true;
                    }
                    catch (Exception exception) {
                        this.cms.deleteObserver(this);
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        if (this.wzInfo.isCtm()) {
                            this.logCtm.append("\n>> Error Provisioning Shelf #" + this.shelfId + "...");
                        } else {
                            this.logArea.append(Color.RED, "\n>> Error Provisioning Shelf #" + this.shelfId + "...");
                        }
                        String string = "";
                        if (exception instanceof InvalidData) {
                            string = "InvalidData Exception";
                        } else if (exception instanceof NotSupportedOnEquipment) {
                            string = "NotSupportedOnEquipment Exception";
                        } else if (exception instanceof ProvisionError) {
                            string = "ProvisionError Exception";
                        }
                        if (this.wzInfo.isCtm()) {
                            this.logCtm.append("\n>> " + string + "..." + "\n");
                            this.logCtm.append("------------------------------------------------");
                        } else {
                            this.logArea.append(Color.RED, "\n>> " + string + "..." + "\n");
                            this.logArea.append(Color.BLUE, "------------------------------------------------");
                        }
                        this.status = "completed";
                    }
                    return false;
                }
                return false;
            }
        } else {
            this.entS = (EntityModel)((Object)this.node.getNcChassis());
            if (this.entS == null && db.on()) {
                db.println("no chassis found");
            }
            this.lst = this.entS.getChildrenOfType(eClass.BACKPLANE);
        }
        if (this.lst == null) {
            db.println("no backplanes found");
        }
        if (this.lst != null && this.lst.size() > 0) {
            this.backplane = (EntityModel)this.lst.get(0);
        }
        if (this.backplane == null && db.on()) {
            db.println("no backplane found");
        }
        this.slots = null;
        if (this.backplane != null) {
            this.slots = this.backplane.getChildren();
        }
        if (this.slots == null && db.on()) {
            db.println("no slots found");
        }
        return true;
    }

    private void provisionShelf() {
        NsdWizardInfo.NodeStructure nodeStructure = (NsdWizardInfo.NodeStructure)this.wzInfo.getAnp().elementAt(this.pos);
        int n = 0;
        String string = null;
        for (int i = 0; i < nodeStructure.slot.size(); ++i) {
            n = Integer.parseInt((String)nodeStructure.slot.elementAt(i));
            string = (String)nodeStructure.eqType.elementAt(i);
            this.provisionSlot(n, string);
        }
    }

    private void provisionSlot(int n, String string) {
        if (this.wzInfo.isCtm()) {
            this.logCtm.append(">> Provisioning Slot #" + n + " with " + string + " card...\n");
        } else {
            this.logArea.append(Color.BLUE, ">> Provisioning Slot #" + n + " with " + string + " card...\n");
        }
        EntityModel entityModel = (EntityModel)this.slots.get(n - 1);
        try {
            EntityTableModel entityTableModel = entityModel.getNodeModelDelegate().getEntityTableModel();
            int n2 = entityModel.getEntityIndex();
            eEqType eEqType2 = EntityModel.name2EqType((NodeModelDelegate)entityModel.getNodeModel(), string);
            entityModel.addObserver(this);
            this.modelHandles.add(entityModel);
            if (entityTableModel != null && eEqType2 != null) {
                entityTableModel.provisionModule(n2, eEqType2);
            }
            if (this.wzInfo.isCtm()) {
                this.logCtm.append(">> Applied...\n");
            } else {
                this.logArea.append(Color.BLUE, ">> Applied...\n");
            }
        }
        catch (xInUse xInUse2) {
            xInUse2.printStackTrace();
            if (this.wzInfo.isCtm()) {
                this.logCtm.append(">> Slot not empty...\n");
            } else {
                this.logArea.append(Color.RED, ">> Slot not empty...\n");
            }
            --this.cardCounter;
        }
        catch (xProvisionError xProvisionError2) {
            xProvisionError2.printStackTrace();
            if (this.wzInfo.isCtm()) {
                this.logCtm.append(">> Setting refused...\n");
            } else {
                this.logArea.append(Color.RED, ">> Setting refused...\n");
            }
            --this.cardCounter;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.wzInfo.isCtm()) {
                this.logCtm.append(">> Generic error...\n");
            }
            this.logArea.append(Color.RED, ">> Generic error...\n");
        }
        if (this.cardCounter == 0) {
            for (int i = 0; i < this.modelHandles.size(); ++i) {
                EntityModel entityModel2 = (EntityModel)this.modelHandles.elementAt(i);
                entityModel2.deleteObserver(this);
            }
            this.status = "completed";
        }
    }

    public void update(Observable observable, Object object) {
        block18: {
            int n;
            block17: {
                n = -1;
                if (!(observable instanceof ChassisModels)) break block17;
                n = object instanceof ChassisModelUpdate ? 2 : (Integer)object;
                switch (n) {
                    case 2: {
                        if (this.prepare()) {
                            if (this.pos != 0) {
                                if (this.wzInfo.isCtm()) {
                                    this.logCtm.append("\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
                                } else {
                                    this.logArea.append(Color.BLUE, "\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
                                }
                            }
                            this.provisionShelf();
                            if (this.wzInfo.isCtm()) {
                                this.logCtm.append("------------------------------------------------\n");
                            } else {
                                this.logArea.append(Color.BLUE, "------------------------------------------------\n");
                            }
                            this.cms.deleteObserver(this);
                        }
                        if (db.on()) {
                            db.println("updateObjectChanged(" + observable + ", " + object + ")");
                            break;
                        }
                        break block18;
                    }
                    default: {
                        if (db.on()) {
                            db.severe("Unknown update type " + n);
                            break;
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (observable instanceof SlotModel) {
                n = (Integer)object;
                switch (n) {
                    case 2: {
                        --this.cardCounter;
                        if (this.cardCounter == 0) {
                            for (int i = 0; i < this.modelHandles.size(); ++i) {
                                EntityModel entityModel = (EntityModel)this.modelHandles.elementAt(i);
                                entityModel.deleteObserver(this);
                            }
                            this.status = "completed";
                        }
                        if (!db.on()) break;
                        db.println("updateObjectChanged(" + observable + ", " + object + ")");
                        break;
                    }
                    default: {
                        if (!db.on()) break;
                        db.severe("Unknown update type " + n);
                    }
                }
            }
        }
    }
}

