/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.nodesetup.NodeSetupParser;
import cerent.cms.ui.nodesetup.NodeSetupSelection;
import cerent.cms.ui.nodesetup.NodeSetupWizard;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.shelf.SppNodeSetupPane;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NodeSetupController {
    private SppNodeSetupPane pane;
    private NodeModelDelegate nmd;
    private SDebug dbg;
    private File mpFile;
    private NsdWizardInfo wizInfo = null;
    private NodeSetupParser nsp;

    public NodeSetupController(SppNodeSetupPane sppNodeSetupPane, NodeModelDelegate nodeModelDelegate, File file, File file2, SDebug sDebug) {
        this.pane = sppNodeSetupPane;
        this.nmd = nodeModelDelegate;
        this.mpFile = file;
        this.dbg = sDebug;
        this.wizInfo = new NsdWizardInfo(file2);
        this.wizInfo.setNodeName(this.nmd.getName());
        this.setup();
        if (this.dbg.on()) {
            this.dbg.println("NodeSetupController: start");
        }
    }

    private void setup() {
        String string = this.mpFile.getAbsolutePath();
        this.nsp = new NodeSetupParser(this.nmd, this.dbg);
        try {
            Node node = this.nsp.parse(this.mpFile);
            this.wizInfo = this.nsp.extractNodeDescriptions(node, this.wizInfo);
            if (this.wizInfo.getNodeCnt() > 1) {
                NodeSetupSelection nodeSetupSelection = new NodeSetupSelection(JOptionPane.getFrameForComponent((Component)((Object)this.pane)), true, this.wizInfo, this.wizInfo.getNodesArray());
                nodeSetupSelection.show();
                if (this.wizInfo.getSelNode() != null) {
                    this.wizInfo = this.nsp.extractNodeInfo(this.wizInfo.getSelNode(), node, this.wizInfo);
                }
            } else {
                this.wizInfo = this.nsp.extractNodeInfo(this.wizInfo.getSingleNodeArray(), node, this.wizInfo);
            }
            if (this.wizInfo.getSelNode() != null || this.wizInfo.getNodeCnt() == 1) {
                NodeSetupWizard nodeSetupWizard = new NodeSetupWizard(this.nmd, JOptionPane.getFrameForComponent((Component)((Object)this.pane)), this.wizInfo, true);
                nodeSetupWizard.show();
            }
        }
        catch (Exception exception) {
            if (exception instanceof SAXParseException) {
                String string2 = this.composeExceptionMsg((SAXParseException)exception, string);
                ErrorMsg.displayDetailed((Component)((Object)this.pane), EMC.EID_CANNOT_PERFORM, string2);
            }
            this.dbg.println(exception.toString());
            if (this.dbg.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayDetailed((Component)((Object)this.pane), EMC.EID_CANNOT_PERFORM, exception);
        }
    }

    private String composeExceptionMsg(SAXException sAXException, String string) {
        String string2;
        String string3;
        int n;
        block5: {
            n = ((SAXParseException)sAXException).getLineNumber();
            string3 = sAXException.getMessage();
            string2 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                for (int i = 1; (string2 = bufferedReader.readLine()) != null && i != n; ++i) {
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                this.dbg.println("IO Exception in composeExceptionMsg: " + iOException);
                if (!this.dbg.on()) break block5;
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
        if (string3.endsWith("for type 'null'.")) {
            int n2 = string3.length();
            string3 = string3.substring(1, n2 - 16);
        }
        int n3 = 0;
        n3 = string3.indexOf(":");
        if (n3 != -1) {
            string3 = string3.substring(n3 + 2, string3.length());
        }
        string2 = string2 != null ? string2.trim() : "<empty file>";
        String string4 = "File: " + string + "\n" + "Line#: " + n + "\n" + "Line: " + string2 + "\n" + "Message: " + string3;
        return string4;
    }
}

