/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.nodesetup.AbstractNodeSetupDialog;
import cerent.cms.ui.nodesetup.NodeSetupWizard;
import cerent.cms.ui.nodesetup.NsdAnpPane;
import cerent.cms.ui.nodesetup.NsdAnsPane;
import cerent.cms.ui.nodesetup.NsdParamsPane;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.PrintStream;

public class NodeSetupDialog
extends AbstractNodeSetupDialog {
    private static final SDebug db = new SDebug("NodeSetupDialog");
    private NodeModelDelegate nmd;

    public NodeSetupDialog(NodeSetupWizard nodeSetupWizard, NsdWizardInfo nsdWizardInfo, Frame frame, boolean bl) {
        super(frame, "Node Setup for " + nsdWizardInfo.getNodeName(), new WzDiagDebug("NodeSetupDialog"), bl, true);
        this.wizard = nodeSetupWizard;
        this.wizardInfo = nsdWizardInfo;
        this.nmd = nsdWizardInfo.getNmd();
        int n = 950;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.statusPanel.removeMouseListener(this.statusPanel);
        this.splitter.setDividerLocation(160);
        this.applyButton.setVisible(true);
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
    }

    protected void createPanesAndSetCurrent() {
        String string = null;
        String string2 = "";
        if (this.wizardInfo.isAnpSelected()) {
            for (int i = 0; i < this.wizardInfo.getAnp().size(); ++i) {
                string = "Shelf" + i;
                string2 = this.nmd.isMultishelf() ? "Shelf # " + ((NsdWizardInfo.NodeStructure)this.wizardInfo.getAnp().elementAt((int)i)).shelf : "Node Layout";
                this.wzPaneMap.put(string, new NsdAnpPane(this, this.makeChildDebug("Anp"), this.wizardInfo, i, string2));
            }
            this.wizardInfo.setFirstPane("anp");
            if (!this.wizardInfo.isParamSelected() && !this.wizardInfo.isAnsSelected()) {
                this.wizardInfo.setLastPane("anp");
            }
        }
        if (this.wizardInfo.isParamSelected()) {
            NsdParamsPane nsdParamsPane = new NsdParamsPane(this, this.makeChildDebug("Params"), this.wizardInfo, "Card Parameters");
            this.wzPaneMap.put("Card Parameters", nsdParamsPane);
            if (!this.wizardInfo.isAnpSelected()) {
                this.wizardInfo.setFirstPane("param");
            }
            if (!this.wizardInfo.isAnsSelected()) {
                this.wizardInfo.setLastPane("param");
            }
        }
        if (this.wizardInfo.isAnsSelected()) {
            NsdAnsPane nsdAnsPane = new NsdAnsPane(this, this.makeChildDebug("Ans"), this.wizardInfo, "ANS Parameters");
            this.wzPaneMap.put("ANS Parameters", nsdAnsPane);
            if (!this.wizardInfo.isAnpSelected() && !this.wizardInfo.isParamSelected()) {
                this.wizardInfo.setFirstPane("ans");
            }
            this.wizardInfo.setLastPane("ans");
        }
        if (this.wizardInfo.isAnpSelected()) {
            this.setCurrentPane("Shelf0");
        } else if (this.wizardInfo.isAnsSelected()) {
            if (this.wizardInfo.isParamSelected()) {
                this.setCurrentPane("Card Parameters");
            } else {
                this.setCurrentPane("ANS Parameters");
            }
        } else {
            this.setCurrentPane("Card Parameters");
        }
    }

    protected void backFromEmptyStack() throws Exception {
        if (this.wizard != null) {
            this.close();
            this.dispose();
            this.wizard.setVisible(true);
        } else {
            super.backFromEmptyStack();
        }
    }

    protected void localValidation(int n) {
    }

    protected void handleCancel() {
        if (NodeSetupDialog.db.on) {
            db.println("handleCancel: cleaning up");
        }
        this.close();
    }

    protected String getCancelMessage() {
        return "Cancelling will not undo any provisioning already made.\nOk to cancel " + this.getTitle() + "?";
    }

    private void close() {
    }

    private void terminate() {
        this.cancel(false);
        CerentDialog.infoDialog((Component)this, (String)"Wizard successfully completed!", (String)"Wizard End");
        PrintStream printStream = this.wizardInfo.getLogPs();
        printStream.close();
    }

    public void finish() {
        this.terminate();
    }

    public void apply() {
    }

    protected void handleFinish() {
        super.handleFinish();
    }
}

