/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.SDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NodeSetupParser {
    private static final String BADXML_WT = "Invalid Metroplanner xml file";
    private static final String MULTISHELF_XML_WT = "Invalid Multi Shelf xml file: the node is single shelf";
    private static final String SHELFID_XML_WT = "Invalid Single Shelf xml file: incorrect shelf id ";
    private static final String ANS_XML_WT = "Invalid Metroplanner xml file: incorrect ANS section";
    private String ansErr;
    private int shelfCounter = -1;
    private NodeModelDelegate nmd;
    private SDebug dbg;

    public NodeSetupParser(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.nmd = nodeModelDelegate;
        this.dbg = sDebug;
    }

    public Node parse(File file) throws FactoryConfigurationError, ParserConfigurationException, IOException, SAXException {
        String string = file.getAbsolutePath();
        String string2 = "file:" + string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new Handler());
        documentBuilder.setEntityResolver(new SchemaLoader());
        Document document = documentBuilder.parse(string2);
        return document;
    }

    public NsdWizardInfo extractNodeDescriptions(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.extractNodeDescriptions(nodeList.item(i), nsdWizardInfo);
                }
                break;
            }
            case 1: {
                String string = node.getNodeName();
                if (string.equalsIgnoreCase("network")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractNodeDescriptions(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string.equalsIgnoreCase("nodesetup")) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    Node node2 = namedNodeMap.item(0);
                    nsdWizardInfo.setNodesArray(nsdWizardInfo.getNodeCnt(), node2.getNodeValue());
                    nsdWizardInfo.incNodeCnt();
                    break;
                }
                throw new Exception(BADXML_WT);
            }
        }
        return nsdWizardInfo;
    }

    public NsdWizardInfo extractNodeInfo(String string, Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.extractNodeInfo(string, nodeList.item(i), nsdWizardInfo);
                }
                break;
            }
            case 1: {
                String string2 = node.getNodeName();
                if (string2.equalsIgnoreCase("network")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractNodeInfo(string, nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("nodesetup")) {
                    NodeList nodeList = node.getChildNodes();
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    Node node2 = namedNodeMap.item(0);
                    if (nodeList == null || !node2.getNodeValue().equalsIgnoreCase(string)) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractNodeInfo(string, nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("ans")) {
                    nsdWizardInfo.setAnsPresent(true);
                    node = node.getFirstChild();
                    if (this.checkAnsParameters(node.getNodeValue().trim())) {
                        nsdWizardInfo.setAnsParams(node.getNodeValue().trim());
                        break;
                    }
                    throw new Exception("Invalid Metroplanner xml file: incorrect ANS section\n" + this.ansErr);
                }
                if (string2.equalsIgnoreCase("anp")) {
                    nsdWizardInfo.setAnpPresent(true);
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractShelfInfo(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("parameters")) {
                    nsdWizardInfo.setParamPresent(true);
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractParamInfo(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                throw new Exception(BADXML_WT);
            }
        }
        return nsdWizardInfo;
    }

    private void extractParamInfo(Node node, NsdWizardInfo nsdWizardInfo) {
        NsdWizardInfo.ParamStructure paramStructure = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getFirstChild() != null ? nodeList.item(i).getFirstChild().getNodeValue() : "";
                String string2 = nodeList.item(i).getNodeName();
                if (string2.equalsIgnoreCase("shelf_position")) {
                    paramStructure = new NsdWizardInfo.ParamStructure(nsdWizardInfo);
                    paramStructure.shelf = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("slot_position")) {
                    paramStructure.slot = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("port_position")) {
                    paramStructure.port = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("ppm_position")) {
                    paramStructure.ppm = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("name")) {
                    paramStructure.paramName = string;
                    continue;
                }
                if (!string2.equalsIgnoreCase("value")) continue;
                paramStructure.paramValue = string;
                nsdWizardInfo.getParams().addElement(paramStructure);
            }
        }
    }

    private void extractShelfInfo(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        boolean bl;
        String string = node.getNodeName();
        NsdWizardInfo.NodeStructure nodeStructure = null;
        boolean bl2 = bl = !this.nmd.isMultishelf();
        if (string.equalsIgnoreCase("shelf")) {
            int n;
            ++this.shelfCounter;
            if (this.shelfCounter > 0 && bl) {
                throw new Exception(MULTISHELF_XML_WT);
            }
            NodeList nodeList = node.getChildNodes();
            NamedNodeMap namedNodeMap = node.getAttributes();
            nodeStructure = new NsdWizardInfo.NodeStructure(nsdWizardInfo);
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                Node node2 = namedNodeMap.item(n);
                String string2 = node2.getNodeName();
                if (string2.equalsIgnoreCase("id")) {
                    nodeStructure.shelf = node2.getNodeValue();
                    if (!bl || nodeStructure.shelf.equals("1")) continue;
                    throw new Exception(SHELFID_XML_WT + nodeStructure.shelf);
                }
                if (string2.equalsIgnoreCase("rackNum")) {
                    nodeStructure.rackNum = node2.getNodeValue();
                    continue;
                }
                if (!string2.equalsIgnoreCase("rackPos")) continue;
                nodeStructure.rackPos = node2.getNodeValue();
            }
            nsdWizardInfo.getAnp().addElement(nodeStructure);
            if (nodeList != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    this.extractSlotInfo(this.shelfCounter, nodeList.item(n), nsdWizardInfo);
                }
            }
        }
    }

    private void extractSlotInfo(int n, Node node, NsdWizardInfo nsdWizardInfo) {
        String string = node.getNodeName();
        NsdWizardInfo.NodeStructure nodeStructure = null;
        if (string.equalsIgnoreCase("slot")) {
            int n2;
            NodeList nodeList = node.getChildNodes();
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                Node node2 = namedNodeMap.item(n2);
                nodeStructure = (NsdWizardInfo.NodeStructure)nsdWizardInfo.getAnp().elementAt(n);
                nodeStructure.slot.addElement(node2.getNodeValue());
            }
            if (nodeList != null) {
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    this.extractEqInfo(n, nodeList.item(n2), nsdWizardInfo);
                }
            }
        }
    }

    private void extractEqInfo(int n, Node node, NsdWizardInfo nsdWizardInfo) {
        String string = node.getNodeName();
        NsdWizardInfo.NodeStructure nodeStructure = null;
        if (string.equalsIgnoreCase("eqtype")) {
            node = node.getFirstChild();
            nodeStructure = (NsdWizardInfo.NodeStructure)nsdWizardInfo.getAnp().elementAt(n);
            nodeStructure.eqType.addElement(node.getNodeValue());
        }
    }

    private boolean checkAnsParameters(String string) {
        String string2 = "dwdm.NetworkType=\\S.*";
        String string3 = "dwdm.rx\\..*=\\S.*";
        String string4 = "dwdm.tx\\..*=\\S.*";
        String string5 = "dwdm.version=\\S.*";
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        Pattern pattern = Pattern.compile(string2);
        Pattern pattern2 = Pattern.compile(string3);
        Pattern pattern3 = Pattern.compile(string4);
        Pattern pattern4 = Pattern.compile(string5);
        try {
            String string6;
            while ((string6 = bufferedReader.readLine()) != null) {
                if (pattern.matcher(string6.trim()).lookingAt() || pattern2.matcher(string6.trim()).lookingAt() || pattern3.matcher(string6.trim()).lookingAt() || pattern4.matcher(string6.trim()).lookingAt()) continue;
                this.ansErr = "Invalid Parameter: " + string6;
                return false;
            }
        }
        catch (IOException iOException) {
            this.dbg.println("Exception during ans parameters check: " + iOException);
            if (this.dbg.on()) {
                SDebug.printStackTrace((Throwable)iOException);
            }
            this.ansErr = "Exception during ans parameters check: " + iOException;
            return false;
        }
        return true;
    }

    private static class SchemaLoader
    implements EntityResolver {
        private static final String XSD = "schema/nodesetup/mp-schema.dtd";

        private SchemaLoader() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            URL uRL = this.getClass().getClassLoader().getResource(XSD);
            return new InputSource(uRL.openStream());
        }
    }

    private static class Handler
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            System.out.println(" There was an error in the parsing ");
            sAXParseException.printStackTrace();
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            System.out.println(" There was an error in the parsing ");
            sAXParseException.printStackTrace();
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) {
            System.out.println(" There was a warning in the parsing ");
            sAXParseException.printStackTrace();
        }
    }
}

