/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class NodeSetupSelection
extends JDialog
implements ActionListener {
    private static final String VIGNETTE = "/images/CTC_dialogVignette.gif";
    private static final String PREF_PATH = "ctc.node.setup";
    private static final String NEXT = "Next>";
    private static final String CANCEL = "Cancel";
    private JList lstNodes;
    private DefaultListModel listModel;
    private JButton nextButton;
    private JButton cancelButton;
    private Frame parent;
    private boolean makeModal;
    private String[] nodesArray;
    private NsdWizardInfo wzInfo;
    private NodeModelDelegate nmd;
    private MouseListener mouseListener = null;

    public NodeSetupSelection(Frame frame, boolean bl, NsdWizardInfo nsdWizardInfo, String[] stringArray) {
        super(frame, "Node Setup Selection for " + nsdWizardInfo.getNodeName(), true);
        this.makeModal = bl;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NodeSetupSelection.this.dispose();
            }
        });
        this.mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                NodeSetupSelection.this.nextButton.setEnabled(true);
            }
        };
        this.parent = frame;
        this.nodesArray = stringArray;
        this.wzInfo = nsdWizardInfo;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getUpperPane(), "Center");
        container.add((Component)this.getBottomPane(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private JPanel getRightPane() {
        JPanel jPanel = AbstractPane.createVerticalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("Select Node Profile:");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        this.lstNodes = new JList(this.getNodeSetupList());
        this.lstNodes.setAlignmentX(0.0f);
        this.lstNodes.setVisibleRowCount(10);
        this.lstNodes.setSelectionMode(0);
        this.lstNodes.setPreferredSize(new Dimension(250, this.lstNodes.getHeight()));
        this.lstNodes.setCellRenderer(new NodeSetupRenderer());
        this.lstNodes.addMouseListener(this.mouseListener);
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add((Component)new UScrollPane((Component)this.lstNodes));
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        return jPanel;
    }

    private JPanel getLeftPane() {
        JPanel jPanel = new JPanel();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(VIGNETTE));
        jPanel.add(new JLabel(imageIcon));
        return jPanel;
    }

    private JPanel getUpperPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getLeftPane(), "West");
        jPanel.add((Component)this.getRightPane(), "Center");
        return jPanel;
    }

    private JPanel getBottomPane() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.nextButton = new JButton(NEXT);
        this.cancelButton = new JButton(CANCEL);
        jPanel.add(this.nextButton);
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(CSHelpConst.NodeSetupWizard));
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.cancelButton.addActionListener(this);
        return jPanel;
    }

    private DefaultListModel getNodeSetupList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.nodesArray));
        String[] stringArray = arrayList.toArray(new String[0]);
        this.listModel = new DefaultListModel();
        for (int i = 0; i < stringArray.length; ++i) {
            this.listModel.addElement(stringArray[i]);
        }
        return this.listModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nextButton) {
            this.handleNext();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    private void handleNext() {
        if (!this.validatePage()) {
            return;
        }
        this.dispose();
    }

    private boolean validatePage() {
        this.wzInfo.setSelNode((String)this.lstNodes.getSelectedValue());
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    class NodeSetupRenderer
    extends DefaultListCellRenderer {
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();

        NodeSetupRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.renderer = (DefaultListCellRenderer)this.renderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            return this.renderer;
        }
    }
}

