/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.nodesetup.AnpManager;
import cerent.cms.ui.nodesetup.AnsManager;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.ParamsManager;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.cms.ui.nodesetup.WzTasksController;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NodeSetupWizard
extends JDialog
implements ActionListener,
ItemListener {
    private static final String VIGNETTE = "/images/CTC_dialogVignette.gif";
    private static final String NEXT = "Next>";
    private static final String CANCEL = "Cancel";
    private JButton nextButton;
    private JButton cancelButton;
    private Frame parent;
    private NsdWizardInfo wizardInfo;
    private boolean makeModal;
    private JCheckBox anpCB;
    private JCheckBox ansCB;
    private JCheckBox paramsCB;
    private JCheckBox quickProvCB;
    private NodeModelDelegate nmd;
    private static final SDebug db = new SDebug("NodeSetupWizard");

    public NodeSetupWizard(NodeModelDelegate nodeModelDelegate, Frame frame, NsdWizardInfo nsdWizardInfo, boolean bl) {
        super(frame, "Node Setup for " + nsdWizardInfo.getNodeName(), true);
        this.wizardInfo = nsdWizardInfo;
        this.makeModal = bl;
        this.nmd = nodeModelDelegate;
        this.wizardInfo.setNmd(nodeModelDelegate);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NodeSetupWizard.this.dispose();
            }
        });
        this.parent = frame;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getUpperPane(), "Center");
        container.add((Component)this.getBottomPane(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private JPanel getRightPane() {
        JPanel jPanel = AbstractPane.createVerticalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("Choose setup components:");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = AbstractPane.createVerticalPanel(null);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(45, 45, 45, 45));
        this.anpCB = new JCheckBox("Provision Node Layout");
        this.anpCB.addItemListener(this);
        this.paramsCB = new JCheckBox("Provision Card Parameters");
        this.paramsCB.addItemListener(this);
        this.ansCB = new JCheckBox("Provision ANS Parameters");
        this.ansCB.addItemListener(this);
        jPanel3.add(this.anpCB);
        jPanel3.add(this.paramsCB);
        jPanel3.add(this.ansCB);
        if (!this.wizardInfo.isAnpPresent()) {
            this.anpCB.setEnabled(false);
        }
        if (!this.wizardInfo.isParamPresent()) {
            this.paramsCB.setEnabled(false);
        }
        if (!this.wizardInfo.isAnsPresent()) {
            this.ansCB.setEnabled(false);
        }
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        this.quickProvCB = new JCheckBox("Skip Interactive Mode");
        this.quickProvCB.setEnabled(false);
        this.quickProvCB.addItemListener(this);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.quickProvCB);
        return jPanel;
    }

    private JPanel getLeftPane() {
        JPanel jPanel = new JPanel();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(VIGNETTE));
        jPanel.add(new JLabel(imageIcon));
        return jPanel;
    }

    private JPanel getUpperPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getLeftPane(), "West");
        jPanel.add((Component)this.getRightPane(), "Center");
        return jPanel;
    }

    private JPanel getBottomPane() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.nextButton = new JButton(NEXT);
        this.cancelButton = new JButton(CANCEL);
        this.nextButton.setEnabled(false);
        jPanel.add(this.nextButton);
        jPanel.add(this.cancelButton);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.NodeSetupWizard);
        jPanel.add(cSHelpButtonPane);
        this.nextButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nextButton) {
            this.handleNext();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.quickProvCB.setEnabled(true);
            this.nextButton.setEnabled(true);
            if (itemEvent.getItemSelectable() == this.quickProvCB) {
                this.wizardInfo.setQuickProv(true);
            }
        } else {
            if (!(this.ansCB.isSelected() || this.anpCB.isSelected() || this.paramsCB.isSelected())) {
                this.quickProvCB.setEnabled(false);
                this.nextButton.setEnabled(false);
            }
            if (itemEvent.getItemSelectable() == this.quickProvCB) {
                this.wizardInfo.setQuickProv(false);
            }
        }
    }

    private void handleNext() {
        if (!this.validatePage()) {
            return;
        }
        NodeSetupDialog nodeSetupDialog = new NodeSetupDialog(this, this.wizardInfo, this.parent, this.makeModal);
        this.setVisible(false);
        if (!this.wizardInfo.isQuickProv()) {
            nodeSetupDialog.show();
            this.dispose();
        } else {
            this.ctcQuickProvisioning(this.wizardInfo);
        }
    }

    private boolean validatePage() {
        if (this.ansCB.isSelected()) {
            this.wizardInfo.setAnsSelected(true);
        } else {
            this.wizardInfo.setAnsSelected(false);
        }
        if (this.anpCB.isSelected()) {
            this.wizardInfo.setAnpSelected(true);
        } else {
            this.wizardInfo.setAnpSelected(false);
        }
        if (this.paramsCB.isSelected()) {
            this.wizardInfo.setParamSelected(true);
        } else {
            this.wizardInfo.setParamSelected(false);
        }
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    private void ctcQuickProvisioning(NsdWizardInfo nsdWizardInfo) {
        Vector<WzTask> vector = new Vector<WzTask>();
        AnpManager anpManager = null;
        ParamsManager paramsManager = null;
        AnsManager ansManager = null;
        Thread thread = null;
        if (nsdWizardInfo.isAnpSelected()) {
            for (int i = 0; i < nsdWizardInfo.getAnp().size(); ++i) {
                anpManager = new AnpManager(nsdWizardInfo, i, this.nmd);
                vector.addElement(anpManager);
            }
        }
        if (nsdWizardInfo.isParamSelected()) {
            paramsManager = new ParamsManager(nsdWizardInfo, this.nmd);
            vector.addElement(paramsManager);
        }
        if (nsdWizardInfo.isAnsSelected()) {
            ansManager = new AnsManager(nsdWizardInfo, this.nmd);
            vector.addElement(ansManager);
        }
        thread = new Thread(new WzTasksController(vector, nsdWizardInfo, false));
        thread.start();
    }
}

