/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzNsdPane;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class NsdAnpPane
extends WzNsdPane
implements Observer {
    private JSplitPane js = new JSplitPane();
    private NsdWizardInfo.ColorPane logArea;
    private NsdWizardInfo wizInfo;
    private JPanel rowTextArea;
    private JPanel colTextArea;
    private IChassisModel[] ent = null;
    private EntityModel entS = null;
    private EntityModel backplane = null;
    private List lst = null;
    private List slots = null;
    private NodeModelDelegate nodeModel;
    private NodeSetupDialog parent;
    private int shelfId;
    private int rackNum;
    private int rackPos;
    private int position;
    private boolean searching = false;
    private ChassisModels cms;
    private static final SDebug db = new SDebug("NsdAnpPane");
    private NsdWizardInfo.NodeStructure nodeStr = null;
    private String[] columnNames;
    private String[][] dataValues;
    private int cardCounter;
    private Vector modelHandles = new Vector();

    public NsdAnpPane(NodeSetupDialog nodeSetupDialog, WzDiagDebug wzDiagDebug, NsdWizardInfo nsdWizardInfo, int n, String string) {
        super(nodeSetupDialog, wzDiagDebug, string);
        this.parent = nodeSetupDialog;
        this.wizInfo = nsdWizardInfo;
        this.shelfId = Integer.parseInt(((NsdWizardInfo.NodeStructure)this.wizInfo.getAnp().elementAt((int)n)).shelf);
        this.rackNum = Integer.parseInt(((NsdWizardInfo.NodeStructure)this.wizInfo.getAnp().elementAt((int)n)).rackNum);
        this.rackPos = Integer.parseInt(((NsdWizardInfo.NodeStructure)this.wizInfo.getAnp().elementAt((int)n)).rackPos);
        this.position = n;
        this.nodeModel = this.wizInfo.getNmd();
        this.cms = this.nodeModel.getChassisModelsInstance();
        NsdWizardInfo.NodeStructure nodeStructure = (NsdWizardInfo.NodeStructure)this.wizInfo.getAnp().elementAt(this.position);
        this.cardCounter = nodeStructure.slot.size();
    }

    public void initPane() {
        this.setLayout(new BorderLayout(5, 5));
        this.js.setDividerLocation(375);
        this.js.setOneTouchExpandable(true);
        this.js.setContinuousLayout(true);
        this.js.setLeftComponent(this.createLeftPanel());
        this.js.setRightComponent(this.createRightPanel());
        this.parent.setApplyEnabled(true);
        this.parent.setButtonsEnabled(false, false);
        this.add((Component)this.js, "Center");
    }

    public void enteringPane() {
        this.initPane();
        if (db.on()) {
            db.println("enteringPage: start");
        }
        super.enteringPane();
    }

    public boolean handleBack() {
        this.rowTextArea.remove(this.colTextArea);
        this.colTextArea.remove(this.wizInfo.getLogArea());
        return super.handleBack();
    }

    protected String getNextPaneName() {
        if (!this.nodeModel.isMultishelf()) {
            if (this.wizInfo.isParamSelected()) {
                return "Card Parameters";
            }
            if (this.wizInfo.isAnsSelected()) {
                return "ANS Parameters";
            }
            return null;
        }
        int n = this.wizInfo.getAnp().size();
        if (this.position < n - 1) {
            int n2 = this.position + 1;
            String string = "Shelf" + n2;
            return string;
        }
        if (this.wizInfo.isParamSelected()) {
            return "Card Parameters";
        }
        if (this.wizInfo.isAnsSelected()) {
            return "ANS Parameters";
        }
        return null;
    }

    private JPanel createRightPanel() {
        this.rowTextArea = NsdAnpPane.createHorizontalPanel(null);
        this.colTextArea = NsdAnpPane.createVerticalPanel("Log");
        this.logArea = this.wizInfo.getLogArea();
        this.colTextArea.add((Component)new UScrollPane((Component)this.logArea));
        this.rowTextArea.add(this.colTextArea);
        return this.rowTextArea;
    }

    private JPanel createLeftPanel() {
        this.nodeStr = (NsdWizardInfo.NodeStructure)this.wizInfo.getAnp().elementAt(this.position);
        this.createColumns();
        this.createData();
        JTable jTable = new JTable(this.dataValues, this.columnNames){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setShowHorizontalLines(true);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(true);
        UScrollPane uScrollPane = new UScrollPane((Component)jTable);
        JPanel jPanel = NsdAnpPane.createHorizontalPanel(null);
        JPanel jPanel2 = NsdAnpPane.createVerticalPanel("");
        jPanel2.add((Component)uScrollPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void createColumns() {
        this.columnNames = new String[2];
        this.columnNames[0] = "Slot";
        this.columnNames[1] = "Equipment Type";
    }

    public void createData() {
        this.dataValues = new String[this.nodeStr.slot.size()][2];
        for (int i = 0; i < this.nodeStr.slot.size(); ++i) {
            String string = (String)this.nodeStr.slot.elementAt(i);
            String string2 = (String)this.nodeStr.eqType.elementAt(i);
            this.dataValues[i][0] = string;
            this.dataValues[i][1] = string2;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    void reset() {
        if (NsdAnpPane.db.on) {
            db.println("reset");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void handleApply() {
        if (this.position == 0) {
            this.logArea.append(Color.BLUE, ">>>> Start Time " + this.wizInfo.getCurrentTimeStamp() + " <<<<\n");
            this.logArea.append(Color.BLUE, "------------------------------------------------\n");
            this.logArea.append(Color.BLUE, ">> Starting Automatic Node Provisioning...\n");
            this.logArea.append(Color.BLUE, ">> Provisioning Shelf #" + this.shelfId + "..." + "\n");
        }
        if (this.prepare()) {
            if (this.position != 0) {
                this.logArea.append(Color.BLUE, "\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
            }
            this.provisionShelf();
            this.logArea.append(Color.BLUE, "------------------------------------------------");
            if (this.wizInfo.getLastPane().equalsIgnoreCase("anp") && this.getNextPaneName() == null) {
                this.logArea.append(Color.BLUE, "\n>>>> End Time " + this.wizInfo.getCurrentTimeStamp() + " <<<<");
            }
        }
    }

    public void validatePage() throws Exception {
        this.rowTextArea.remove(this.colTextArea);
        this.colTextArea.remove(this.wizInfo.getLogArea());
    }

    protected void handlePostValidate() {
    }

    public void revalidateData() {
        if (NsdAnpPane.db.on) {
            db.println("revalidateData: entry");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.NodeSetupWizard;
    }

    public void removeListeners() {
        super.removeListeners();
    }

    public void dispose() {
        super.dispose();
    }

    private boolean prepare() {
        if (this.nodeModel.isMultishelf()) {
            boolean bl = false;
            this.ent = (IChassisModel[])this.nodeModel.getChassisModels();
            for (int i = 0; i < this.ent.length && !bl; ++i) {
                if (this.ent[i].getShelfId() != this.shelfId) continue;
                this.lst = ((EntityModel)((Object)this.ent[i])).getChildrenOfType(eClass.BACKPLANE);
                bl = true;
            }
            if (!bl) {
                if (!this.searching) {
                    this.cms.addObserver(this);
                    this.parent.setApplyEnabled(false);
                    try {
                        EntityTableModel entityTableModel = this.nodeModel.getEntityTableModel();
                        if (entityTableModel != null) {
                            entityTableModel.provisionShelf((short)this.shelfId, (short)this.rackNum, (short)this.rackPos);
                        }
                        this.searching = true;
                    }
                    catch (Exception exception) {
                        this.cms.deleteObserver(this);
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        this.logArea.append(Color.RED, "\n>> Error Provisioning Shelf #" + this.shelfId + "...");
                        String string = "";
                        if (exception instanceof InvalidData) {
                            string = "InvalidData Exception";
                        } else if (exception instanceof NotSupportedOnEquipment) {
                            string = "NotSupportedOnEquipment Exception";
                        } else if (exception instanceof ProvisionError) {
                            string = "ProvisionError Exception";
                        }
                        this.logArea.append(Color.RED, "\n>> " + string + "..." + "\n");
                        this.logArea.append(Color.BLUE, "------------------------------------------------");
                        if (this.wizInfo.getLastPane().equalsIgnoreCase("anp") && this.getNextPaneName() == null) {
                            this.logArea.append(Color.BLUE, "\n>>>> End Time " + this.wizInfo.getCurrentTimeStamp() + " <<<<");
                        }
                        if (this.getNextPaneName() != null) {
                            this.parent.setNextEnabled(true);
                        } else {
                            this.parent.setNextEnabled(false);
                        }
                        this.parent.setApplyEnabled(false);
                    }
                    return false;
                }
                return false;
            }
        } else {
            this.entS = (EntityModel)((Object)this.nodeModel.getNcChassis());
            if (this.entS == null && db.on()) {
                db.println("no chassis found");
            }
            this.lst = this.entS.getChildrenOfType(eClass.BACKPLANE);
        }
        if (this.lst == null) {
            db.println("no backplanes found");
        }
        if (this.lst != null && this.lst.size() > 0) {
            this.backplane = (EntityModel)this.lst.get(0);
        }
        if (this.backplane == null && db.on()) {
            db.println("no backplane found");
        }
        this.slots = null;
        if (this.backplane != null) {
            this.slots = this.backplane.getChildren();
        }
        if (this.slots == null && db.on()) {
            db.println("no slots found");
        }
        return true;
    }

    private void provisionShelf() {
        NsdWizardInfo.NodeStructure nodeStructure = (NsdWizardInfo.NodeStructure)this.wizInfo.getAnp().elementAt(this.position);
        int n = 0;
        String string = null;
        for (int i = 0; i < nodeStructure.slot.size(); ++i) {
            n = Integer.parseInt((String)nodeStructure.slot.elementAt(i));
            string = (String)nodeStructure.eqType.elementAt(i);
            this.provisionSlot(n, string);
        }
    }

    private void provisionSlot(int n, String string) {
        this.logArea.append(Color.BLUE, ">> Provisioning Slot #" + n + " with " + string + " card...\n");
        EntityModel entityModel = (EntityModel)this.slots.get(n - 1);
        try {
            EntityTableModel entityTableModel = entityModel.getNodeModelDelegate().getEntityTableModel();
            int n2 = entityModel.getEntityIndex();
            eEqType eEqType2 = EntityModel.name2EqType((NodeModelDelegate)entityModel.getNodeModel(), string);
            entityModel.addObserver(this);
            this.modelHandles.add(entityModel);
            if (entityTableModel != null && eEqType2 != null) {
                entityTableModel.provisionModule(n2, eEqType2);
            }
            this.logArea.append(Color.BLUE, ">> Applied...\n");
        }
        catch (xInUse xInUse2) {
            xInUse2.printStackTrace();
            this.logArea.append(Color.RED, ">> Slot not empty...\n");
            --this.cardCounter;
        }
        catch (xProvisionError xProvisionError2) {
            xProvisionError2.printStackTrace();
            this.logArea.append(Color.RED, ">> Setting refused...\n");
            --this.cardCounter;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logArea.append(Color.RED, ">> Generic error...\n");
        }
        if (this.cardCounter == 0) {
            if (this.getNextPaneName() != null) {
                this.parent.setApplyEnabled(false);
                this.parent.setNextEnabled(true);
            } else {
                this.parent.setApplyEnabled(false);
                this.parent.setNextEnabled(false);
            }
            for (int i = 0; i < this.modelHandles.size(); ++i) {
                EntityModel entityModel2 = (EntityModel)this.modelHandles.elementAt(i);
                entityModel2.deleteObserver(this);
            }
        }
    }

    public void update(Observable observable, Object object) {
        block17: {
            int n;
            block16: {
                n = -1;
                if (!(observable instanceof ChassisModels)) break block16;
                n = object instanceof ChassisModelUpdate ? 2 : (Integer)object;
                switch (n) {
                    case 2: {
                        if (this.prepare()) {
                            if (this.position != 0) {
                                this.logArea.append(Color.BLUE, "\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
                            }
                            this.provisionShelf();
                            this.logArea.append(Color.BLUE, "------------------------------------------------");
                            if (this.wizInfo.getLastPane().equalsIgnoreCase("anp") && this.getNextPaneName() == null) {
                                this.logArea.append(Color.BLUE, "\n>>>> End Time " + this.wizInfo.getCurrentTimeStamp() + " <<<<");
                            }
                            this.cms.deleteObserver(this);
                        }
                        if (db.on()) {
                            db.println("updateObjectChanged(" + observable + ", " + object + ")");
                            break;
                        }
                        break block17;
                    }
                    default: {
                        if (db.on()) {
                            db.severe("Unknown update type " + n);
                            break;
                        }
                        break block17;
                    }
                }
                break block17;
            }
            if (observable instanceof SlotModel) {
                n = (Integer)object;
                switch (n) {
                    case 2: {
                        --this.cardCounter;
                        if (this.cardCounter == 0) {
                            if (this.getNextPaneName() != null) {
                                this.parent.setApplyEnabled(false);
                                this.parent.setNextEnabled(true);
                            } else {
                                this.parent.setApplyEnabled(false);
                                this.parent.setNextEnabled(false);
                            }
                            for (int i = 0; i < this.modelHandles.size(); ++i) {
                                EntityModel entityModel = (EntityModel)this.modelHandles.elementAt(i);
                                entityModel.deleteObserver(this);
                            }
                        }
                        if (!db.on()) break;
                        db.println("updateObjectChanged(" + observable + ", " + object + ")");
                        break;
                    }
                    default: {
                        if (!db.on()) break;
                        db.severe("Unknown update type " + n);
                    }
                }
            }
        }
    }
}

