/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.model.ANS.ANSManager;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.ans.ANSHelper;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzNsdPane;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class NsdAnsPane
extends WzNsdPane {
    private JSplitPane js = new JSplitPane();
    private NsdWizardInfo.ColorPane logArea;
    private NsdWizardInfo wizInfo;
    private JPanel rowTextArea;
    private JPanel colTextArea;
    private ANSHelper dfh;
    private ANSManager dfm;
    private NodeModelDelegate nodeModel;
    private NodeSetupDialog parent;
    private String[] columnNames;
    private String[][] dataValues;
    private Vector data;
    private static final SDebug db = new SDebug("NsdAnsPane");

    public NsdAnsPane(NodeSetupDialog nodeSetupDialog, WzDiagDebug wzDiagDebug, NsdWizardInfo nsdWizardInfo, String string) {
        super(nodeSetupDialog, wzDiagDebug, string);
        this.wizInfo = nsdWizardInfo;
        this.parent = nodeSetupDialog;
        this.nodeModel = this.wizInfo.getNmd();
        this.dfm = this.nodeModel.getANSManager();
    }

    public void executeAns() {
        if (this.wizInfo.getFirstPane().equalsIgnoreCase("ans")) {
            this.logArea.append(Color.BLUE, ">>>> Start Time " + this.wizInfo.getCurrentTimeStamp() + " <<<<\n");
            this.logArea.append(Color.BLUE, "------------------------------------------------\n");
        }
        this.logArea.append(Color.BLUE, ">> Starting ANS Parameters import...\n");
        this.dfh = new ANSHelper(this, this.nodeModel);
        this.dfh.importAnsParams(this.wizInfo);
        this.logArea.append(Color.BLUE, ">> Done...\n");
        if (this.wizInfo.getLastPane().equalsIgnoreCase("ans")) {
            this.logArea.append(Color.BLUE, "------------------------------------------------\n");
            this.logArea.append(Color.BLUE, ">>>> End Time " + this.wizInfo.getCurrentTimeStamp() + " <<<<");
        }
    }

    public void initPane() {
        this.setLayout(new BorderLayout(5, 5));
        this.js.setDividerLocation(375);
        this.js.setOneTouchExpandable(true);
        this.js.setContinuousLayout(true);
        this.js.setLeftComponent(this.createLeftPanel());
        this.js.setRightComponent(this.createRightPanel());
        this.add((Component)this.js, "Center");
        this.parent.setApplyEnabled(true);
        this.parent.setButtonsEnabled(false, false);
    }

    public void enteringPane() {
        this.initPane();
        if (db.on()) {
            db.println("enteringPage: start");
        }
        super.enteringPane();
    }

    public boolean handleBack() {
        return super.handleBack();
    }

    protected String getNextPaneName() {
        return null;
    }

    private JPanel createRightPanel() {
        this.rowTextArea = NsdAnsPane.createHorizontalPanel(null);
        this.colTextArea = NsdAnsPane.createVerticalPanel("Log");
        this.logArea = this.wizInfo.getLogArea();
        this.colTextArea.add((Component)new UScrollPane((Component)this.logArea));
        this.rowTextArea.add(this.colTextArea);
        return this.rowTextArea;
    }

    private JPanel createLeftPanel() {
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(this.wizInfo.getAnsParams());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string = null;
        this.data = new Vector();
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                this.data.add(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.createColumns();
        this.createData();
        JTable jTable = new JTable(this.dataValues, this.columnNames){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setShowHorizontalLines(true);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(true);
        UScrollPane uScrollPane = new UScrollPane((Component)jTable);
        JPanel jPanel = NsdAnsPane.createHorizontalPanel(null);
        JPanel jPanel2 = NsdAnsPane.createVerticalPanel("");
        jPanel2.add((Component)uScrollPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void createColumns() {
        this.columnNames = new String[2];
        this.columnNames[0] = "Parameter";
        this.columnNames[1] = "Value";
    }

    public void createData() {
        sParameterKey sParameterKey2 = null;
        int n = 0;
        this.dataValues = new String[this.data.size()][2];
        for (int i = 0; i < this.data.size(); ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)this.data.elementAt(i), "=");
            sParameterKey2 = new sParameterKey();
            String string = stringTokenizer.nextToken().trim();
            if (string.equalsIgnoreCase("dwdm.version")) continue;
            try {
                n = this.dfm.parseParam(string, sParameterKey2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string2 = stringTokenizer.nextToken();
            this.dataValues[i][0] = this.dfm.makeFullPath(n, sParameterKey2).toString();
            this.dataValues[i][1] = string2;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    void reset() {
        if (NsdAnsPane.db.on) {
            db.println("reset");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void handleApply() {
        this.executeAns();
        this.parent.setApplyEnabled(false);
        this.parent.setNextEnabled(false);
        this.parent.setFinishEnabled(true);
    }

    public void validatePage() throws Exception {
    }

    protected void handlePostValidate() {
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.NodeSetupWizard;
    }

    public void removeListeners() {
        super.removeListeners();
    }

    public void dispose() {
        super.dispose();
    }
}

