/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.nodesetup.CenterRenderer;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzNsdPane;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class NsdParamsPane
extends WzNsdPane {
    private JSplitPane js = new JSplitPane();
    private NsdWizardInfo.ColorPane logArea;
    private NsdWizardInfo wizInfo;
    private JPanel rowTextArea;
    private JPanel colTextArea;
    private List lst = null;
    private EntityTableModel entm = null;
    private IEntityModel ient = null;
    private NodeModelDelegate nodeModel;
    private NodeSetupDialog parent;
    private static final SDebug db = new SDebug("NsdParamsPane");
    private Vector paramStr;
    private String[] columnNames;
    private String[][] dataValues;
    private final int FIRST_WIDTH = 82;
    private final int SECOND_WIDTH = 50;
    static /* synthetic */ Class class$cerent$cms$idl$Common$eWavelength;

    public NsdParamsPane(NodeSetupDialog nodeSetupDialog, WzDiagDebug wzDiagDebug, NsdWizardInfo nsdWizardInfo, String string) {
        super(nodeSetupDialog, wzDiagDebug, string);
        this.parent = nodeSetupDialog;
        this.wizInfo = nsdWizardInfo;
        this.nodeModel = this.wizInfo.getNmd();
        this.entm = this.nodeModel.getEntityTableModel();
    }

    public void initPane() {
        this.setLayout(new BorderLayout(5, 5));
        this.js.setDividerLocation(375);
        this.js.setOneTouchExpandable(true);
        this.js.setContinuousLayout(true);
        this.js.setLeftComponent(this.createLeftPanel());
        this.js.setRightComponent(this.createRightPanel());
        this.parent.setApplyEnabled(true);
        this.parent.setButtonsEnabled(false, false);
        this.add((Component)this.js, "Center");
    }

    public void enteringPane() {
        this.initPane();
        if (db.on()) {
            db.println("enteringPage: start");
        }
        super.enteringPane();
    }

    public boolean handleBack() {
        this.rowTextArea.remove(this.colTextArea);
        this.colTextArea.remove(this.wizInfo.getLogArea());
        return super.handleBack();
    }

    protected String getNextPaneName() {
        if (this.wizInfo.isAnsSelected()) {
            return "ANS Parameters";
        }
        return null;
    }

    private JPanel createRightPanel() {
        this.rowTextArea = NsdParamsPane.createHorizontalPanel(null);
        this.colTextArea = NsdParamsPane.createVerticalPanel("Log");
        this.logArea = this.wizInfo.getLogArea();
        this.colTextArea.add((Component)new UScrollPane((Component)this.logArea));
        this.rowTextArea.add(this.colTextArea);
        return this.rowTextArea;
    }

    private JPanel createLeftPanel() {
        this.createColumns();
        this.createData();
        JTable jTable = new JTable(this.dataValues, this.columnNames){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setShowHorizontalLines(true);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(true);
        jTable.setAutoResizeMode(0);
        CenterRenderer centerRenderer = new CenterRenderer();
        for (int i = 0; i < 6; ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            if (i < 2) {
                tableColumn.setPreferredWidth(82);
            } else {
                tableColumn.setPreferredWidth(50);
            }
            tableColumn.setCellRenderer(centerRenderer);
        }
        UScrollPane uScrollPane = new UScrollPane((Component)jTable);
        JPanel jPanel = NsdParamsPane.createHorizontalPanel(null);
        JPanel jPanel2 = NsdParamsPane.createVerticalPanel("");
        jPanel2.add((Component)uScrollPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void createColumns() {
        this.columnNames = new String[6];
        this.columnNames[0] = "Name";
        this.columnNames[1] = "Value";
        this.columnNames[2] = "Shelf";
        this.columnNames[3] = "Slot";
        this.columnNames[4] = "PPM";
        this.columnNames[5] = "Port";
    }

    public void createData() {
        NsdWizardInfo.ParamStructure paramStructure = null;
        this.paramStr = this.wizInfo.getParams();
        this.dataValues = new String[this.paramStr.size()][6];
        for (int i = 0; i < this.paramStr.size(); ++i) {
            paramStructure = (NsdWizardInfo.ParamStructure)this.paramStr.elementAt(i);
            String string = paramStructure.shelf != null ? paramStructure.shelf : "x";
            String string2 = paramStructure.slot != null ? paramStructure.slot : "x";
            String string3 = paramStructure.ppm != null ? paramStructure.ppm : "x";
            String string4 = paramStructure.port != null ? paramStructure.port : "x";
            String string5 = paramStructure.paramName != null ? paramStructure.paramName : "";
            String string6 = paramStructure.paramValue != null ? paramStructure.paramValue : "";
            String string7 = null;
            string7 = string5.equalsIgnoreCase("OPT_AMP_L") ? (string6.equalsIgnoreCase("PRE_AMPLI") ? "OPT-PRE" : "OPT-LINE") : string6;
            this.dataValues[i][0] = string5;
            this.dataValues[i][1] = string7;
            this.dataValues[i][2] = string;
            this.dataValues[i][3] = string2;
            this.dataValues[i][4] = string3;
            this.dataValues[i][5] = string4;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    void reset() {
        if (NsdParamsPane.db.on) {
            db.println("reset");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void handleApply() {
        NsdWizardInfo.ParamStructure paramStructure = null;
        ModuleModel moduleModel = null;
        if (this.wizInfo.getFirstPane().equalsIgnoreCase("param")) {
            this.logArea.append(Color.BLUE, ">>>> Start Time " + this.wizInfo.getCurrentTimeStamp() + " <<<<\n");
            this.logArea.append(Color.BLUE, "------------------------------------------------");
        }
        this.logArea.append(Color.BLUE, "\n>> Starting Card Parameters Provisioning...\n");
        int n = 0;
        for (int i = 0; i < this.wizInfo.getParams().size(); ++i) {
            String string;
            String string2;
            String string3;
            block35: {
                paramStructure = (NsdWizardInfo.ParamStructure)this.wizInfo.getParams().elementAt(i);
                n = Integer.parseInt(paramStructure.slot);
                string3 = paramStructure.paramValue;
                string2 = paramStructure.paramName;
                string = paramStructure.port;
                int n2 = this.nodeModel.isMultishelf() ? Integer.parseInt(paramStructure.shelf) : 1;
                try {
                    this.ient = this.entm.getEntityModelBySlot(n2, n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (NsdParamsPane.db.on) {
                        db.println("No slot found");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: no slot found\n");
                    continue;
                }
                this.lst = this.ient.getChildren();
                if (this.lst != null && this.lst.size() > 0) {
                    try {
                        if (string2.equalsIgnoreCase("OPT_AMP_L")) {
                            moduleModel = (OpticsModuleModel)this.lst.get(0);
                            break block35;
                        }
                        if (string2.equalsIgnoreCase("WL")) {
                            moduleModel = (DwdmModuleModel)this.lst.get(0);
                            break block35;
                        }
                        this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong parameter name\n");
                    }
                    catch (ClassCastException classCastException) {
                        if (NsdParamsPane.db.on) {
                            db.println("Wrong card found");
                            SDebug.printStackTrace((Throwable)classCastException);
                        }
                        this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong card found\n");
                    }
                    continue;
                }
                this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: no card found\n");
                continue;
            }
            if (moduleModel.getEqType() == 240 && string2.equalsIgnoreCase("OPT_AMP_L")) {
                this.logArea.append(Color.BLUE, ">> Provisioning parameter OPT_AMP_L with value " + string3 + "\n");
                try {
                    if (string3.equalsIgnoreCase("PRE_AMPLI")) {
                        ((OpticsModuleModel)moduleModel).setAmpliRole(eOpticalAmplifierRole.PRE_AMPLI);
                    } else if (string3.equalsIgnoreCase("BST_AMPLI")) {
                        ((OpticsModuleModel)moduleModel).setAmpliRole(eOpticalAmplifierRole.BST_AMPLI);
                    } else {
                        this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong parameter value\n");
                        continue;
                    }
                    this.logArea.append(Color.BLUE, ">> Applied...\n");
                }
                catch (Exception exception) {
                    if (NsdParamsPane.db.on) {
                        db.println("Exception in provisioning parameter OPT_AMP_L");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    this.logArea.append(Color.RED, ">> Exception in provisioning parameter OPT_AMP_L\n");
                }
                continue;
            }
            if ((moduleModel.getEqType() == 184 || moduleModel.getEqType() == 182 || moduleModel.getEqType() == 119 || moduleModel.getEqType() == 243 || moduleModel.getEqType() == 183 || moduleModel.getEqType() == 121 || moduleModel.getEqType() == 181 || moduleModel.getEqType() == 118 || moduleModel.getEqType() == 120) && string2.equalsIgnoreCase("WL")) {
                eWavelength eWavelength2;
                DwdmTrkLineModel dwdmTrkLineModel;
                block36: {
                    this.logArea.append(Color.BLUE, ">> Provisioning parameter WL with value " + string3 + "nm\n");
                    dwdmTrkLineModel = null;
                    InterfaceModel[] interfaceModelArray = null;
                    IPortModel iPortModel = null;
                    int n3 = 0;
                    boolean bl = false;
                    interfaceModelArray = moduleModel.getLineModels();
                    for (int j = 0; j < interfaceModelArray.length; ++j) {
                        try {
                            if (!(interfaceModelArray[j] instanceof DwdmTrkLineModel) || (n3 = Integer.parseInt(PortHelper.getPortNumString((IPortModel)(iPortModel = ((DwdmTrkLineModel)interfaceModelArray[j]).getPortModel())))) != Integer.parseInt(string)) continue;
                            dwdmTrkLineModel = (DwdmTrkLineModel)interfaceModelArray[j];
                            bl = true;
                            break;
                        }
                        catch (Exception exception) {
                            if (NsdParamsPane.db.on) {
                                db.println("No port model found");
                                SDebug.printStackTrace((Throwable)exception);
                            }
                            this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: no port model found\n");
                        }
                    }
                    if (!bl) {
                        this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong port\n");
                        continue;
                    }
                    String string4 = string3;
                    eWavelength2 = null;
                    if (string4 != null) {
                        double d = Double.parseDouble(string4);
                        long l = (long)d;
                        long l2 = (long)((d - (double)l) * 1000.0) + 5L;
                        d = (double)l + (double)(l2 /= 10L) / 100.0;
                        String string5 = "" + d;
                        string5 = string5.replaceAll("\\.", "_");
                        string5 = string5.replaceAll(",", "_");
                        String string6 = "WV_" + string5;
                        try {
                            Field field = (class$cerent$cms$idl$Common$eWavelength == null ? NsdParamsPane.class$("cerent.cms.idl.Common.eWavelength") : class$cerent$cms$idl$Common$eWavelength).getField(string6);
                            eWavelength2 = (eWavelength)field.get(null);
                            if (!db.on()) break block36;
                            db.println("Found WL from mfg data: " + string4 + " == " + eWavelength2.value());
                        }
                        catch (Throwable throwable) {
                            if (db.on()) {
                                db.println("Cannot translate WL found in mfg data: " + string4 + ": " + throwable.getMessage());
                                SDebug.printStackTrace((Throwable)throwable);
                            }
                            this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong wavelength data\n");
                            continue;
                        }
                    }
                }
                try {
                    dwdmTrkLineModel.setWavelengthEnum(eWavelength2);
                }
                catch (Exception exception) {
                    if (NsdParamsPane.db.on) {
                        SDebug.printStackTrace((Throwable)exception);
                        db.println("Setting WL failed");
                    }
                    this.logArea.append(Color.RED, ">> Exception in provisioning parameter WL\n");
                    continue;
                }
                this.logArea.append(Color.BLUE, ">> Applied...\n");
                continue;
            }
            this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: card not present\n");
        }
        this.logArea.append(Color.BLUE, "------------------------------------------------\n");
        if (this.wizInfo.getLastPane().equalsIgnoreCase("param")) {
            this.logArea.append(Color.BLUE, ">>>> End Time " + this.wizInfo.getCurrentTimeStamp() + " <<<<");
        }
        if (this.getNextPaneName() != null) {
            this.parent.setApplyEnabled(false);
            this.parent.setNextEnabled(true);
        } else {
            this.parent.setApplyEnabled(false);
            this.parent.setNextEnabled(false);
        }
    }

    public void validatePage() throws Exception {
        this.rowTextArea.remove(this.colTextArea);
        this.colTextArea.remove(this.wizInfo.getLogArea());
    }

    protected void handlePostValidate() {
    }

    public void revalidateData() {
        if (NsdParamsPane.db.on) {
            db.println("revalidateData: entry");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.NodeSetupWizard;
    }

    public void removeListeners() {
        super.removeListeners();
    }

    public void dispose() {
        super.dispose();
    }
}

