/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.SDebug;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.List;

public class ParamsManager
extends WzTask {
    private NsdWizardInfo.ColorPane logArea;
    private NsdWizardInfo.CtmLog logCtm;
    private List lst = null;
    private IEntityModel ient = null;
    private EntityTableModel entm = null;
    private NodeModelDelegate node;
    private NsdWizardInfo wzInfo;
    private static final SDebug db = new SDebug("ParamsManager");
    static /* synthetic */ Class class$cerent$cms$idl$Common$eWavelength;

    public ParamsManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        if (nsdWizardInfo.isCtm()) {
            this.logCtm = nsdWizardInfo.getCtmLog();
        } else {
            this.logArea = nsdWizardInfo.getLogArea();
        }
        this.node = nodeModelDelegate;
        this.wzInfo = nsdWizardInfo;
        this.entm = this.node.getEntityTableModel();
        this.status = "idle";
    }

    public synchronized void doTask() {
        NsdWizardInfo.ParamStructure paramStructure = null;
        ModuleModel moduleModel = null;
        int n = 0;
        boolean bl = this.wzInfo.isCtm();
        this.status = "working";
        if (bl) {
            this.logCtm.append(">> Starting Card Parameters Provisioning...\n");
        } else {
            this.logArea.append(Color.BLUE, ">> Starting Card Parameters Provisioning...\n");
        }
        for (int i = 0; i < this.wzInfo.getParams().size(); ++i) {
            String string;
            String string2;
            String string3;
            block52: {
                paramStructure = (NsdWizardInfo.ParamStructure)this.wzInfo.getParams().elementAt(i);
                n = Integer.parseInt(paramStructure.slot);
                string3 = paramStructure.paramValue;
                string2 = paramStructure.paramName;
                string = paramStructure.port;
                int n2 = this.node.isMultishelf() ? Integer.parseInt(paramStructure.shelf) : 1;
                try {
                    this.ient = this.entm.getEntityModelBySlot(n2, n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (ParamsManager.db.on) {
                        db.println("No slot found");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    if (bl) {
                        this.logCtm.append(">> " + string2 + " could not be provisioned: no slot found\n");
                        continue;
                    }
                    this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: no slot found\n");
                    continue;
                }
                this.lst = this.ient.getChildren();
                if (this.lst != null && this.lst.size() > 0) {
                    try {
                        if (string2.equalsIgnoreCase("OPT_AMP_L")) {
                            moduleModel = (OpticsModuleModel)this.lst.get(0);
                            break block52;
                        }
                        if (string2.equalsIgnoreCase("WL")) {
                            moduleModel = (DwdmModuleModel)this.lst.get(0);
                            break block52;
                        }
                        if (bl) {
                            this.logCtm.append(">> " + string2 + " could not be provisioned: wrong parameter name\n");
                            continue;
                        }
                        this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong parameter name\n");
                    }
                    catch (ClassCastException classCastException) {
                        if (ParamsManager.db.on) {
                            db.println("Wrong card found");
                            SDebug.printStackTrace((Throwable)classCastException);
                        }
                        if (bl) {
                            this.logCtm.append(">> " + string2 + " could not be provisioned: wrong card found\n");
                            continue;
                        }
                        this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong card found\n");
                    }
                    continue;
                }
                if (bl) {
                    this.logCtm.append(">> " + string2 + " could not be provisioned: no card found\n");
                    continue;
                }
                this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: no card found\n");
                continue;
            }
            if (moduleModel.getEqType() == 240 && string2.equalsIgnoreCase("OPT_AMP_L")) {
                if (bl) {
                    this.logCtm.append(">> Provisioning parameter OPT_AMP_L with value " + string3 + "\n");
                } else {
                    this.logArea.append(Color.BLUE, ">> Provisioning parameter OPT_AMP_L with value " + string3 + "\n");
                }
                try {
                    if (string3.equalsIgnoreCase("PRE_AMPLI")) {
                        ((OpticsModuleModel)moduleModel).setAmpliRole(eOpticalAmplifierRole.PRE_AMPLI);
                    } else if (string3.equalsIgnoreCase("BST_AMPLI")) {
                        ((OpticsModuleModel)moduleModel).setAmpliRole(eOpticalAmplifierRole.BST_AMPLI);
                    } else {
                        if (bl) {
                            this.logCtm.append(">> " + string2 + " could not be provisioned: wrong parameter value\n");
                            continue;
                        }
                        this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong parameter value\n");
                        continue;
                    }
                    if (bl) {
                        this.logCtm.append(">> Applied...\n");
                        continue;
                    }
                    this.logArea.append(Color.BLUE, ">> Applied...\n");
                }
                catch (Exception exception) {
                    if (ParamsManager.db.on) {
                        db.println("Exception in provisioning parameter OPT_AMP_L");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    if (bl) {
                        this.logCtm.append(">> Exception in provisioning parameter OPT_AMP_L\n");
                        continue;
                    }
                    this.logArea.append(Color.RED, ">> Exception in provisioning parameter OPT_AMP_L\n");
                }
                continue;
            }
            if ((moduleModel.getEqType() == 184 || moduleModel.getEqType() == 182 || moduleModel.getEqType() == 119 || moduleModel.getEqType() == 243 || moduleModel.getEqType() == 183 || moduleModel.getEqType() == 121 || moduleModel.getEqType() == 181 || moduleModel.getEqType() == 118 || moduleModel.getEqType() == 120) && string2.equalsIgnoreCase("WL")) {
                eWavelength eWavelength2;
                DwdmTrkLineModel dwdmTrkLineModel;
                block53: {
                    if (bl) {
                        this.logCtm.append(">> Provisioning parameter WL with value " + string3 + "nm\n");
                    } else {
                        this.logArea.append(Color.BLUE, ">> Provisioning parameter WL with value " + string3 + "nm\n");
                    }
                    dwdmTrkLineModel = null;
                    InterfaceModel[] interfaceModelArray = null;
                    IPortModel iPortModel = null;
                    int n3 = 0;
                    boolean bl2 = false;
                    interfaceModelArray = moduleModel.getLineModels();
                    for (int j = 0; j < interfaceModelArray.length; ++j) {
                        try {
                            if (!(interfaceModelArray[j] instanceof DwdmTrkLineModel) || (n3 = Integer.parseInt(PortHelper.getPortNumString((IPortModel)(iPortModel = ((DwdmTrkLineModel)interfaceModelArray[j]).getPortModel())))) != Integer.parseInt(string)) continue;
                            dwdmTrkLineModel = (DwdmTrkLineModel)interfaceModelArray[j];
                            bl2 = true;
                            break;
                        }
                        catch (Exception exception) {
                            if (ParamsManager.db.on) {
                                db.println("No port model found");
                                SDebug.printStackTrace((Throwable)exception);
                            }
                            if (bl) {
                                this.logCtm.append(">> " + string2 + " could not be provisioned: no port model found\n");
                                continue;
                            }
                            this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: no port model found\n");
                        }
                    }
                    if (!bl2) {
                        if (bl) {
                            this.logCtm.append(">> " + string2 + " could not be provisioned: wrong port\n");
                            continue;
                        }
                        this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong port\n");
                        continue;
                    }
                    String string4 = string3;
                    eWavelength2 = null;
                    if (string4 != null) {
                        double d = Double.parseDouble(string4);
                        long l = (long)d;
                        long l2 = (long)((d - (double)l) * 1000.0) + 5L;
                        d = (double)l + (double)(l2 /= 10L) / 100.0;
                        String string5 = "" + d;
                        string5 = string5.replaceAll("\\.", "_");
                        string5 = string5.replaceAll(",", "_");
                        String string6 = "WV_" + string5;
                        try {
                            Field field = (class$cerent$cms$idl$Common$eWavelength == null ? ParamsManager.class$("cerent.cms.idl.Common.eWavelength") : class$cerent$cms$idl$Common$eWavelength).getField(string6);
                            eWavelength2 = (eWavelength)field.get(null);
                            if (!db.on()) break block53;
                            db.println("Found WL from mfg data: " + string4 + " == " + eWavelength2.value());
                        }
                        catch (Throwable throwable) {
                            if (db.on()) {
                                db.println("Cannot translate WL found in mfg data: " + string4 + ": " + throwable.getMessage());
                                SDebug.printStackTrace((Throwable)throwable);
                            }
                            if (bl) {
                                this.logCtm.append(">> " + string2 + " could not be provisioned: wrong wavelength data\n");
                                continue;
                            }
                            this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: wrong wavelength data\n");
                            continue;
                        }
                    }
                }
                try {
                    dwdmTrkLineModel.setWavelengthEnum(eWavelength2);
                }
                catch (Exception exception) {
                    if (ParamsManager.db.on) {
                        SDebug.printStackTrace((Throwable)exception);
                        db.println("Setting WL failed");
                    }
                    if (bl) {
                        this.logCtm.append(">> Exception in provisioning parameter WL\n");
                        continue;
                    }
                    this.logArea.append(Color.RED, ">> Exception in provisioning parameter WL\n");
                    continue;
                }
                if (bl) {
                    this.logCtm.append(">> Applied...\n");
                    continue;
                }
                this.logArea.append(Color.BLUE, ">> Applied...\n");
                continue;
            }
            if (bl) {
                this.logCtm.append(">> " + string2 + " could not be provisioned: card not present\n");
                continue;
            }
            this.logArea.append(Color.RED, ">> " + string2 + " could not be provisioned: card not present\n");
        }
        if (bl) {
            this.logCtm.append("------------------------------------------------");
        } else {
            this.logArea.append(Color.BLUE, "------------------------------------------------");
        }
        this.status = "completed";
    }

    public String getStatus() {
        return this.status;
    }
}

