/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.UnimplementedPane;
import cerent.cms.ui.oadm.OadmOpticalThresholdPane;
import cerent.cms.ui.oscm.OscmOTSProvPane;
import cerent.cms.ui.oscm.OscmOcLineProvPane;
import cerent.cms.ui.oscm.OscmThresholdProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class OsccsmProvpane
extends NodeProvPane
implements ITabName {
    protected TdmLineModel[] lineModels = null;
    private OpticsModuleModel model = (OpticsModuleModel)this.getUiModel();
    private OpticsLineModel[] otsModels;
    private static final SDebug db = new SDebug("OsccsmProvpane");

    public OsccsmProvpane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.lineModels = ((OpticsModuleModel)this.getUiModel()).getTdmLineModels();
        this.otsModels = this.model.getOpticsLineModels();
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        if (this.pci.is455()) {
            this.subTabs.addTab("STM-1 Line", (Component)this.getOc3ProvTabs(this.subTabs));
        } else {
            this.subTabs.addTab("OC3 Line", (Component)this.getOc3ProvTabs(this.subTabs));
        }
        this.subTabs.addTab("Optical Line", (Component)this.getOtsProvTabs(this.subTabs, this.otsModels));
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        int n = this.uiModel.getNodeModel().getFramingType();
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    protected Pane getOtsProvTabs(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
        return new OscmOtsProvPane(tabbedView, opticsLineModelArray);
    }

    protected Pane getOc3ProvTabs(TabbedView tabbedView) {
        return new OscmOc3ProvPane(tabbedView);
    }

    protected Pane getOptThresholdsPane(OpticsLineModel[] opticsLineModelArray) {
        return new OadmOpticalThresholdPane("Optics Thresholds", this.getParentView(), opticsLineModelArray);
    }

    protected Pane getOc3ThresholdsPane() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new OscmThresholdProvPane("OC3 Line Thresholds", this.getParentView(), this.lineModels));
    }

    protected Pane getThresholdsPane() {
        return null;
    }

    protected Pane getLOProvTab() {
        return new UnimplementedPane("SONET VT", this.getParentView());
    }

    protected Pane getHOProvTab() {
        return null;
    }

    protected Pane getLineProvTab() {
        return new OscmOcLineProvPane("Line", this.getParentView());
    }

    protected Pane getOTSProvTab(OpticsLineModel[] opticsLineModelArray) {
        return new OscmOTSProvPane("Line", this.getParentView(), opticsLineModelArray);
    }

    public boolean hasSubTabs() {
        return true;
    }

    protected TdmLineModel[] getLines(OpticsModuleModel opticsModuleModel) {
        TdmPortModel[] tdmPortModelArray = null;
        TdmLineModel[] tdmLineModelArray = null;
        try {
            tdmPortModelArray = opticsModuleModel.getOC3Children();
            if (db.on()) {
                db.println("number of Sonet Ports " + tdmPortModelArray.length);
            }
            tdmLineModelArray = new TdmLineModel[tdmPortModelArray.length];
            for (int i = 0; i < tdmPortModelArray.length; ++i) {
                tdmLineModelArray[i] = tdmPortModelArray[i].getTdmLineModel();
            }
        }
        catch (Exception exception) {
            db.println("Error in getting interface lines" + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return tdmLineModelArray;
    }

    private class OscmOc3ProvPane
    extends NodeProvPane {
        public OscmOc3ProvPane(TabbedView tabbedView) {
            super("OscmOc3ProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            if (this.pci.is455()) {
                this.subTabs.addTab("STM-1 Line", (Component)OsccsmProvpane.this.getLineProvTab());
                this.subTabs.addTab("SDH Thresholds", (Component)OsccsmProvpane.this.getOc3ThresholdsPane());
            } else {
                this.subTabs.addTab("OC3 Line", (Component)OsccsmProvpane.this.getLineProvTab());
                this.subTabs.addTab("SONET Thresholds", (Component)OsccsmProvpane.this.getOc3ThresholdsPane());
            }
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }

    private class OscmOtsProvPane
    extends NodeProvPane {
        public OscmOtsProvPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("OscmOtsProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)OsccsmProvpane.this.getOTSProvTab(opticsLineModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)OsccsmProvpane.this.getOptThresholdsPane(opticsLineModelArray));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }
}

