/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Optics.eOSRIStatus;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.oscm.OscmMaintAlsPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class OscmAlsPane
extends AbstractPane {
    protected OpticsModuleModel model;
    protected AlsButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String OSRI_ON_TH_PANEL = "OSRI_ON_TH";
    protected static final String OSRI_OFF_TH_PANEL = "OSRI_OFF_TH";
    protected static final String OSRI_TH_PANEL = "OSRI_TH";
    protected static final int OSRI_ON_TH = 0;
    protected static final int OSRI_OFF_TH = 1;
    protected static final int OSRI_TH = 2;
    private String tableLabelString = new String();
    private JPanel labeledTablePanel = null;
    private int selection_type = 0;
    private static final SDebug db = new SDebug("AmplifierAlsPane");

    public OscmAlsPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel) {
        super(string, tabbedView);
        this.model = (OpticsModuleModel)this.getUiModel();
        this.panes = new Pane[4];
        this.initializeLayout();
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getTablePanel(), "Center");
    }

    protected AlsButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new AlsButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.panes[0] = this.getAlsMantPane(OSRI_ON_TH_PANEL, 0);
        this.tablePanel.add((Component)this.panes[0], OSRI_ON_TH_PANEL);
        this.panes[1] = this.getAlsMantPane(OSRI_OFF_TH_PANEL, 1);
        this.tablePanel.add((Component)this.panes[1], OSRI_OFF_TH_PANEL);
        this.panes[2] = this.getAlsMantPane(OSRI_TH_PANEL, 2);
        this.tablePanel.add((Component)this.panes[2], OSRI_TH_PANEL);
        this.cl.show(this.tablePanel, OSRI_ON_TH_PANEL);
        this.currentPane = this.panes[0];
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected OscmMaintAlsPane getAlsMantPane(String string, int n) {
        return new OscmMaintAlsPane(string, this.getParentView(), this.model, n);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        this.getButtonPanel().EnterigPageAction();
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (null == this.panes[i]) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected void setColumnW(int n) {
        TableColumn tableColumn = null;
        block4: for (int i = 0; i < n; ++i) {
            tableColumn = this.currentPane.getTable().getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(90);
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    tableColumn.setPreferredWidth(120);
                }
            }
        }
    }

    protected class AlsButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonOSRIOn;
        public JRadioButton buttonOSRIOff;
        public JButton showButton = new JButton("Refresh");
        public JButton ManResButton = new JButton("Manual Restart");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup OSRIButtonGroup;
        protected int OSRI_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public AlsButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.buttonOSRIOn = new JRadioButton("On", true);
            this.buttonOSRIOff = new JRadioButton("Off");
            this.OSRIButtonGroup = new ButtonGroup();
            this.OSRIButtonGroup.add(this.buttonOSRIOn);
            this.OSRIButtonGroup.add(this.buttonOSRIOff);
            this.showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AlsButtonPanel.this.refreshAction();
                }
            });
            this.ManResButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.buttonOSRIOn.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        OscmAlsPane.this.selection_type = 0;
                    } else {
                        OscmAlsPane.this.selection_type = 2;
                    }
                }
            });
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" OSRI "));
            jPanel.setPreferredSize(dimension);
            jPanel.add((Component)this.buttonOSRIOn, "North");
            jPanel.add((Component)this.buttonOSRIOff, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(this.showButton);
            this.add(this.ManResButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void refreshAction() {
            int n = 0;
            OscmAlsPane.this.selection_type = 0;
            OscmAlsPane.this.tableLabelString = " ";
            if (this.OSRIButtonGroup.getSelection() == this.buttonOSRIOff.getModel()) {
                if (db.on()) {
                    db.println("OSRI Off");
                }
                n = this.OSRI_MASK;
                OscmAlsPane.this.selection_type = this.OSRI_MASK;
                OscmAlsPane.this.tableLabelString = OscmAlsPane.this.tableLabelString + "OSRI Off";
                try {
                    OscmAlsPane.this.model.setOSRIStatus(eOSRIStatus.OSRI_OFF);
                }
                catch (Exception exception) {}
            } else {
                OscmAlsPane.this.tableLabelString = OscmAlsPane.this.tableLabelString + "OSRI On";
                try {
                    OscmAlsPane.this.model.setOSRIStatus(eOSRIStatus.OSRI_ON);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("OSRI On");
                    }
                    OscmAlsPane.this.showPanel(OscmAlsPane.this.panes[0]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("OSRI Off");
                    }
                    OscmAlsPane.this.showPanel(OscmAlsPane.this.panes[1]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("OSRI");
                    }
                    OscmAlsPane.this.showPanel(OscmAlsPane.this.panes[2]);
                }
            }
        }

        public void EnterigPageAction() {
            int n = 0;
            OscmAlsPane.this.selection_type = 0;
            OscmAlsPane.this.tableLabelString = " ";
            if (this.OSRIButtonGroup.getSelection() == this.buttonOSRIOff.getModel()) {
                if (db.on()) {
                    db.println("OSRI Off");
                }
                n = this.OSRI_MASK;
                OscmAlsPane.this.selection_type = this.OSRI_MASK;
                OscmAlsPane.this.tableLabelString = OscmAlsPane.this.tableLabelString + "OSRI Off";
            } else {
                OscmAlsPane.this.tableLabelString = OscmAlsPane.this.tableLabelString + "OSRI On";
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("OSRI On");
                    }
                    OscmAlsPane.this.showPanel(OscmAlsPane.this.panes[0]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("OSRI Off");
                    }
                    OscmAlsPane.this.showPanel(OscmAlsPane.this.panes[1]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("OSRI");
                    }
                    OscmAlsPane.this.showPanel(OscmAlsPane.this.panes[2]);
                }
            }
        }
    }
}

