/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.model.FramingType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.HoPathPmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OscmHoPathPmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    protected HoPathPmThresholdsTableModel dataModel = null;
    protected TdmHoModel[] hoModels = null;
    protected InterfaceModel[] lineModels = null;
    protected int indexOfHo;
    protected int numHo = 0;
    protected int numLines = 0;
    protected OpticsModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    protected Observer strucChangeObserver = null;
    private static final SDebug db = new SDebug("HoPathPmThresholdsPane");

    public OscmHoPathPmThresholdsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, eIntervalType eIntervalType2, boolean bl, int n) {
        super(string, tabbedView);
        if (db.on()) {
            db.println("<init>( " + string + ", " + tabbedView.getClass().getName() + ", " + "InterfaceModel[ " + interfaceModelArray.length + " ], " + eIntervalType2 + ", " + bl + ", " + n + " )");
        }
        TableColumn tableColumn = null;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.lineModels = interfaceModelArray;
        this.indexOfHo = n;
        this.hoModels = this.getHo(interfaceModelArray, n);
        this.numLines = 1;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        IFramingType iFramingType = FramingType.getFramingType((int)tabbedView.getUiModel().getNodeModel().getFramingType());
        if (iFramingType.isSdh()) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
            this.table.removeColumn(tableColumn);
        } else {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
            this.table.removeColumn(tableColumn);
        }
        this.numHo = this.hoModels == null ? 0 : this.hoModels.length;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(150);
        this.table.setAutoCreateColumnsFromModel(false);
        this.strucChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                Integer n;
                if (db.on()) {
                    db.println("Got an update from linemodel");
                }
                if (object instanceof Integer && (n = (Integer)object).equals(ModelUpdateType.ADDED)) {
                    OscmHoPathPmThresholdsPane.this.initializeLines();
                }
            }
        };
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    protected TdmHoModel[] getHo(InterfaceModel[] interfaceModelArray, int n) {
        Collection collection;
        if (db.on()) {
            db.println("getHo( InterfaceModel[ " + interfaceModelArray.length + " ], " + n + " )");
        }
        if ((collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, n)) == null) {
            if (db.on()) {
                db.println("Error in getting Ho lines");
            }
            return null;
        }
        if (db.on()) {
            db.println("Returning Hos " + collection.size());
        }
        return collection.toArray(new TdmHoModel[0]);
    }

    protected synchronized void initializeLines() {
        if (db.on()) {
            db.println("initializeLines");
        }
        this.dispose();
        this.hoModels = this.getHo(this.lineModels, this.indexOfHo);
        this.numHo = this.hoModels == null ? 0 : this.hoModels.length;
        this.registerWithModel();
        this.dataModel.setHoModel(this.hoModels);
    }

    protected HoPathPmThresholdsTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new HoPathPmThresholdsTableModel(iNodeModel, this.lineModels, this.hoModels, this.intervalType, this.nearEnd);
    }

    protected void registerWithModel() {
        int n;
        for (n = 0; n < this.numHo; ++n) {
            this.hoModels[n].addObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.numLines; ++n) {
            this.lineModels[n].addObserver(this.strucChangeObserver);
        }
    }

    public void dispose() {
        int n;
        for (n = 0; n < this.numHo; ++n) {
            this.hoModels[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.numLines; ++n) {
            this.lineModels[n].deleteObserver(this.strucChangeObserver);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (db.on()) {
                    db.println("Got an Update Message for " + observable);
                }
                final Observable observable2 = observable;
                this.requestRefresh(observable2, new Runnable(){

                    public void run() {
                        OscmHoPathPmThresholdsPane.this.refreshLine(observable2);
                    }
                });
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (db.on()) {
                    db.println("GOT A DELETED MESSAGE ");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        OscmHoPathPmThresholdsPane.this.initializeLines();
                    }
                });
            }
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.hoModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In HoPathPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            if (db.on()) {
                db.println("Applying changes");
            }
            for (n = 0; n < this.numHo; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printStats(this.dataModel.getThresholdsVal(n));
                this.hoModels[n].setPmThresholds(this.nearEnd, this.intervalType, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.numHo; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void printStats(sPathThresholds sPathThresholds2) {
        if (db.on()) {
            db.println("===============================================");
        }
        if (db.on()) {
            db.println("CV " + sPathThresholds2.cv);
        }
        if (db.on()) {
            db.println("ES " + sPathThresholds2.es);
        }
        if (db.on()) {
            db.println("SES " + sPathThresholds2.ses);
        }
        if (db.on()) {
            db.println("FC " + sPathThresholds2.fc);
        }
        if (db.on()) {
            db.println("UAS " + sPathThresholds2.uas);
        }
        if (db.on()) {
            db.println("BBE " + sPathThresholds2.bbe);
        }
        if (db.on()) {
            db.println("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OscmHoPathPmThresholdsPane;
    }
}

