/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Optics.PM_OPTICS_UNDEFINED;
import cerent.cms.idl.Optics.eRingDirection;
import cerent.cms.idl.Optics.eVOAControlMode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.oadm.OpticalTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;

public class OscmOTSTableModel
extends OpticalTableModel
implements PM_OPTICS_UNDEFINED,
IAdminTableAccess {
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int RING_DIRECTION_INDEX = 4;
    public static final int ACTUAL_POWER_INDEX = 5;
    public static final int VOA_MODE_INDEX = 6;
    public static final int POWER_REF_INDEX = 7;
    public static final int POWER_CAL_INDEX = 8;
    public static final int VOA_POWREF_INDEX = 9;
    public static final int VOA_POWCAL_INDEX = 10;
    public static final int VOA_ATTENREF_INDEX = 11;
    public static final int VOA_ATTENCAL_INDEX = 12;
    public static final int SOAK_TIME_INDEX = 13;
    public static final String[] columnNames = new String[]{"Port", " Port Name", "Admin State", "Service State", "Line Direction", "Power", "VOA Mode", "Power Ref.", "Power Calib.", "VOA Power Ref.", "VOA Power Calib.", "VOA Attenuation Ref.", "VOA Attenuation Calib.", "AINS Soak"};
    public static final int OUT_OF_SERVICE = 1;
    public static final int IN_SERVICE = 0;
    public static final int OOS_MT = 2;
    public static final int IS_AINS = 3;
    public static final int WEST_TO_EAST = 1;
    public static final int EAST_TO_WEST = 0;
    public static final int CONSTANT_ATTENUATION = 1;
    public static final int CONSTANT_POWER = 0;
    public static final int UNDEFINED = -1000000;
    public static final int VALUE_OUT_OF_RANGE = 3;
    public static final int THR_ADJUST_FAILED = 6;
    public static final int POWER_CALIBRATION_NOT_ALLOWED = 7;
    public static final String[] ringDirectionStrings = new String[]{"East to West", "West to East"};
    public static final String[] VOAModeStrings = new String[]{"Constant Power", "Constant Attenuation"};
    public static final String[] WavelengthStrings = new String[]{"1530.33", "1531.12", "1531.90", "1532.68", "1534.25", "1535.04", "1535.82", "1536.61", "1538.19", "1538.98", "1539.77", "1540.58", "1542.14", "1542.94", "1543.73", "1544.53", "1546.12", "1546.92", "1547.72", "1548.51", "1550.12", "1550.92", "1551.72", "1552.52", "1554.13", "1554.94", "1555.75", "1556.55", "1558.17", "1558.98", "1559.79", "1560.61"};
    public static final String[] Oadm2Chn_1_2_WavelengthStrings = new String[]{"1530.33", "1531.90", "1534.25", "1535.82", "1538.19", "1539.77", "1542.14", "1543.73", "1546.12", "1547.72", "1550.12", "1551.72", "1554.13", "1555.75", "1558.17", "1559.79"};
    public static final String[] Oadm2Chn_3_4_WavelengthStrings = new String[]{"1531.12", "1532.68", "1535.04", "1536.61", "1538.98", "1540.56", "1542.94", "1544.53", "1546.92", "1548.51", "1550.92", "1552.52", "1554.94", "1556.55", "1558.98", "1560.61"};
    public static final String[] Oadm4Chn_1_2_WavelengthStrings = new String[]{"1530.33", "1534.25", "1538.19", "1542.14", "1546.12", "1550.12", "1554.13", "1558.17"};
    public static final String[] Oadm4Chn_3_4_WavelengthStrings = new String[]{"1531.12", "1535.04", "1538.98", "1542.94", "1546.92", "1550.92", "1554.94", "1558.98"};
    public static final String[] Oadm4Chn_5_6_WavelengthStrings = new String[]{"1531.90", "1535.82", "1539.77", "1543.73", "1547.72", "1551.72", "1555.75", "1559.79"};
    public static final String[] Oadm4Chn_7_8_WavelengthStrings = new String[]{"1532.68", "1536.61", "1540.58", "1544.53", "1548.51", "1552.52", "1556.55", "1560.61"};
    public static final String[] Oadm1Band_1_2_WavelengthStrings = new String[]{"1530.33", "1534.25", "1538.19", "1542.14", "1546.12", "1550.12", "1554.13", "1558.17"};
    public static final String[] Oadm4Band_1_2_WavelengthStrings = new String[]{"1530.33", "1546.12"};
    public static final String[] Oadm4Band_3_4_WavelengthStrings = new String[]{"1534.2", "1550.1"};
    public static final String[] Oadm4Band_5_6_WavelengthStrings = new String[]{"1538.1", "1554.1"};
    public static final String[] Oadm4Band_7_8_WavelengthStrings = new String[]{"1542.1", "1558.1"};
    private AdminState[] adminState = new AdminState[this.numLines];
    private IServiceState[] serviceState = new IServiceState[this.numLines];
    private int[] expectedWavelength;
    private int[] actualWavelength;
    private int[] ringDirection;
    private int[] actualPower = new int[this.numLines];
    private int[] VOAMode;
    private String[] VOAAttenCal;
    private String[] VOAPowerCal;
    private String[] PowerCal;
    private String[] actPower;
    private Attribute[] wavelength;
    private boolean[][] isDirty;
    int waveL;
    private int numChars = 0;
    private boolean[][] Flg_FeatureUnsupported;
    private boolean FlgOkDialog = false;
    private boolean FlgAdminStateChanged = false;
    private static final SDebug db = new SDebug("OscmOTSTableModel");

    public OscmOTSTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(db, abstractOpticsLineModelArray);
        this.expectedWavelength = new int[this.numLines];
        this.actualWavelength = new int[this.numLines];
        this.ringDirection = new int[this.numLines];
        this.VOAMode = new int[this.numLines];
        this.VOAAttenCal = new String[this.numLines];
        this.VOAPowerCal = new String[this.numLines];
        this.wavelength = new Attribute[this.numLines];
        this.PowerCal = new String[this.numLines];
        this.actPower = new String[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.Flg_FeatureUnsupported = new boolean[this.numLines][this.getColumnCount()];
        for (int i = 0; i < this.numLines; ++i) {
            this.actualPower[i] = -1;
            this.VOAMode[i] = -1;
            this.ringDirection[i] = -1;
            this.expectedWavelength[i] = -1;
            this.actualWavelength[i] = -1;
            this.VOAAttenCal[i] = null;
            this.VOAPowerCal[i] = null;
            this.PowerCal[i] = null;
            this.actPower[i] = null;
        }
        this.resetDirtyBits();
        this.setFeatureUnsupported();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public String[] getWavelengthStrings() {
        return WavelengthStrings;
    }

    public String[] getOadm2Chn_1_2_WavelengthStrings() {
        return Oadm2Chn_1_2_WavelengthStrings;
    }

    public String[] getOadm2Chn_3_4_WavelengthStrings() {
        return Oadm2Chn_3_4_WavelengthStrings;
    }

    public String[] getOadm4Chn_1_2_WavelengthStrings() {
        return Oadm4Chn_1_2_WavelengthStrings;
    }

    public String[] getOadm4Chn_3_4_WavelengthStrings() {
        return Oadm4Chn_3_4_WavelengthStrings;
    }

    public String[] getOadm4Chn_5_6_WavelengthStrings() {
        return Oadm4Chn_5_6_WavelengthStrings;
    }

    public String[] getOadm4Chn_7_8_WavelengthStrings() {
        return Oadm4Chn_7_8_WavelengthStrings;
    }

    public String[] getOadm1Band_1_2_WavelengthStrings() {
        return Oadm1Band_1_2_WavelengthStrings;
    }

    public String[] getOadm4Band_1_2_WavelengthStrings() {
        return Oadm4Band_1_2_WavelengthStrings;
    }

    public String[] getOadm4Band_3_4_WavelengthStrings() {
        return Oadm4Band_3_4_WavelengthStrings;
    }

    public String[] getOadm4Band_5_6_WavelengthStrings() {
        return Oadm4Band_5_6_WavelengthStrings;
    }

    public String[] getOadm4Band_7_8_WavelengthStrings() {
        return Oadm4Band_7_8_WavelengthStrings;
    }

    public String[] getringDirectionStrings() {
        return ringDirectionStrings;
    }

    private String getSoakTimeString(int n) throws NoSuchInterface {
        return "00:00 (H:M)";
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4) {
            return true;
        }
        if (n2 == 8 || n2 == 10 || n2 == 12) {
            return !this.Flg_FeatureUnsupported[n][n2];
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescription(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 3: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 4: {
                    return this.getRingDirection(n);
                }
                case 5: {
                    return this.actPower[n];
                }
                case 7: {
                    return this.getPowerRef(n);
                }
                case 8: {
                    return this.getPowerCal(n);
                }
                case 6: {
                    return this.getVOAMode(n);
                }
                case 9: {
                    return this.getVOARefPower(n);
                }
                case 10: {
                    return this.getVOAPowerCal(n);
                }
                case 11: {
                    return this.getVOAAttenuationRef(n);
                }
                case 12: {
                    return this.getVOAAttenuationCal(n);
                }
                case 13: {
                    return this.getSoakTimeString(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OadmParametersTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 2: {
                    if (((AdminState)object).equals(this.adminState[n])) {
                        return;
                    }
                    this.adminState[n] = (AdminState)object;
                    break;
                }
                case 4: {
                    int n3 = this.getIndexOf((String)object, ringDirectionStrings);
                    if (this.ringDirection[n] == n3) {
                        return;
                    }
                    this.ringDirection[n] = n3;
                    break;
                }
                case 8: {
                    this.PowerCal[n] = (String)object;
                    break;
                }
                case 12: {
                    this.VOAAttenCal[n] = (String)object;
                    break;
                }
                case 10: {
                    this.VOAPowerCal[n] = (String)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private String getPortDescription(int n) {
        String string;
        Object object;
        try {
            object = this.model[n].getPortModel();
            string = PortHelper.getPortNumString((IPortModel)object);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            string = String.valueOf(n + 1);
        }
        object = string + " (" + this.getType(n) + ")";
        return object;
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.model[n].getAdminStateEnum();
    }

    public AdminState getAdminState(int n) throws Exception {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private String getType(int n) {
        try {
            return this.model[n].getPortTypeString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getVOAMode(int n) {
        if (this.VOAMode[n] == -1) {
            try {
                eVOAControlMode eVOAControlMode2 = this.model[n] != null ? this.model[n].getVoaMode() : eVOAControlMode.ATTENUATION_CONTROL;
                this.VOAMode[n] = eVOAControlMode2 == eVOAControlMode.ATTENUATION_CONTROL ? 1 : 0;
            }
            catch (Exception exception) {
                return "N/A";
            }
        }
        return VOAModeStrings[this.VOAMode[n]];
    }

    private String getActPower(int n) {
        try {
            String string = new Integer(this.model[n].getActualPower()).toString();
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getInsertionLoss(int n) {
        try {
            return new Integer(this.model[n].getInsertionLoss()).toString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getPowerRef(int n) {
        try {
            int n2 = this.model[n].getReferencePower();
            if (n2 == -1000000) {
                return "N/A";
            }
            String string = new Integer(n2).toString();
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getVOARefPower(int n) {
        try {
            int n2 = this.model[n].getVoaReferencePower();
            if (n2 == -1000000) {
                return "N/A";
            }
            String string = new Integer(n2).toString();
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getPowerCal(int n) {
        if (this.PowerCal[n] == null) {
            this.Flg_FeatureUnsupported[n][8] = false;
            try {
                int n2 = this.model[n].getCalibratedPower();
                if (n2 == -1000000) {
                    this.PowerCal[n] = "N/A";
                    this.Flg_FeatureUnsupported[n][8] = true;
                    return this.PowerCal[n];
                }
                this.PowerCal[n] = new Integer(n2).toString();
                this.numChars = this.PowerCal[n].startsWith("-") ? 2 : 1;
                this.PowerCal[n] = this.PowerCal[n].length() > this.numChars ? this.PowerCal[n].substring(0, this.PowerCal[n].length() - 1) + "." + this.PowerCal[n].substring(this.PowerCal[n].length() - 1) : (this.numChars == 2 ? this.PowerCal[n].substring(0, 1) + "0." + this.PowerCal[n].substring(1, this.PowerCal[n].length()) : "0." + this.PowerCal[n]);
            }
            catch (Exception exception) {
                this.PowerCal[n] = "N/A";
                this.Flg_FeatureUnsupported[n][8] = true;
                return this.PowerCal[n];
            }
        }
        return this.PowerCal[n];
    }

    private String getVOAPowerCal(int n) {
        if (this.VOAPowerCal[n] == null) {
            this.Flg_FeatureUnsupported[n][10] = false;
            try {
                int n2 = this.model[n].getVoaCalibrationPower();
                if (n2 == -1000000) {
                    this.VOAPowerCal[n] = "N/A";
                    this.Flg_FeatureUnsupported[n][10] = true;
                    return this.VOAPowerCal[n];
                }
                this.VOAPowerCal[n] = new Integer(n2).toString();
                this.numChars = this.VOAPowerCal[n].startsWith("-") ? 2 : 1;
                this.VOAPowerCal[n] = this.VOAPowerCal[n].length() > this.numChars ? this.VOAPowerCal[n].substring(0, this.VOAPowerCal[n].length() - 1) + "." + this.VOAPowerCal[n].substring(this.VOAPowerCal[n].length() - 1) : (this.numChars == 2 ? this.VOAPowerCal[n].substring(0, 1) + "0." + this.VOAPowerCal[n].substring(1, this.VOAPowerCal[n].length()) : "0." + this.VOAPowerCal[n]);
            }
            catch (Exception exception) {
                this.VOAPowerCal[n] = "N/A";
                this.Flg_FeatureUnsupported[n][10] = true;
                return this.VOAPowerCal[n];
            }
        }
        return this.VOAPowerCal[n];
    }

    private void setPowerCal(int n) {
        if (OscmOTSTableModel.isValidNumber(this.PowerCal[n], "Power Cal.")) {
            float f = Float.parseFloat(this.PowerCal[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                this.model[n].setCalibratedPower(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                switch (n3) {
                    case 3: {
                        int n4 = provisionError.getLoValue();
                        String string = new Integer(n4).toString();
                        string = this.StrDivforTen(string);
                        int n5 = provisionError.getHiValue();
                        String string2 = new Integer(n5).toString();
                        string2 = this.StrDivforTen(string2);
                        ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_4, "Power Calibration and Power Reference ", string, string2);
                        break;
                    }
                    case 6: {
                        ErrorMsg.displayError(this.getFrame(), EMC.EID_THR_ADJ_FAILED_PARAM_2, "The new setpoint would either make the thresholds\n", "inconsistent or set the fail threshold outside the range.");
                        break;
                    }
                    case 7: {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWERCAL_NOT_ALLOWED);
                    }
                }
                this.PowerCal[n] = null;
                this.getPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
            catch (Exception exception) {
                this.PowerCal[n] = null;
                this.getPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.PowerCal[n] = null;
            this.getPowerCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private void setVOAPowerCal(int n) {
        if (OscmOTSTableModel.isValidNumber(this.VOAPowerCal[n], "VOA Power Cal.")) {
            float f = Float.parseFloat(this.VOAPowerCal[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                this.model[n].setVOACalibrationPower(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = new Integer(n4).toString();
                    string = this.StrDivforTen(string);
                    int n5 = provisionError.getHiValue();
                    String string2 = new Integer(n5).toString();
                    string2 = this.StrDivforTen(string2);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "VOA Power", string, string2);
                    this.VOAPowerCal[n] = null;
                    this.getVOAPowerCal(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.VOAPowerCal[n] = null;
                this.getVOAPowerCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.VOAPowerCal[n] = null;
            this.getVOAPowerCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private String getVOAAttenuationRef(int n) {
        try {
            int n2 = this.model[n].getVoaReferenceAttenuation();
            if (n2 == -1000000) {
                return "N/A";
            }
            String string = new Integer(n2).toString();
            this.numChars = string.startsWith("-") ? 2 : 1;
            string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getVOAAttenuationCal(int n) {
        if (this.VOAAttenCal[n] == null) {
            this.Flg_FeatureUnsupported[n][12] = false;
            try {
                int n2 = this.model[n].getVoaCalibrationAttenuation();
                if (n2 == -1000000) {
                    this.VOAAttenCal[n] = "N/A";
                    this.Flg_FeatureUnsupported[n][12] = true;
                    return this.VOAAttenCal[n];
                }
                this.VOAAttenCal[n] = new Integer(n2).toString();
                this.numChars = this.VOAAttenCal[n].startsWith("-") ? 2 : 1;
                this.VOAAttenCal[n] = this.VOAAttenCal[n].length() > this.numChars ? this.VOAAttenCal[n].substring(0, this.VOAAttenCal[n].length() - 1) + "." + this.VOAAttenCal[n].substring(this.VOAAttenCal[n].length() - 1) : (this.numChars == 2 ? this.VOAAttenCal[n].substring(0, 1) + "0." + this.VOAAttenCal[n].substring(1, this.VOAAttenCal[n].length()) : "0." + this.VOAAttenCal[n]);
            }
            catch (Exception exception) {
                this.VOAAttenCal[n] = "N/A";
                this.Flg_FeatureUnsupported[n][12] = true;
                return this.VOAAttenCal[n];
            }
        }
        return this.VOAAttenCal[n];
    }

    private void setVOACal(int n) {
        if (OscmOTSTableModel.isValidNumber(this.VOAAttenCal[n], "Power Cal.")) {
            float f = Float.parseFloat(this.VOAAttenCal[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                this.model[n].setVOAAttenuation(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = new Integer(n4).toString();
                    string = this.StrDivforTen(string);
                    int n5 = provisionError.getHiValue();
                    String string2 = new Integer(n5).toString();
                    string2 = this.StrDivforTen(string2);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_4, "VOA Attenuation Calibration and VOA Attenuation Reference ", string, string2);
                    this.VOAAttenCal[n] = null;
                    this.getVOAAttenuationCal(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.VOAAttenCal[n] = null;
                this.getVOAAttenuationCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.VOAAttenCal[n] = null;
            this.getVOAAttenuationCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private String getAttenuationRef(int n) {
        try {
            String string = new Integer(this.model[n].getVoaRefPower()).toString();
            string = string.length() > 1 ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : "0." + string;
            return string;
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private String getVOACal(int n) {
        if (this.VOAAttenCal[n] == null) {
            try {
                this.VOAAttenCal[n] = new Integer(this.model[n].getVoaCalibrationPower()).toString();
                this.VOAAttenCal[n] = this.VOAAttenCal[n].length() > 1 ? this.VOAAttenCal[n].substring(0, this.VOAAttenCal[n].length() - 1) + "." + this.VOAAttenCal[n].substring(this.VOAAttenCal[n].length() - 1) : "0." + this.VOAAttenCal[n];
            }
            catch (Exception exception) {
                this.VOAAttenCal[n] = "N/A";
                return this.VOAAttenCal[n];
            }
        }
        return this.VOAAttenCal[n];
    }

    private String getExpectedWavelength(int n) {
        if (this.expectedWavelength[n] == -1) {
            this.expectedWavelength[n] = 1;
        }
        return WavelengthStrings[this.expectedWavelength[n]];
    }

    private String getActualWavelength(int n) {
        this.actualWavelength[n] = 1;
        return WavelengthStrings[this.actualWavelength[n]];
    }

    private String getRingDirection(int n) {
        if (this.ringDirection[n] == -1) {
            try {
                eRingDirection eRingDirection2;
                eRingDirection eRingDirection3 = eRingDirection2 = this.model[n] != null ? this.model[n].getRingDirection() : eRingDirection.EAST_WEST;
                if (eRingDirection2 == eRingDirection.EAST_WEST) {
                    this.ringDirection[n] = 0;
                } else if (eRingDirection2 == eRingDirection.WEST_EAST) {
                    this.ringDirection[n] = 1;
                }
            }
            catch (Exception exception) {
                return "N/A";
            }
        }
        return ringDirectionStrings[this.ringDirection[n]];
    }

    private Attribute getWavelength(int n) {
        if (this.wavelength[n] == null) {
            int n2 = 0;
            this.wavelength[n] = this.getAttributeFor("declDwdmWavelength", n2);
        }
        return this.wavelength[n];
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    private void resetDirtyBits() {
        this.FlgOkDialog = false;
        this.FlgAdminStateChanged = false;
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    private void setFeatureUnsupported() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.Flg_FeatureUnsupported[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        if (db.on()) {
            db.println("refresh from model line: " + n);
        }
        this.resetLineCache(n);
        this.portNames[n] = this.getPortName(n);
        this.getRingDirection(n);
        this.VOAAttenCal[n] = this.getVOAAttenuationCal(n);
        this.VOAPowerCal[n] = this.getVOAPowerCal(n);
        this.PowerCal[n] = this.getPowerCal(n);
        this.actPower[n] = this.getActPower(n);
        this.getVOARefPower(n);
        this.getVOAAttenuationRef(n);
        this.getVOAMode(n);
        this.getType(n);
        try {
            this.adminState[n] = AdminState.enumToAdminState(this.getAdminStateFromModel(n));
        }
        catch (NoSuchInterface noSuchInterface) {
            this.adminState[n] = AdminState.NULL_STATE;
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.VOAAttenCal[n] = null;
        this.VOAPowerCal[n] = null;
        this.PowerCal[n] = null;
        this.actPower[n] = null;
        this.VOAMode[n] = -1;
        this.ringDirection[n] = -1;
        this.expectedWavelength[n] = -1;
        this.actualWavelength[n] = -1;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    boolean mediaChanged() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][2]) continue;
        }
        return false;
    }

    boolean statusChangedToOos() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][2] || this.adminState[i].getAdminStateEnum().value() == 3) continue;
            return true;
        }
        return false;
    }

    public void applyToModel() throws Exception {
        int n = 0;
        boolean bl = false;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if ((this.isDirty[n][12] || this.isDirty[n][10] || this.isDirty[n][8]) && !this.FlgOkDialog) {
                    if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"Selected operation could be service affecting. Apply changes anyway?", (String)"Confirmation Dialog")) {
                        this.FlgOkDialog = true;
                    } else {
                        this.refreshFromModel();
                        return;
                    }
                }
                if (this.isDirty[n][1]) {
                    this.model[n].setAlias(this.getPortName(n));
                }
                if (this.isDirty(n, 2)) {
                    this.FlgAdminStateChanged = true;
                    this.model[n].setAdminState(this.getAdminState(n).getAdminStateEnum());
                    this.serviceState[n] = null;
                }
                if (this.isDirty[n][12]) {
                    this.setVOACal(n);
                }
                if (this.isDirty[n][10]) {
                    this.setVOAPowerCal(n);
                }
                if (this.isDirty[n][8]) {
                    this.setPowerCal(n);
                }
                if (!this.isDirty[n][4]) continue;
                if (this.ringDirection[n] == 1) {
                    this.model[n].setRingDirection(eRingDirection.WEST_EAST);
                    continue;
                }
                this.model[n].setRingDirection(eRingDirection.EAST_WEST);
            }
            this.resetDirtyBits();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            if (this.FlgAdminStateChanged) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED);
            } else {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            }
            this.refreshFromModel();
        }
    }

    private void AdjustAllWavelength(int n, int n2) {
        int n3 = 0;
        for (n3 = 0; n3 < this.numLines; ++n3) {
            if (n3 == n) continue;
            this.expectedWavelength[n3] = n2;
        }
    }

    public static boolean isValidNumber(String string, String string2) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String StrDivforTen(String string) {
        this.numChars = string.startsWith("-") ? 2 : 1;
        string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
        return string;
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty(n, 2);
    }
}

