/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.oscm.OscmFEPmThresholdsPane;
import cerent.cms.ui.oscm.OscmHoPathPmThresholdsPane;
import cerent.cms.ui.oscm.OscmLinePmThresholdsPane;
import cerent.cms.ui.oscm.OscmOcSectionPmThresholdsPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class OscmThresholdProvPane
extends AbstractPane {
    protected TdmLineModel[] models;
    protected TdmThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String FE_SEC_1DAY_PANEL = "FE_SEC_1DAY";
    protected static final String FE_SEC_15MIN_PANEL = "FE_SEC_15MIN";
    protected static final String FE_LIN_1DAY_PANEL = "FE_LIN_1DAY";
    protected static final String FE_LIN_15MIN_PANEL = "FE_LIN_15MIN";
    protected static final String NE_SEC_1DAY_PANEL = "NE_SEC_1DAY";
    protected static final String NE_SEC_15MIN_PANEL = "NE_SEC_15MIN";
    protected static final String NE_LIN_1DAY_PANEL = "NE_LIN_1DAY";
    protected static final String NE_LIN_15MIN_PANEL = "NE_LIN_15MIN";
    protected static final String NE_PATH_15MIN_PANEL = "NE_PATH_15MIN";
    protected static final String FE_PATH_15MIN_PANEL = "FE_PATH_15MIN";
    protected static final String NE_PATH_1DAY_PANEL = "NE_PATH_1DAY";
    protected static final String FE_PATH_1DAY_PANEL = "FE_PATH_1DAY";
    protected static final int NE_PATH_15MIN = 8;
    protected static final int FE_PATH_15MIN = 12;
    protected static final int NE_PATH_1DAY = 9;
    protected static final int FE_PATH_1DAY = 13;
    protected static final int FE_SEC_1DAY = 7;
    protected static final int FE_SEC_15MIN = 6;
    protected static final int FE_LIN_1DAY = 5;
    protected static final int FE_LIN_15MIN = 4;
    protected static final int NE_SEC_1DAY = 3;
    protected static final int NE_SEC_15MIN = 2;
    protected static final int NE_LIN_1DAY = 1;
    protected static final int NE_LIN_15MIN = 0;
    private JLabel tableLabel = new JLabel("TEST LABEL...");
    private String tableLabelString = new String();
    private JPanel labeledTablePanel = null;
    private static final SDebug db = new SDebug("Pane.OscmThresholdProvPane");

    public OscmThresholdProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.models = tdmLineModelArray;
        this.panes = new Pane[14];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
    }

    protected TdmThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new TdmThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.panes[7] = this.getSonetSectionPmThresholdsPane(FE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
        this.tablePanel.add((Component)this.panes[7], FE_SEC_1DAY_PANEL);
        this.panes[6] = this.getSonetSectionPmThresholdsPane(FE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
        this.tablePanel.add((Component)this.panes[6], FE_SEC_15MIN_PANEL);
        this.panes[4] = this.getSonetFEPmThresholdsPane(FE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
        this.tablePanel.add((Component)this.panes[4], FE_LIN_15MIN_PANEL);
        this.panes[5] = this.getSonetFEPmThresholdsPane(FE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
        this.tablePanel.add((Component)this.panes[5], FE_LIN_1DAY_PANEL);
        this.panes[3] = this.getSonetSectionPmThresholdsPane(NE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
        this.tablePanel.add((Component)this.panes[3], NE_SEC_1DAY_PANEL);
        this.panes[2] = this.getSonetSectionPmThresholdsPane(NE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.tablePanel.add((Component)this.panes[2], NE_SEC_15MIN_PANEL);
        this.panes[0] = this.getSonetFEPmThresholdsPane(NE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.tablePanel.add((Component)this.panes[0], NE_LIN_15MIN_PANEL);
        this.panes[1] = this.getSonetFEPmThresholdsPane(NE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
        this.tablePanel.add((Component)this.panes[1], NE_LIN_1DAY_PANEL);
        this.panes[8] = this.getSonetPathPmThresholdsPane(NE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.tablePanel.add((Component)this.panes[8], NE_PATH_15MIN_PANEL);
        this.panes[12] = this.getSonetPathPmThresholdsPane(FE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
        this.tablePanel.add((Component)this.panes[12], FE_PATH_15MIN_PANEL);
        this.panes[9] = this.getSonetPathPmThresholdsPane(NE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
        this.tablePanel.add((Component)this.panes[9], NE_PATH_1DAY_PANEL);
        this.panes[13] = this.getSonetPathPmThresholdsPane(FE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
        this.tablePanel.add((Component)this.panes[13], FE_PATH_1DAY_PANEL);
        this.cl.show(this.tablePanel, NE_LIN_15MIN_PANEL);
        this.currentPane = this.panes[0];
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected OscmLinePmThresholdsPane getSonetPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new OscmLinePmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected OscmFEPmThresholdsPane getSonetFEPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new OscmFEPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected OscmOcSectionPmThresholdsPane getSonetSectionPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new OscmOcSectionPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected OscmHoPathPmThresholdsPane getSonetPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new OscmHoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, 1);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        this.getButtonPanel().refreshAction();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (null == this.panes[i]) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            if (this.panes[i] instanceof OscmHoPathPmThresholdsPane) {
                ((OscmHoPathPmThresholdsPane)this.panes[i]).dispose();
            } else if (this.panes[i] instanceof OscmLinePmThresholdsPane) {
                ((OscmLinePmThresholdsPane)this.panes[i]).dispose();
            } else if (this.panes[i] instanceof OscmOcSectionPmThresholdsPane) {
                ((OscmOcSectionPmThresholdsPane)this.panes[i]).dispose();
            }
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class TdmThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JRadioButton buttonSection;
        public JRadioButton buttonLine;
        public JRadioButton buttonPath;
        public JButton showButton = new JButton("Refresh");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup endButtonGroup;
        public ButtonGroup secLineButtonGroup;
        protected int PATH_MASK = 8;
        protected int FE_MASK = 4;
        protected int SEC_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public TdmThresholdButtonPanel() {
            this.initialize();
        }

        protected void initButtonListeners() {
            this.buttonNE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        TdmThresholdButtonPanel.this.buttonSection.setEnabled(true);
                        TdmThresholdButtonPanel.this.buttonPath.setEnabled(false);
                    } else {
                        if (TdmThresholdButtonPanel.this.buttonSection.isSelected() || TdmThresholdButtonPanel.this.buttonPath.isSelected()) {
                            TdmThresholdButtonPanel.this.buttonSection.setSelected(false);
                            TdmThresholdButtonPanel.this.buttonPath.setSelected(false);
                            TdmThresholdButtonPanel.this.buttonLine.setSelected(true);
                        }
                        TdmThresholdButtonPanel.this.buttonSection.setEnabled(false);
                        TdmThresholdButtonPanel.this.buttonPath.setEnabled(false);
                    }
                }
            });
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            String string = "Section";
            String string2 = "Line";
            if (OscmThresholdProvPane.this.models[0] != null && OscmThresholdProvPane.this.models[0].getNodeModel().getFramingType() != 0) {
                string = "RS";
                string2 = "MS";
            }
            this.buttonSection = new JRadioButton(string);
            this.buttonLine = new JRadioButton(string2, true);
            this.buttonPath = new JRadioButton("Path", false);
            this.secLineButtonGroup = new ButtonGroup();
            this.secLineButtonGroup.add(this.buttonSection);
            this.secLineButtonGroup.add(this.buttonLine);
            this.secLineButtonGroup.add(this.buttonPath);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.endButtonGroup = new ButtonGroup();
            this.endButtonGroup.add(this.buttonNE);
            this.endButtonGroup.add(this.buttonFE);
            this.showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TdmThresholdButtonPanel.this.refreshAction();
                }
            });
            this.initButtonListeners();
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Directions "));
            jPanel.setPreferredSize(dimension);
            jPanel.add(this.buttonNE);
            jPanel.add(this.buttonFE);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(dimension);
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 2, 0, 0));
            jPanel3.setBorder(BorderFactory.createTitledBorder(" Types "));
            jPanel3.setPreferredSize(new Dimension(dimension.width * 2, dimension.height));
            jPanel3.add(this.buttonLine);
            jPanel3.add(this.buttonPath);
            jPanel3.add(this.buttonSection);
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void refreshAction() {
            int n = 0;
            OscmThresholdProvPane.this.tableLabelString = " ";
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                if (db.on()) {
                    db.println("FE");
                }
                n |= this.FE_MASK;
                OscmThresholdProvPane.this.tableLabelString = OscmThresholdProvPane.this.tableLabelString + "Far End";
            } else {
                OscmThresholdProvPane.this.tableLabelString = OscmThresholdProvPane.this.tableLabelString + "Near End";
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (db.on()) {
                    db.println("1 Day");
                }
                n |= this.ONE_DAY_MASK;
                OscmThresholdProvPane.this.tableLabelString = OscmThresholdProvPane.this.tableLabelString + ", 1 Day";
            } else {
                OscmThresholdProvPane.this.tableLabelString = OscmThresholdProvPane.this.tableLabelString + ", 15 Min";
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonSection.getModel()) {
                OscmThresholdProvPane.this.tableLabelString = OscmThresholdProvPane.this.tableLabelString + ", Section";
            } else if (this.secLineButtonGroup.getSelection() == this.buttonPath.getModel()) {
                OscmThresholdProvPane.this.tableLabelString = OscmThresholdProvPane.this.tableLabelString + ", Path";
            } else {
                OscmThresholdProvPane.this.tableLabelString = OscmThresholdProvPane.this.tableLabelString + ", Line";
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonSection.getModel()) {
                if (db.on()) {
                    db.println("Section pressed");
                }
                n |= this.SEC_MASK;
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonPath.getModel()) {
                if (db.on()) {
                    db.println("Path pressed");
                }
                n |= this.PATH_MASK;
            }
            switch (n) {
                case 7: {
                    if (db.on()) {
                        db.println("FE SEC 1DAY");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[7]);
                    break;
                }
                case 6: {
                    if (db.on()) {
                        db.println("FE SEC 15MIN");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[6]);
                    break;
                }
                case 5: {
                    if (db.on()) {
                        db.println("FE LIN 1DAY");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[5]);
                    break;
                }
                case 4: {
                    if (db.on()) {
                        db.println("FE LIN 15MIN");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[4]);
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("NE SEC 1DAY");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[3]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("NE SEC 15MIN");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[2]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("NE LIN 1 Day");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[1]);
                    break;
                }
                case 0: {
                    if (db.on()) {
                        db.println("NE LIN 15MIN");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[0]);
                    break;
                }
                case 8: {
                    if (db.on()) {
                        db.println("NE PATH 15MIN");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[8]);
                    break;
                }
                case 12: {
                    if (db.on()) {
                        db.println("FE PATH 15MIN");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[12]);
                    break;
                }
                case 9: {
                    if (db.on()) {
                        db.println("NE PATH 1DAY");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[9]);
                    break;
                }
                case 13: {
                    if (db.on()) {
                        db.println("FE PATH 1DAY");
                    }
                    OscmThresholdProvPane.this.showPanel(OscmThresholdProvPane.this.panes[13]);
                }
            }
            OscmThresholdProvPane.this.tableLabel.setText(OscmThresholdProvPane.this.tableLabelString);
        }
    }
}

