/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerE1Line;
import cerent.cms.ui.pm.PmLayerE1PathRx;
import cerent.cms.ui.pm.PmLayerE1PathTx;

public class PmLayerE1
extends PmLayer {
    protected int lineCount;
    protected PmLayer lineLayer;
    protected int numParms;
    protected int pathCount;
    protected PmLayer pathLayer;
    protected int pathCountTx;
    protected PmLayer pathLayerTx;

    public PmLayerE1(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        this.lineLayer = new PmLayerE1Line(pmTableModel, ds123LineModel, n);
        this.pathLayer = new PmLayerE1PathRx(pmTableModel, ds123LineModel, n);
        this.pathLayerTx = new PmLayerE1PathTx(pmTableModel, ds123LineModel, n);
        this.lineCount = this.lineLayer.parmCount();
        this.pathCount = this.pathLayer.parmCount();
        this.pathCountTx = this.pathLayerTx.parmCount();
        this.numParms = this.lineCount + this.pathCount + this.pathCountTx;
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        if (this.nearEnd) {
            this.lineLayer.clearStats();
        } else {
            this.pathLayer.clearStats();
        }
    }

    public boolean hasFarEnd() {
        return this.lineLayer.hasFarEnd() || this.pathLayer.hasFarEnd() || this.pathLayerTx.hasFarEnd();
    }

    public void setNearEnd(boolean bl) {
        this.nearEnd = bl;
        this.lineLayer.setNearEnd(bl);
        this.pathLayer.setNearEnd(bl);
        this.pathLayerTx.setNearEnd(bl);
    }

    public void setIntervalType(eIntervalType eIntervalType2) {
        this.lineLayer.setIntervalType(eIntervalType2);
        this.pathLayer.setIntervalType(eIntervalType2);
        this.pathLayerTx.setIntervalType(eIntervalType2);
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (n < this.lineCount) {
            return this.lineLayer.getPmValue(n, n2);
        }
        if ((n -= this.lineCount) < this.pathCount) {
            return this.pathLayer.getPmValue(n, n2);
        }
        return this.pathLayerTx.getPmValue(n -= this.pathCount, n2);
    }

    public String layerLabel() {
        return "E1";
    }

    public int parmCount() {
        return this.numParms;
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.lineLayer.refreshPmStats(n);
        this.pathLayer.refreshPmStats(n);
        this.pathLayerTx.refreshPmStats(n);
        this.fromPeerCard = this.lineLayer.isFromPeerCard() || this.pathLayer.isFromPeerCard() || this.pathLayerTx.isFromPeerCard();
    }

    public String parmName(int n) {
        if (n < this.lineCount) {
            return this.lineLayer.parmName(n);
        }
        if ((n -= this.lineCount) < this.pathCount) {
            return this.pathLayer.parmName(n);
        }
        return this.pathLayerTx.parmName(n -= this.pathCount);
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.lineLayer.setModel(interfaceModel);
        this.pathLayer.setModel(interfaceModel);
        this.pathLayerTx.setModel(interfaceModel);
    }

    public void tossData() {
        this.lineLayer.tossData();
        this.pathLayer.tossData();
        this.pathLayerTx.tossData();
        this.fromPeerCard = false;
    }
}

