/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Dwdm.sValPmStat;
import cerent.cms.idl.Optics.PM_OPTICS_UNDEFINED;
import cerent.cms.idl.Optics.sOpticsPmStats;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public class PmLayerOptics
extends PmLayer
implements PM_OPTICS_UNDEFINED {
    protected AbstractOpticsLineModel model = null;
    protected int numParms;
    protected int numRegisters;
    protected sOpticsPmStats[] statsVal;
    private static final sPmStat defOptPmStat = new sPmStat(-1000000, false);
    protected static final sValPmStat defValPmStat = new sValPmStat(defOptPmStat, defOptPmStat, defOptPmStat);
    public String[] parmNames = new String[]{"Optical Pwr (Min)", "Optical Pwr (Avg)", "Optical Pwr (Max)"};
    public static final int POWER_MIN_INDEX = 0;
    public static final int POWER_AVG_INDEX = 1;
    public static final int POWER_MAX_INDEX = 2;
    private static final sOpticsPmStats _defaultStats = new sOpticsPmStats(0, defValPmStat);
    private static final SDebug db = new SDebug("PmLayerOptics");

    public PmLayerOptics(PmTableModel pmTableModel, AbstractOpticsLineModel abstractOpticsLineModel, int n) {
        this.model = abstractOpticsLineModel;
        this.numRegisters = n;
        this.numParms = this.parmNames.length;
        this.statsVal = new sOpticsPmStats[n];
        this.tossData();
    }

    public void clearStats() {
        try {
            this.model.clearOpticsStats(this.intervalType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        Float f = new Float(0.0f);
        boolean bl = false;
        this.refreshPmStats(n2);
        switch (n) {
            case 0: {
                f = new Float((float)this.statsVal[n2].opticalPower.min.cnt / 10.0f);
                bl = this.statsVal[n2].opticalPower.min.valid;
                break;
            }
            case 1: {
                f = new Float((float)this.statsVal[n2].opticalPower.avg.cnt / 10.0f);
                bl = this.statsVal[n2].opticalPower.avg.valid;
                break;
            }
            case 2: {
                f = new Float((float)this.statsVal[n2].opticalPower.max.cnt / 10.0f);
                bl = this.statsVal[n2].opticalPower.max.valid;
                break;
            }
            default: {
                db.println("WARNING: PmLayerOptics.getPmValue needs updating, unknown value " + n);
            }
        }
        return new PmRendererStatRatio(f.floatValue(), bl, true);
    }

    public String layerLabel() {
        return "Port";
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            if (this.statsVal[n] == null || this.statsVal[n] == _defaultStats) {
                this.statsVal[n] = _defaultStats;
                this.statsVal[n] = this.model.getOpticsStats(this.intervalType, (short)n);
            }
        }
        catch (InternalCommError internalCommError) {
            this.statsVal[n] = new sOpticsPmStats(0, defValPmStat);
            throw internalCommError;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
    }

    public String parmName(int n) {
        return this.parmNames[n];
    }

    public int parmCount() {
        return this.numParms;
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (AbstractOpticsLineModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.statsVal[i] = null;
        }
    }

    public boolean isHigherPmDisplayed() {
        return false;
    }
}

