/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.SonetMedia.sPathStats600;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public class PmLayerSonetStsPjc
extends PmLayer {
    protected sPathStats600[] pathStatsVal;
    protected TdmHoModel model;
    protected int numRegisters;
    protected static String[] parmNames = new String[]{"STS CV-P", "STS ES-P", "STS FC-P", "STS SES-P", "STS UAS-P", "PPJC-Pdet", "NPJC-Pdet", "PPJC-Pgen", "NPJC-Pgen"};
    protected static final int CV_P_INDEX = 0;
    protected static final int ES_P_INDEX = 1;
    protected static final int FC_P_INDEX = 2;
    protected static final int SES_P_INDEX = 3;
    protected static final int UAS_P_INDEX = 4;
    protected static final int PJP_IN_INDEX = 5;
    protected static final int PJN_IN_INDEX = 6;
    protected static final int PJP_OUT_INDEX = 7;
    protected static final int PJN_OUT_INDEX = 8;
    private static final SDebug db = new SDebug("PmLayerSonetStsPjc");

    public PmLayerSonetStsPjc(PmTableModel pmTableModel, TdmHoModel tdmHoModel, int n, boolean bl) {
        super(pmTableModel, tdmHoModel, bl);
        this.model = tdmHoModel;
        this.numRegisters = n;
        this.pathStatsVal = new sPathStats600[this.numRegisters];
    }

    public PmLayerSonetStsPjc(PmTableModel pmTableModel, TdmHoModel tdmHoModel, int n) {
        this(pmTableModel, tdmHoModel, n, true);
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearPathStats(this.nearEnd, this.intervalType);
    }

    public void clearStats(String[] stringArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearStatsPerParam(this.nearEnd, this.intervalType, stringArray);
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_INVALID;
        this.refreshPmStats(n2);
        switch (n) {
            case 0: {
                sPmStat2 = this.pathStatsVal[n2].cv;
                break;
            }
            case 1: {
                sPmStat2 = this.pathStatsVal[n2].es;
                break;
            }
            case 2: {
                sPmStat2 = this.pathStatsVal[n2].fc;
                break;
            }
            case 3: {
                sPmStat2 = this.pathStatsVal[n2].ses;
                break;
            }
            case 4: {
                sPmStat2 = this.pathStatsVal[n2].uas;
                break;
            }
            case 5: {
                sPmStat2 = this.pathStatsVal[n2].pjpIn;
                break;
            }
            case 6: {
                sPmStat2 = this.pathStatsVal[n2].pjnIn;
                break;
            }
            case 7: {
                sPmStat2 = this.pathStatsVal[n2].pjpOut;
                break;
            }
            case 8: {
                sPmStat2 = this.pathStatsVal[n2].pjnOut;
                break;
            }
        }
        return new PmRendererStat(sPmStat2);
    }

    public String layerLabel() {
        return "STS";
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.pathStatsVal[n] == null) {
            if (db.on()) {
                db.println("calling getPathStats in PmLayerSonetStsPjc");
            }
            int n2 = this.intervalType == eIntervalType.INTERVAL_15_MIN ? this.numRegisters : this.numRegisters - 4;
            sPathStats600[] sPathStats600Array = new sPathStats600[this.numRegisters];
            for (int i = 0; i < n2; ++i) {
                this.pathStatsVal[i] = new sPathStats600(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                sPathStats600Array[i] = this.pathStatsVal[i];
            }
            this.model.getPathStats(this.nearEnd, this.intervalType, (short)-1, sPathStats600Array);
        }
    }

    public String parmName(int n) {
        return parmNames[n];
    }

    public int parmCount() {
        return parmNames.length;
    }

    public void setModel(InterfaceModel interfaceModel) {
        interfaceModel = (TdmHoModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.pathStatsVal[i] = null;
        }
    }
}

