/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PpmCardView
extends CardView
implements ActionListener {
    public static final int PPM_CARD_WIDTH = 24;
    public static final int PPM_CARD_HEIGHT = 24;
    protected String alarmProfileString = "";
    protected String statusString = "";
    private static final String ADD_PPM = "Add PPM";
    public static final String DELETE_PPM = "Delete PPM";
    protected static final SDebug db = new SDebug("PpmCardView");

    public PpmCardView(PpmModel ppmModel) {
        super(ppmModel);
        if (db.on()) {
            db.println("<init> " + ppmModel.getEqLabel() + "\tIndex: " + ppmModel.getPositionInParent() + "\tNum of children: " + ppmModel.getChildren().size());
        }
        this.addChildren();
        this.updateStatus();
        this.registerForLocalUpdates();
        if (this.isAsap()) {
            this.setBorder(BorderFactory.createBevelBorder(0));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        this.update(this.cardAlarmStore.getAlarmStatusObservable(), this.getAlarmStatus());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 4) {
                    PpmCardView.this.showPopupMenu(mouseEvent.getPoint());
                }
            }
        });
    }

    protected void updateStatus() {
        block3: {
            if (this.model != null) {
                try {
                    this.alarmProfileString = this.model.getAlarmProfileName();
                    int n = ((PpmModel)this.model).getServiceSt().getType();
                    this.statusString = PpmModel.getTDMTerminology(this.model).getTermForServiceState(n);
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.updateToolTipText();
    }

    protected void addPorts(boolean bl) {
    }

    protected void addChildren() {
        int n;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        int n2 = ((PpmModel)this.model).getMaxPorts();
        JPanel[] jPanelArray = new JPanel[n2];
        if (this.isAsap() && this.portModels.isEmpty()) {
            this.add((Component)this.getLabel(), gridBagConstraints);
            return;
        }
        for (n = 0; n < this.portModels.size(); ++n) {
            if (!(this.portModels.get(n) instanceof PortModel)) continue;
            PortModel portModel = (PortModel)this.portModels.get(n);
            this.ports[n] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
            JLabel jLabel = (JLabel)this.ports[n].getComponent(0);
            jLabel.setText(PortHelper.getPortNumString((IPortModel)portModel));
            int n3 = portModel.getPositionInParent();
            if (this.isAsap() && portModel.getEqType() == 166) {
                n3 = n3 > 1 ? n3 - 1 : n3;
            }
            jPanelArray[n3 - 1] = this.ports[n];
        }
        for (n = 0; n < n2; ++n) {
            if (this.pci.positionPortsVertically()) {
                gridBagConstraints.gridy = n + 1;
            } else {
                gridBagConstraints.gridx = n + 1;
            }
            if (jPanelArray[n] == null) {
                jPanelArray[n] = this.getPortSlotGraphic();
            }
            this.add((Component)jPanelArray[n], gridBagConstraints);
        }
    }

    protected JLabel getLabel() {
        JLabel jLabel = new JLabel(PluggableHelper.getHierarchyNumString(((PluggableModel)this.model).getHierarchyNums(), '-'));
        jLabel.setOpaque(false);
        if (this.model == null) {
            return jLabel;
        }
        jLabel.setFont(new Font("Arial", 1, 10));
        jLabel.setHorizontalAlignment(0);
        jLabel = AbstractShelfLayout.formatLabel(jLabel);
        return jLabel;
    }

    protected void registerForLocalUpdates() {
        if (this.model != null) {
            this.model.addObserver(this);
            List list = this.getPorts();
            PortModel portModel = null;
            for (int i = 0; i < list.size(); ++i) {
                portModel = (PortModel)list.get(i);
                if (portModel == null) continue;
                portModel.getInterfaceModel().addObserver((Observer)this);
                if (!db.on()) continue;
                db.println("Registered Child: " + portModel);
            }
            if (db.on()) {
                db.println("Registered parent: " + this.model);
            }
        }
    }

    protected void deregisterFromLocalUpdates() {
        if (this.model != null) {
            this.model.deleteObserver(this);
            List list = this.getPorts();
            PortModel portModel = null;
            for (int i = 0; i < list.size(); ++i) {
                portModel = (PortModel)list.get(i);
                if (portModel == null) continue;
                portModel.getInterfaceModel().deleteObserver((Observer)this);
                if (!db.on()) continue;
                db.println("Deregistered Child: " + portModel);
            }
            if (db.on()) {
                db.println("Deregistered parent: " + this.model);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (this.model == null) {
            if (db.on()) {
                db.println("update: model is NULL, no update");
            }
            return;
        }
        if (object instanceof IAlarmStatus) {
            super.update(observable, this.getAlarmStatus());
        } else if (this.model != null && this.model.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(ModelUpdateType.ADDED) && observable == this.model) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                observable.deleteObserver(this);
                if (observable != this.model) {
                    SwingUtilities.invokeLater(new ReplacePort());
                    if (db.on()) {
                        db.println("Port DELETED");
                    }
                }
            } else if (n.equals(ModelUpdateType.CHANGED)) {
                this.updateStatus();
                this.setAlarmColor(this.getAlarmStatus().getHighestSeverity());
            }
        }
    }

    public void updateToolTipText() {
        if (this.model == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.model.getEqLabel());
        stringBuffer.append(" [");
        stringBuffer.append(((PluggableModel)this.model).getLocation());
        stringBuffer.append("]: ");
        stringBuffer.append(this.statusString);
        stringBuffer.append(", ");
        stringBuffer.append("Alarm Profile: ");
        stringBuffer.append(this.alarmProfileString);
        super.setToolTipText(stringBuffer.toString());
    }

    public IAlarmStatus getAlarmStatus() {
        IAlarmStatus iAlarmStatus = this.cardAlarmStore.getEntityAlarmStatus(this.model);
        if (iAlarmStatus == null) {
            iAlarmStatus = new AlarmStatus();
        }
        int n = iAlarmStatus.getHighestSeverity();
        List list = this.getPorts();
        PortModel portModel = null;
        for (int i = 0; i < list.size(); ++i) {
            IAlarmStatus iAlarmStatus2;
            portModel = (PortModel)list.get(i);
            if (portModel == null || (iAlarmStatus2 = this.cardAlarmStore.getEntityAlarmStatus(portModel)) == null || iAlarmStatus2.getHighestSeverity() <= n) continue;
            iAlarmStatus = iAlarmStatus2;
        }
        return iAlarmStatus;
    }

    protected void showPopupMenu(Point point) {
        boolean bl;
        PpmModel ppmModel = (PpmModel)this.model;
        PimModel pimModel = ppmModel.getPimModel();
        boolean bl2 = ppmModel.isDeleted();
        JPopupMenu jPopupMenu = new JPopupMenu();
        boolean bl3 = bl = pimModel != null && pimModel.getState().equals(eEqState.DELETED) ? false : AbstractPane.isUserAuthorized(ppmModel, SecurityLevel.PROVISIONING);
        if (bl2) {
            jPopupMenu.add(new NonSelectableMI(ADD_PPM));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.createMenuItem(EntityModel.eqType2Name(ppmModel.getNodeModel().getTDMTerminology(), ppmModel.getEqType()), bl));
        } else {
            jPopupMenu.add(new NonSelectableMI(EntityModel.eqType2Name(ppmModel.getNodeModel().getTDMTerminology(), ppmModel.getEqType())));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.createMenuItem(DELETE_PPM, bl));
        }
        jPopupMenu.show(this, point.x, point.y);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (((PpmModel)this.model).isDeleted()) {
                try {
                    ((PluggableSlotModel)this.model.getParent()).provisionPluggable(eEqType.PPM_1_PORT);
                }
                catch (ProvisionError provisionError) {
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_CARD_ADD);
                }
                catch (ResourceInUse resourceInUse) {
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_CARD_ADD);
                }
            } else {
                try {
                    NodeModelDelegate nodeModelDelegate = this.model.getNodeModelDelegate();
                    nodeModelDelegate.getPlatform().getCardBehavior(nodeModelDelegate, db).deleteCard(this, this.model);
                }
                catch (Exception exception) {
                    db.fine("Error deleting PPM");
                }
            }
        }
    }

    protected JMenuItem createMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setEnabled(bl);
        if (bl) {
            jMenuItem.addActionListener(this);
        }
        return jMenuItem;
    }

    public Dimension getPreferredSize() {
        if (this.model.getModuleModel().getEqType() == 219) {
            return new Dimension(34, 24);
        }
        int n = this.isAsap() ? 25 : 0;
        return new Dimension(24 + n, 24);
    }

    public void dispose() {
        this.localDispose();
        super.dispose();
    }

    protected void localDispose() {
        this.deregisterFromLocalUpdates();
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (this.ports[i] == null) continue;
                ((GenericPortGraphic)this.ports[i]).dispose();
                this.ports[i] = null;
            }
            this.ports = null;
        }
        this.removeAll();
    }

    protected List getPorts() {
        return ((PpmModel)this.model).getContainedPorts();
    }

    private JPanel getPortSlotGraphic() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel.setBackground(Color.lightGray);
        jPanel.setPreferredSize(new Dimension(16, 16));
        return jPanel;
    }

    protected boolean isAsap() {
        return this.model.getModuleModel() instanceof AsapModuleModel;
    }

    static /* synthetic */ AbstractPortGraphic[] access$402(PpmCardView ppmCardView, AbstractPortGraphic[] abstractPortGraphicArray) {
        ppmCardView.ports = abstractPortGraphicArray;
        return abstractPortGraphicArray;
    }

    private class NonSelectableMI
    extends JMenuItem {
        public NonSelectableMI(String string) {
            super(string);
        }

        public void menuSelectionChanged(boolean bl) {
        }
    }

    protected class ReplacePort
    implements Runnable {
        protected ReplacePort() {
        }

        public void run() {
            block4: {
                try {
                    PpmCardView.this.localDispose();
                    if (PpmCardView.this.model != null) {
                        PpmCardView.this.portModels = PpmCardView.this.getPorts();
                        PpmCardView.this.numPorts = PpmCardView.this.portModels.size();
                        PpmCardView.access$402(PpmCardView.this, new AbstractPortGraphic[PpmCardView.this.numPorts]);
                        PpmCardView.this.addChildren();
                        PpmCardView.this.registerForLocalUpdates();
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Error replacing port: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            PpmCardView.this.validate();
            PpmCardView.this.repaint();
        }
    }
}

