/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PimModel;
import cerent.cms.model.PimUpdate;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.PpmUpdate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ppm.PpmCreationDialog;
import cerent.cms.ui.ppm.PpmTableModel;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PpmPane
extends NodeProvPane
implements ActionListener,
ListSelectionListener {
    private PpmModel[] _models;
    private PimModel[] _pimModels;
    private int _numModels;
    private int _numPimModels;
    private Object _obsMgrLock;
    private ObservableManager _obsMgr;
    private static final SDebug _db = new SDebug("PpmPane");
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    private PpmTableModel _tableModel;
    private JButton _createPB;
    private JButton _deletePB;

    public PpmPane(String string, TabbedView tabbedView, PpmModel[] ppmModelArray, PimModel[] pimModelArray) {
        super(string, tabbedView);
        this._models = ppmModelArray;
        this._numModels = ppmModelArray == null ? 0 : ppmModelArray.length;
        this._pimModels = pimModelArray;
        this._numPimModels = pimModelArray == null ? 0 : pimModelArray.length;
        this._obsMgrLock = new Object();
        this._obsMgr = null;
        this.init();
        this.registerWithModel();
    }

    protected void registerWithModel() {
        super.registerWithModel();
        this.getObservableManager().addObservable((Observable[])this._models);
        this.getObservableManager().addObservable((Observable[])this._pimModels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObservableManager getObservableManager() {
        Object object = this._obsMgrLock;
        synchronized (object) {
            if (this._obsMgr == null) {
                this._obsMgr = new ObservableManager((Observer)((Object)this), true);
            } else {
                this._obsMgr.setActive(true);
            }
        }
        return this._obsMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this._obsMgrLock;
        synchronized (object) {
            if (this._obsMgr != null) {
                this._obsMgr.reset();
            }
        }
        super.dispose();
    }

    public void refreshFromModel() {
        this.getTableModel().refreshFromModel();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.getObservableManager().setPassing(true);
    }

    public void leavingPage() throws Exception {
        this.getObservableManager().setPassing(false);
        super.leavingPage();
    }

    private void init() {
        this.createPanel();
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.setComponentsEnabled(true);
    }

    private void createPanel() {
        this.setLayout(new BorderLayout());
        this.table = new UTable((TableModel)this.getTableModel());
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer((TableCellRenderer)((Object)this.getTableModel().getRenderer()));
            if (i != 2) continue;
            tableColumn.setPreferredWidth(200);
        }
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.getButtonBar(), "South");
    }

    protected JPanel getButtonBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        this._createPB = new JButton(CREATE);
        jPanel2.add(this._createPB);
        this._deletePB = new JButton(DELETE);
        jPanel2.add(this._deletePB);
        jPanel.add((Component)jPanel2, "Center");
        if (this.isUserAuthorized()) {
            this._createPB.addActionListener(this);
            this._deletePB.addActionListener(this);
        }
        return jPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.setComponentsEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._createPB) {
            this.doCreate();
        } else if (object == this._deletePB) {
            this.doDelete(this.table.getSelectedRow());
        }
    }

    private PpmTableModel getTableModel() {
        if (this._tableModel == null) {
            this._tableModel = new PpmTableModel(this._models, this.terms, _db);
        }
        return this._tableModel;
    }

    private boolean isCreateAllowed() {
        _db.finest("isCreateAllowed invoked");
        boolean bl = ((PluggableCarrierModel)this.getUiModel()).isPpmProvisionable();
        boolean bl2 = false;
        if (!bl) {
            for (int i = 0; !bl2 && i < this._numModels; ++i) {
                PluggableModel pluggableModel = (PluggableModel)this._models[i].getParent().getParent();
                bl2 = pluggableModel != null && pluggableModel instanceof PimModel ? this._models[i].isDeleted() && !pluggableModel.isDeleted() : this._models[i].isDeleted();
            }
        }
        return bl || bl2;
    }

    private boolean isDeleteAllowed() {
        PpmModel ppmModel;
        _db.finest("isDeleteAllowed invoked");
        boolean bl = false;
        int n = this.table.getSelectedRow();
        if (n >= 0 && n < this._numModels && (ppmModel = this._models[n]) != null) {
            bl = !ppmModel.isDeleted();
        }
        return bl;
    }

    private void setComponentsEnabled(boolean bl) {
        boolean bl2 = this.isUserAuthorized();
        boolean bl3 = this.isCreateAllowed();
        boolean bl4 = this.isDeleteAllowed();
        if (_db.on()) {
            _db.println("Setting comps: enabled = " + bl);
            _db.println("Setting comps: authOK = " + bl2);
            _db.println("Setting comps: isCreateAllowed = " + bl3);
            _db.println("Setting comps: isDeleteAllowed = " + bl4);
        }
        this._createPB.setEnabled(bl && bl2 && bl3);
        this._deletePB.setEnabled(bl && bl2 && bl4);
    }

    protected void doCreate() {
        PpmCreationDialog.instance(this).show();
    }

    protected void doDelete(int n) {
        NodeModelDelegate nodeModelDelegate;
        CardBehavior cardBehavior;
        PpmModel ppmModel;
        if (_db.on()) {
            _db.println("deleteSelectedTableEntry row: " + n);
        }
        if (n >= 0 && n < this._numModels && (ppmModel = this._models[n]) != null && (cardBehavior = (nodeModelDelegate = ppmModel.getNodeModelDelegate()).getPlatform().getCardBehavior(nodeModelDelegate, _db)).deleteCard((Component)((Object)this), ppmModel)) {
            this.setComponentsEnabled(false);
        }
    }

    protected void changeMessage(Observable observable, Object object) {
        if (_db.on()) {
            _db.println("Got an Update Message for " + observable);
        }
        this.requestRefresh(observable, this.getRefreshThread());
    }

    private Runnable getRefreshThread() {
        return new Runnable(){

            public void run() {
                PpmPane.this.getTableModel().refreshFromModel();
                PpmPane.this.setComponentsEnabled(true);
            }
        };
    }

    protected void refreshMyLines(Object object) {
        if (_db.on()) {
            _db.println("In refreshMyLines, processing " + object);
        }
        if (object instanceof PpmUpdate) {
            this.getObservableManager().removeObservable((Observable[])this._models);
            this._models = (PpmModel[])((PpmUpdate)object).getModels();
            this.getObservableManager().addObservable((Observable[])this._models);
            this._numModels = this._models == null ? 0 : this._models.length;
            this.getTableModel().refreshMyLines(this._models);
            this.setComponentsEnabled(true);
        } else if (object instanceof PimUpdate) {
            this.getObservableManager().removeObservable((Observable[])this._pimModels);
            this._pimModels = (PimModel[])((PimUpdate)object).getModels();
            this.getObservableManager().addObservable((Observable[])this._pimModels);
            this._numPimModels = this._pimModels == null ? 0 : this._pimModels.length;
            this.setComponentsEnabled(true);
        }
    }
}

