/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.idl.Epos.sRPRSpanStateInfo;
import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sIdStats;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.L2scPosPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.RmonThresholdManager;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.rmon.RmonPmCellRenderer;
import cerent.util.IAsyncObserver;
import cerent.util.SDebug;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.job.JobStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class RmonPmStatTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel {
    private static final int FIXED_COLUMNS = 1;
    public static final int PARM_INDEX = 0;
    private ModuleModel moduleModel;
    private boolean supportsClearPM;
    private boolean bSameStatsId;
    private String[] lastCleared;
    private String[] linkStatus;
    private HashMap[] lineStats;
    private HashMap[] lineZero;
    private HashSet[] lineStatsIdList;
    private EventUtilities timeConverter;
    private IAsyncObserver jobObserver;
    private boolean jobInProgress = false;
    protected int numLines;
    protected IRmonModel[] rmonModels;
    protected eStatsId[] statsIdList;
    protected String[] statsIdNames;
    protected String[] fixedParmNames;
    protected static final SDebug db = new SDebug("RmonPmStatTableModel");

    public RmonPmStatTableModel(IRmonModel[] iRmonModelArray, ModuleModel moduleModel) {
        this(iRmonModelArray, moduleModel, true);
    }

    public RmonPmStatTableModel(IRmonModel[] iRmonModelArray, ModuleModel moduleModel, boolean bl) {
        this.moduleModel = moduleModel;
        this.rmonModels = iRmonModelArray;
        this.numLines = iRmonModelArray.length;
        this.bSameStatsId = bl;
        this.lastCleared = new String[this.numLines];
        this.linkStatus = new String[this.numLines];
        this.timeConverter = EventUtilities.getInstance(moduleModel.getNodeModelDelegate());
        this.statsIdList = new eStatsId[0];
        this.statsIdNames = new String[0];
        this.lineStats = new HashMap[this.numLines];
        this.lineZero = new HashMap[this.numLines];
        this.fixedParmNames = new String[0];
        if (!bl) {
            this.lineStatsIdList = new HashSet[this.numLines];
        }
        this.supportsClearPM = moduleModel.supportsClearPM();
    }

    public void refreshMyLines(IRmonModel[] iRmonModelArray) {
        this.rmonModels = iRmonModelArray;
        this.numLines = iRmonModelArray.length;
        this.lastCleared = new String[this.numLines];
        this.linkStatus = new String[this.numLines];
        this.statsIdList = new eStatsId[0];
        this.statsIdNames = new String[0];
        this.lineStats = new HashMap[this.numLines];
        this.lineZero = new HashMap[this.numLines];
        this.fixedParmNames = new String[0];
        if (!this.bSameStatsId) {
            this.lineStatsIdList = new HashSet[this.numLines];
        }
        this.refreshData(null, null);
        this.fireTableStructureChanged();
    }

    private void setupStats() throws NoSuchInterface, WrongInterfaceType {
        Serializable serializable;
        if (this.rmonModels.length == 0) {
            if (this.fixedParmNames.length != 0) {
                this.fixedParmNames = new String[0];
            }
            throw new NoSuchInterface("No RmonModel");
        }
        if (this.fixedParmNames.length == 0) {
            serializable = new ArrayList<String>();
            if (this.supportsClearPM) {
                ((ArrayList)serializable).add("Time Last Cleared");
            }
            if (this.rmonModels[0].supportsLineStatus()) {
                ((ArrayList)serializable).add("Link Status");
            }
            this.fixedParmNames = ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
        }
        if (this.bSameStatsId) {
            this.statsIdList = this.rmonModels[0].getStatsIdList();
        } else {
            serializable = RmonThresholdManager.getInstance(this.moduleModel.getNodeModelDelegate());
            TreeSet treeSet = new TreeSet(((RmonThresholdManager)serializable).getStatsIdSorter());
            for (int i = 0; i < this.numLines; ++i) {
                try {
                    this.lineStatsIdList[i] = new HashSet<eStatsId>(Arrays.asList(this.rmonModels[i].getStatsIdList()));
                    treeSet.addAll(this.lineStatsIdList[i]);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    this.lineStatsIdList[i] = null;
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            this.statsIdList = treeSet.toArray(new eStatsId[0]);
        }
        this.statsIdNames = this.rmonModels[0].getStatsIdListStr(this.statsIdList);
    }

    public void clearStats(int[] nArray) throws InternalCommError {
        for (int i = 0; i < nArray.length; ++i) {
            try {
                if (nArray[i] >= this.rmonModels.length) continue;
                this.rmonModels[nArray[i]].clearStats();
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
    }

    public void setBaseline() {
        if (db.on()) {
            db.println("setBaseline");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.setBaseline(i, false);
        }
        this.fireTableDataChanged();
    }

    public void resetBaseline() {
        if (db.on()) {
            db.println("resetBaseline");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.resetBaseline(i, false);
        }
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int getColumnCount() {
        return this.numLines + 1;
    }

    public String getColumnName(int n) {
        if (n < 1) {
            return "Param";
        }
        String string = "Port " + n;
        try {
            PortModel portModel = this.rmonModels[n - 1].getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            string = "Port " + entityCellRenderer.getPortString(portModel, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public int getRowCount() {
        return this.fixedParmNames.length + this.statsIdNames.length;
    }

    public Object getValueAt(int n, int n2) {
        db.fine("getValueAt( " + n + ", " + n2 + " )");
        if (n < this.fixedParmNames.length) {
            if (n2 == 0) {
                return this.fixedParmNames[n];
            }
            if (--n2 >= this.numLines) {
                return null;
            }
            return n == 0 && this.supportsClearPM ? this.lastCleared[n2] : this.linkStatus[n2];
        }
        if ((n -= this.fixedParmNames.length) >= this.statsIdList.length) {
            return null;
        }
        if (n2 == 0) {
            return this.statsIdNames[n];
        }
        if (--n2 >= this.numLines) {
            return null;
        }
        if (!(this.bSameStatsId || this.lineStatsIdList[n2] != null && n < this.statsIdList.length && this.lineStatsIdList[n2].contains(this.statsIdList[n]))) {
            return "N/A";
        }
        return this.getStats(n2, n);
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public void refreshData(IAsyncObserver iAsyncObserver, int[] nArray) {
        if (db.on()) {
            db.println("refreshData");
        }
        if (this.jobInProgress) {
            if (iAsyncObserver != null) {
                iAsyncObserver.asyncUpdate(null, null);
            }
        } else {
            this.jobInProgress = true;
            this.jobObserver = iAsyncObserver;
            if (nArray == null) {
                nArray = new int[this.rmonModels.length];
                for (int i = 0; i < this.rmonModels.length; ++i) {
                    nArray[i] = i;
                }
            }
            RefreshRun refreshRun = new RefreshRun(nArray);
            new Thread((Runnable)refreshRun, "RmonPmStatTableModel retrieve PM").start();
        }
    }

    protected void updateRetrieveLabel(String string) {
        if (this.jobObserver != null) {
            this.jobObserver.asyncUpdate((Object)string, new JobStatus(1));
        }
    }

    public int getFixedColumnCount() {
        return 1;
    }

    public void dispose() {
        this.jobInProgress = false;
    }

    protected void setBaseline(int n) {
        this.setBaseline(n, true);
    }

    private void setBaseline(int n, boolean bl) {
        this.lineZero[n] = this.lineStats[n];
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    protected void resetBaseline(int n) {
        this.resetBaseline(n, true);
    }

    private void resetBaseline(int n, boolean bl) {
        this.lineZero[n] = null;
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    private Long getStats(int n, int n2) {
        if (this.lineStats[n] != null && n2 < this.statsIdList.length) {
            Long l;
            Long l2 = (Long)this.lineStats[n].get(this.statsIdList[n2]);
            if (l2 != null && this.lineZero[n] != null && (l = (Long)this.lineZero[n].get(this.statsIdList[n2])) != null) {
                if (l2 < l) {
                    this.resetBaseline();
                } else {
                    l2 = new Long(l2 - l);
                }
            }
            return l2;
        }
        return null;
    }

    private HashMap getCurrentStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        HashMap<eStatsId, Long> hashMap = new HashMap<eStatsId, Long>();
        sIdStats[] sIdStatsArray = this.rmonModels[n].getCurrentStats();
        for (int i = 0; i < sIdStatsArray.length; ++i) {
            hashMap.put(sIdStatsArray[i].statId, new Long(sIdStatsArray[i].count));
        }
        return hashMap;
    }

    private void clearAllData() {
        for (int i = 0; i < this.numLines; ++i) {
            this.clearData(i);
        }
    }

    private void clearData(int n) {
        this.linkStatus[n] = null;
        this.lastCleared[n] = null;
        this.lineStats[n] = null;
        this.lineZero[n] = null;
    }

    class RefreshRun
    implements Runnable {
        int[] sColumns;

        RefreshRun(int[] nArray) {
            this.sColumns = nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                RmonPmStatTableModel.this.setupStats();
                int n = this.sColumns.length;
                for (int i = 0; i < n && RmonPmStatTableModel.this.jobInProgress; ++i) {
                    int n2 = this.sColumns[i];
                    RmonPmStatTableModel.this.updateRetrieveLabel("data for port# " + RmonPmCellRenderer.getPortName(RmonPmStatTableModel.this.rmonModels[n2]));
                    try {
                        long l = 0L;
                        if (RmonPmStatTableModel.this.supportsClearPM) {
                            l = RmonPmStatTableModel.this.rmonModels[n2].getStatsLastClearedTime();
                        }
                        ((RmonPmStatTableModel)RmonPmStatTableModel.this).lastCleared[n2] = l == 0L ? "Never Cleared" : RmonPmStatTableModel.this.timeConverter.convertSecondsToFormattedTimeZoneString(l);
                        ((RmonPmStatTableModel)RmonPmStatTableModel.this).linkStatus[n2] = RmonPmStatTableModel.this.rmonModels[n2].getLineStatus() ? "Up" : "Down";
                        PortModel portModel = RmonPmStatTableModel.this.rmonModels[n2].getPortModel();
                        sRPRSpanStateInfo sRPRSpanStateInfo2 = null;
                        if (RmonPmStatTableModel.this.moduleModel.isRPRMode()) {
                            if (portModel instanceof L2scPosPortModel) {
                                L2scPosPortModel l2scPosPortModel = null;
                                l2scPosPortModel = (L2scPosPortModel)portModel;
                                sRPRSpanStateInfo2 = l2scPosPortModel.getRPRSpanStateInfo();
                            }
                            if (sRPRSpanStateInfo2 != null && !sRPRSpanStateInfo2.adminState) {
                                ((RmonPmStatTableModel)RmonPmStatTableModel.this).linkStatus[n2] = "Pass Through";
                            }
                        }
                        ((RmonPmStatTableModel)RmonPmStatTableModel.this).lineStats[n2] = RmonPmStatTableModel.this.getCurrentStats(n2);
                        continue;
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        RmonPmStatTableModel.this.clearData(n2);
                        if (!db.on()) continue;
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
            }
            catch (Exception exception) {
                RmonPmStatTableModel.this.clearAllData();
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            finally {
                RmonPmStatTableModel.this.fireTableDataChanged();
                RmonPmStatTableModel.this.jobInProgress = false;
                if (RmonPmStatTableModel.this.jobObserver != null) {
                    RmonPmStatTableModel.this.jobObserver.asyncUpdate(null, JobStatus.JOB_COMPLETE);
                    RmonPmStatTableModel.this.jobObserver = null;
                }
            }
        }
    }
}

