/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.RmonModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.rmon.RmonPmUtilTableModel;
import cerent.util.SDebug;
import cerent.util.gui.TransmitReceive;
import cerent.util.gui.TransmitReceivePercentCellRenderer;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RmonPmUtilPane
extends AbstractPane
implements ActionListener,
Observer {
    private int[] widths = new int[]{150, 80};
    private JButton retrieveButton;
    private JLabel retrievalTime;
    private UComboBox seriesCB;
    private RmonPmUtilTableModel dataModel;
    private IRmonModel[] rmonModels;
    private ModuleModel eqpmtModel;
    private static final SDebug db = new SDebug("RmonPmUtilPane");

    public RmonPmUtilPane(String string, TabbedView tabbedView, IRmonModel[] iRmonModelArray) {
        this(string, tabbedView, null, iRmonModelArray);
        this.eqpmtModel = (ModuleModel)this.getUiModel();
    }

    public RmonPmUtilPane(String string, TabbedView tabbedView, ModuleModel moduleModel, IRmonModel[] iRmonModelArray) {
        super(string, tabbedView);
        this.registerWithModel();
        this.setRmonModels(iRmonModelArray);
        this.eqpmtModel = moduleModel;
    }

    private void setRmonModels(IRmonModel[] iRmonModelArray) {
        ArrayList<IRmonModel> arrayList = new ArrayList<IRmonModel>();
        for (int i = 0; i < iRmonModelArray.length; ++i) {
            if (!iRmonModelArray[i].supportsRmonUtil()) continue;
            arrayList.add(iRmonModelArray[i]);
        }
        this.rmonModels = arrayList.toArray(new IRmonModel[0]);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof RmonLineUpdate) {
            RmonLineUpdate rmonLineUpdate = (RmonLineUpdate)object;
            if (db.on()) {
                db.println("Received RmonLineUpdate...");
                db.println("OLD RMON #=" + this.rmonModels.length + " NEW RMON #=" + rmonLineUpdate.getRmonModels().length);
            }
            this.setRmonModels(rmonLineUpdate.getRmonModels());
            if (this.dataModel != null) {
                this.dataModel.refreshMyLines(this.rmonModels);
                try {
                    int n = this.seriesCB.getSelectedIndex();
                    if (n != -1) {
                        this.dataModel.refresh((short)n);
                    }
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
                catch (InternalCommError internalCommError) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)internalCommError);
                    }
                }
                catch (NoSuchStatsSeries noSuchStatsSeries) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchStatsSeries);
                    }
                }
            }
        } else {
            db.fine("refreshMyLines received " + object);
        }
    }

    private void init() {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        this.dataModel = new RmonPmUtilTableModel(this, this.eqpmtModel, this.rmonModels);
        this.retrievalTime = new JLabel(" ");
        this.retrievalTime.setHorizontalAlignment(0);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(TransmitReceive.class, new TransmitReceivePercentCellRenderer());
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        UTable uTable = new UTable((TableModel)this.dataModel);
        uTable.setExportable(false);
        uTable.getTableHeader().setUpdateTableInRealTime(false);
        uTable.setDefaultRenderer(TransmitReceive.class, new TransmitReceivePercentCellRenderer());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        this.table.setRowHeight(new JTextArea().getPreferredSize().height * 2 + 1);
        uTable.setRowHeight(new JTextArea().getPreferredSize().height * 2 + 1);
        for (int i = 0; i < this.dataModel.getFixedColumnCount(); ++i) {
            serializable = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn((TableColumn)serializable);
            ((TableColumn)serializable).setPreferredWidth(this.widths[i]);
            ((TableColumn)serializable).setResizable(false);
            ((TableColumn)serializable).setMinWidth(this.widths[i]);
            ((TableColumn)serializable).setMaxWidth(this.widths[i]);
            defaultTableColumnModel.addColumn((TableColumn)serializable);
        }
        this.table.setColumnModel(tableColumnModel);
        uTable.setColumnModel(defaultTableColumnModel);
        uTable.setPreferredScrollableViewportSize(uTable.getPreferredSize());
        uTable.getTableHeader().setReorderingAllowed(false);
        uTable.setAutoCreateColumnsFromModel(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        uTable.setCellSelectionEnabled(false);
        uTable.setRowSelectionAllowed(false);
        uScrollPane.setRowHeaderView((Component)uTable);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)uTable.getTableHeader());
        JPanel jPanel = RmonPmUtilPane.createVerticalPanel(null);
        this.retrievalTime.setAlignmentX(0.0f);
        uScrollPane.setAlignmentX(0.0f);
        serializable = RmonPmUtilPane.createHorizontalPanel(null);
        ((Container)serializable).setLayout(new FlowLayout(0, 5, 5));
        ((Container)serializable).add(this.retrievalTime);
        jPanel.add(this.makeControlPanel());
        jPanel.add((Component)serializable);
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void fixedUpColumn() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < this.dataModel.getFixedColumnCount(); ++i) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        this.table.repaint();
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = RmonPmUtilPane.createHorizontalPanel(null);
        this.seriesCB = new UComboBox((Object[])ElementDefaults.PM_INTERVAL_TYPES);
        this.seriesCB.setSelectedIndex(0);
        this.retrieveButton = new JButton("Refresh");
        this.retrieveButton.addActionListener(this);
        jPanel2.add(new JLabel("Interval:"));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this.seriesCB);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.retrieveButton);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(new CSHelpButton(CSHelpConst.RmonPmUtilPane));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 50, 5, 50));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)new JLabel(), "East");
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.retrieveButton) {
            this.refreshNow();
        }
    }

    public void enteringPage() {
        if (this.dataModel == null) {
            this.init();
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.refreshNow();
    }

    public void leavingPage() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNow() {
        try {
            this.setCursor(3);
            int n = this.seriesCB.getSelectedIndex();
            if (n != -1) {
                this.dataModel.refresh((short)n);
                String string = this.dataModel.getLastIntervalTimeStamp();
                if (string.length() > 0) {
                    this.retrievalTime.setText("\"Prev\" " + RmonModel.getSeriesDesc(n) + " interval start time:  " + string);
                } else {
                    this.retrievalTime.setText(" ");
                }
            }
        }
        catch (InternalCommError internalCommError) {
            db.println("Caught InternalCommError in refreshNow!");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)internalCommError);
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Caught exception in RmonPmUtilPane.refreshNow: " + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in RmonPmUtilPane.refreshNow: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.setCursor(0);
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }
}

