/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SlotModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AmplifierPortGraphic;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ChangeCardDialog;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public abstract class AbstractAmplifierCard
extends CardGraphic
implements ActionListener {
    protected AmplifierPortGraphic[] portGraphics = null;

    protected AbstractAmplifierCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.addPortGraphics(entityModel);
    }

    protected void addPortGraphics(EntityModel entityModel) {
        if (entityModel instanceof ModuleModel) {
            int n;
            List list = entityModel.getChildren();
            int n2 = list.size();
            this.portGraphics = new AmplifierPortGraphic[n2];
            int n3 = this.cardPainter.getMiniPortHeight();
            int n4 = this.cardPainter.getMiniPortWidth();
            int n5 = this.cardPainter.getMultiPortOpticonXOffset();
            int n6 = this.cardPainter.getMiniOpticonYSpacing();
            int n7 = this.cardPainter.getMiniOpticonYOffset();
            int n8 = this.cardPainter.getOpticonXSpacing();
            int n9 = 0;
            for (n = 0; n < n2; n += 2) {
                this.portGraphics[n] = new AmplifierPortGraphic((CardGraphic)this, n5 + n8 * n - 6, n7 + ((n6 - 7) * n + n9), n4, n3, (OpticsPortModel)list.get(n));
            }
            n9 = 0;
            n = 0;
            for (int i = 1; i < n2; i += 2) {
                this.portGraphics[i] = new AmplifierPortGraphic((CardGraphic)this, n5 + n8 * i + 6, n7 + ((n6 - 7) * n + n9), n4, n3, (OpticsPortModel)list.get(i));
                n += 2;
            }
            if (this.hasProvisionedCard()) {
                this.alarmStore.enablePortAlarmsStatus((ModuleModel)entityModel);
                this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
            }
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].update(observable, this.alarmStore);
            }
        }
    }

    public void dispose() {
        if (this.hasProvisionedCard()) {
            this.alarmStore.disablePortAlarmsStatus();
        }
        super.dispose();
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].dispose();
                this.portGraphics[i] = null;
            }
            this.portGraphics = null;
        }
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
        SlotModel slotModel;
        ModuleModel moduleModel;
        IEntityModel iEntityModel;
        IEntityModel iEntityModel2 = this.getModel();
        if (iEntityModel2 != null && iEntityModel2 instanceof ModuleModel && (iEntityModel = (moduleModel = (ModuleModel)iEntityModel2).getParent()) instanceof SlotModel && (slotModel = (SlotModel)iEntityModel).getListOfValidChangeType(eEqType.from_int(moduleModel.getEqType())).size() > 0) {
            jPopupMenu.addSeparator();
            boolean bl = AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.PROVISIONING);
            boolean bl2 = this.isCardChangeAllowed() && bl;
            jPopupMenu.add(this.makeMenuAction("Change Card...", bl2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand().equals("Change Card...")) {
                new ChangeCardDialog(JOptionPane.getFrameForComponent(this.parent), (ModuleModel)this.getModel());
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    protected String getStateString() {
        return ElementDefaults.eqStateToString(this.eqState);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        if (this.pci.is600()) {
            return;
        }
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].drawOnlyOneConnector(graphics2D, true, false);
        }
    }
}

