/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SlotModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ChangeCardDialog;
import cerent.cms.ui.shelf.MuxDmxPortGraphic;
import cerent.util.SDebug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public abstract class AbstractMuxDmxCard
extends CardGraphic
implements ActionListener {
    protected MuxDmxPortGraphic[] portGraphics = null;
    protected int numPorts;
    protected int Y_Init_Point;

    protected AbstractMuxDmxCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.addPortGraphics(entityModel);
    }

    protected abstract void addPortGraphics(EntityModel var1);

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            if (this.portGraphics != null) {
                for (int i = 0; i < this.portGraphics.length; ++i) {
                    if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                    return this.portGraphics[i].getTooltipText();
                }
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].update(observable, this.alarmStore);
            }
        }
    }

    public void dispose() {
        if (this.hasProvisionedCard()) {
            this.alarmStore.disablePortAlarmsStatus();
        }
        super.dispose();
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].dispose();
                this.portGraphics[i] = null;
            }
            this.portGraphics = null;
        }
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
        SlotModel slotModel;
        ModuleModel moduleModel;
        IEntityModel iEntityModel;
        IEntityModel iEntityModel2 = this.getModel();
        if (iEntityModel2 != null && iEntityModel2 instanceof ModuleModel && (iEntityModel = (moduleModel = (ModuleModel)iEntityModel2).getParent()) instanceof SlotModel && (slotModel = (SlotModel)iEntityModel).getListOfValidChangeType(eEqType.from_int(moduleModel.getEqType())).size() > 0) {
            jPopupMenu.addSeparator();
            boolean bl = AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.PROVISIONING);
            boolean bl2 = this.isCardChangeAllowed() && bl;
            jPopupMenu.add(this.makeMenuAction("Change Card...", bl2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand().equals("Change Card...")) {
                new ChangeCardDialog(JOptionPane.getFrameForComponent(this.parent), (ModuleModel)this.getModel());
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    protected String getStateString() {
        return ElementDefaults.eqStateToString(this.eqState);
    }
}

