/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.G1000CardView;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractOPG
extends Rectangle
implements Observer {
    private static final int FACILITY_LPBK_MASK = 1;
    private static final int TERMINAL_LPBK_MASK = 2;
    private static final int HATCH_PORT_MASK = 4;
    public static final int PORT_SIZE_NORMAL = 0;
    protected static final int PORT_SIZE_SMALL = 1;
    private int portNo;
    private int slotNo;
    private CardGraphic parent;
    private ElementAlarmStore alarmStore;
    private InterfaceModel ifModel;
    protected EntityCellRenderer myPortRenderer = new EntityCellRenderer();
    protected PortModel portModel;
    private String statusString = "";
    private String alarmProfileString = "";
    private Color currentColor = Color.gray;
    private int currentSeverity = 0;
    private int currentAdminStatus = -1;
    private int currentPortState = 0;
    private int currentServiceStateType = -1;
    private String Tl1PortDescription = "";
    protected IPlatform pci;
    protected ICardPainter cardPainter;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfLayout.db, "AbstractPortGraphic");

    protected AbstractOPG(CardGraphic cardGraphic, int n, int n2, int n3, int n4, PortModel portModel) {
        super(n, n2, n3, n4);
        this.parent = cardGraphic;
        this.portModel = portModel;
        this.pci = portModel.getNodeModelDelegate().getPlatform();
        this.cardPainter = cardGraphic.getCardPainter();
        this.slotNo = this.portModel.getSlot();
        this.portNo = this.portModel.getPort();
        this.alarmStore = (ElementAlarmStore)portModel.getNodeModelDelegate().getElementAlarmStore().getCardAlarmStore(portModel.getShelfId(), this.slotNo);
        Thread thread = new Thread("OpticalPort Init:" + this.slotNo + ":" + this.portNo){

            public void run() {
                if (AbstractOPG.this.portModel != null) {
                    InterfaceModel interfaceModel = (InterfaceModel)AbstractOPG.this.portModel.getInterfaceModel();
                    AbstractOPG.this.setIfModel(interfaceModel);
                    AbstractOPG.this.registerWithModel(interfaceModel);
                    AbstractOPG.this.updateCurrentState(interfaceModel);
                }
            }
        };
        thread.start();
    }

    private void setIfModel(InterfaceModel interfaceModel) {
        this.ifModel = interfaceModel;
    }

    protected InterfaceModel getIfModel() {
        return this.ifModel;
    }

    public PortModel getPortModel() {
        return this.portModel;
    }

    private void repaint(CardGraphic cardGraphic) {
        if (cardGraphic != null) {
            cardGraphic.repaint();
        }
    }

    public void update(Observable observable, Object object) {
        if (object == ModelUpdateType.CHANGED) {
            if (db.on()) {
                db.println("Got state changed message");
            }
            this.updateCurrentState(this.getIfModel());
        } else if (object == ModelUpdateType.DELETED) {
            if (db.on()) {
                db.println("Got deleted message");
            }
            observable.deleteObserver(this);
        } else if (object instanceof ElementAlarmStore) {
            ElementAlarmStore elementAlarmStore = (ElementAlarmStore)object;
            if (this.portModel != null) {
                IAlarmStatus iAlarmStatus = elementAlarmStore.getEntityAlarmStatus(this.portModel);
                if (iAlarmStatus != null) {
                    db.fine("SlotNo=" + this.slotNo + ", PortNo=" + this.portNo + ", portEqType=" + this.portModel.getEqType() + ", AlarmStatus=" + iAlarmStatus + ", highest=" + iAlarmStatus.getHighestSeverity());
                    this.setAlarmState(iAlarmStatus.getHighestSeverity());
                } else {
                    this.setAlarmState(0);
                }
            }
        }
    }

    protected abstract String getPhysicalMediumDescription();

    private String getPortDescription() {
        StringBuffer stringBuffer = new StringBuffer("Port ");
        InterfaceModel interfaceModel = this.getIfModel();
        if (interfaceModel != null) {
            if (interfaceModel instanceof AbstractOpticsLineModel) {
                stringBuffer.append("[");
                stringBuffer.append(this.myPortRenderer.getPortString(this.portModel, false));
                stringBuffer.append(" (");
                AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)this.ifModel;
                try {
                    this.Tl1PortDescription = abstractOpticsLineModel.getPortTypeString();
                }
                catch (Exception exception) {
                    this.Tl1PortDescription = new String("N/A");
                }
                stringBuffer.append(this.Tl1PortDescription);
                stringBuffer.append(")]: ");
            } else {
                stringBuffer.append("[");
                stringBuffer.append(this.myPortRenderer.getPortString(this.portModel, false));
                stringBuffer.append("]: ");
            }
        } else {
            stringBuffer.append("[");
            stringBuffer.append(this.portNo);
            stringBuffer.append("]: ");
        }
        return stringBuffer.toString();
    }

    protected String getProtectionDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ifModel instanceof TdmLineModel) {
            stringBuffer.append(this.myPortRenderer.getSonetLineProtectionDescription((TdmLineModel)this.ifModel, true));
        }
        return stringBuffer.toString();
    }

    public String getTooltipText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPortDescription());
        stringBuffer.append(this.getPhysicalMediumDescription());
        try {
            stringBuffer.append(this.statusString);
            if (this.ifModel instanceof AbstractOpticsLineModel) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.getAlarmStatusString());
            stringBuffer.append(this.getProtectionDescription());
            stringBuffer.append(", Alarm Profile: ");
            stringBuffer.append(this.alarmProfileString);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Failed trying to generate tooltip string: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
            stringBuffer.setLength(0);
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        block6: {
            InterfaceModel interfaceModel = this.getIfModel();
            if (interfaceModel != null) {
                if (db.on()) {
                    db.println("Deleting observer " + interfaceModel + " Slot " + this.slotNo);
                }
                interfaceModel.deleteObserver(this);
                try {
                    if (this.portModel != null) {
                        if (db.on()) {
                            db.println("Deleting observer " + this.portModel + " Port " + this.portNo);
                        }
                        this.portModel.deleteObserver(this);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block6;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.setIfModel(null);
        this.parent = null;
        this.portModel = null;
    }

    public boolean equals(Object object) {
        if (object instanceof OpticalPortGraphic) {
            return object == this;
        }
        return super.equals(object);
    }

    protected void setAlarmState(int n) {
        if (db.on()) {
            db.println("set alrm st=" + n);
        }
        if (this.currentSeverity != n) {
            this.currentSeverity = n;
            this.updateCurrentState(this.getIfModel());
            this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminStatus, n);
            this.repaint(this.parent);
        }
    }

    private void updateCurrentState(InterfaceModel interfaceModel) {
        int n;
        boolean bl;
        IServiceState iServiceState;
        TDMTerminology tDMTerminology;
        int n2;
        block8: {
            if (interfaceModel == null || this.portModel == null) {
                return;
            }
            n2 = 0;
            tDMTerminology = this.portModel.getNodeModel().getTDMTerminology();
            iServiceState = null;
            try {
                this.alarmProfileString = this.portModel.getAlarmProfileName();
            }
            catch (Exception exception) {
                this.alarmProfileString = "(Error Retrieving)";
            }
            bl = false;
            try {
                n2 = interfaceModel.getAdminState();
                iServiceState = interfaceModel.getServiceSt();
                bl = n2 != this.currentAdminStatus || this.currentPortState != this.getPortState();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Caught exception in updateCurrentState");
                if (!db.on()) break block8;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        int n3 = n = iServiceState == null ? -1 : iServiceState.getType();
        if (this.currentServiceStateType != n) {
            this.currentServiceStateType = n;
            this.statusString = tDMTerminology.getTermForServiceState(this.currentServiceStateType);
        }
        if (n2 != this.currentAdminStatus) {
            this.currentAdminStatus = n2;
            this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminStatus, this.currentSeverity);
        }
        if (bl) {
            this.repaint(this.parent);
        }
    }

    private int getPortState() {
        int n = 0;
        if (this.isFacilityLoopback()) {
            n |= 1;
        } else if (this.isTerminalLoopback()) {
            n |= 2;
        }
        if (this.shouldCrossHatchPort()) {
            n |= 4;
        }
        return n;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    protected void registerWithModel(InterfaceModel interfaceModel) {
        block5: {
            if (interfaceModel != null) {
                if (db.on()) {
                    db.println("registering with " + interfaceModel);
                }
                interfaceModel.addObserver(this);
                try {
                    if (db.on()) {
                        db.println("registering with " + this.portModel);
                    }
                    this.portModel.addObserver(this);
                }
                catch (Exception exception) {
                    if (!AbstractOPG.db.on) break block5;
                    db.println("Error adding port model as observer");
                }
            }
        }
    }

    private int getConnectorSize() {
        if (this.pci.is600() || this.pci.is455() && this.portModel.getParent() instanceof PpmModel) {
            return 1;
        }
        if (this.portModel != null && this.portModel.isSpecial()) {
            return 3;
        }
        return 2;
    }

    public void draw(Graphics2D graphics2D) {
        Color color;
        CubicCurve2D.Double double_;
        int n = this.getConnector1XOffset();
        int n2 = this.getConnector2XOffset();
        int n3 = this.getConnector1YOffset();
        int n4 = this.getConnector2YOffset();
        double d = n;
        double d2 = n3;
        double d3 = n2;
        double d4 = n4;
        double d5 = Math.min(d2, d4);
        double d6 = Math.max(d2, d4);
        double d7 = Math.min(d, d3);
        double d8 = Math.max(d, d3);
        Rectangle rectangle = new Rectangle(n, n3, this.getConnectorSize(), this.getConnectorSize());
        Rectangle rectangle2 = new Rectangle(n2, n4, this.getConnectorSize(), this.getConnectorSize());
        graphics2D.setColor(this.getCurrentColor());
        graphics2D.fill(this);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this);
        graphics2D.fill(rectangle);
        graphics2D.fill(rectangle2);
        this.currentPortState = this.getPortState();
        if ((this.currentPortState & 1) != 0) {
            double_ = !this.pci.positionPortsVertically() ? new CubicCurve2D.Double(d, d2, d7 + (d8 - d7) / 5.0, d2 + this.getHeight() / 1.7, d8 - (d8 - d7) / 100.0, d4 + this.getHeight() / 1.7, d3, d4) : new CubicCurve2D.Double(d, d2, d - this.getWidth() / 2.25, Math.abs(d2 - d4) / 100.0 + d5, d3 - this.getWidth() / 2.25, d6 - Math.abs(d2 - d4) / 100.0, d3, d4);
            G1000CardView.drawArrow(graphics2D, this, true, true, !this.pci.positionPortsVertically(), Color.gray);
            color = graphics2D.getColor();
            graphics2D.setColor(Color.gray);
            graphics2D.draw(double_);
            graphics2D.setColor(color);
        } else if ((this.currentPortState & 2) != 0) {
            double_ = !this.pci.positionPortsVertically() ? new CubicCurve2D.Double(d, d2, (d8 - d7) / 5.0 + d7, d2 - this.getHeight() / 2.5, d8 - (d8 - d7) / 100.0, d4 - this.getHeight() / 2.5, d3, d4) : new CubicCurve2D.Double(d, d2, d + this.getWidth() / 2.25, Math.abs(d2 - d4) / 100.0 + d5, d3 + this.getWidth() / 2.25, d6 - Math.abs(d2 - d4) / 100.0, d3, d4);
            color = graphics2D.getColor();
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.setColor(color);
        }
        if ((this.currentPortState & 4) != 0) {
            int n5 = (int)this.getHeight();
            int n6 = (int)this.getWidth();
            Color color2 = graphics2D.getColor();
            graphics2D.setColor(Color.black);
            Shape shape = graphics2D.getClip();
            graphics2D.clipRect(this.x, this.y, n6, n5);
            for (int i = 0; i < n5; i += 3) {
                graphics2D.drawLine(this.x + n6, this.y + i + 1, this.x, this.y + i + 5);
                graphics2D.drawLine(this.x + n6 - 1, this.y + i + 1, this.x + 1, this.y + i + 5);
                graphics2D.drawLine(this.x + n6 - 2, this.y + i + 1, this.x + 2, this.y + i + 5);
            }
            graphics2D.setColor(color2);
            graphics2D.setClip(shape);
        }
    }

    private boolean isInService() throws NoSuchInterface {
        InterfaceModel interfaceModel = this.getIfModel();
        if (interfaceModel != null) {
            int n = interfaceModel.getAdminState();
            return 1 != n && n != -1;
        }
        return false;
    }

    private ElementModel getElementModel() throws AbstractCmsNoSuchElementException {
        InterfaceModel interfaceModel = this.getIfModel();
        ElementModel elementModel = null;
        if (interfaceModel != null) {
            try {
                elementModel = interfaceModel.getElementModel();
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                InterfaceModel interfaceModel2 = interfaceModel.getHighestParent();
                if (interfaceModel2 != null && interfaceModel2 != interfaceModel) {
                    elementModel = interfaceModel2.getElementModel();
                }
                throw abstractCmsNoSuchElementException;
            }
        }
        return elementModel;
    }

    private boolean shouldCrossHatchPort() {
        block5: {
            try {
                ElementModel elementModel = this.getElementModel();
                if (elementModel != null) {
                    return this.isInService() && elementModel.getTypeEnum() != eElementType.UNPROTECTED_LINE && !this.isCurrentlyActive();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private String getAlarmStatusString() {
        String string = "";
        if (this.alarmStore == null) {
            db.fine("alarm store is null");
            return string;
        }
        IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(this.portModel);
        if (iAlarmStatus != null) {
            if (iAlarmStatus.critical() > 0) {
                string = "Critical";
            } else if (iAlarmStatus.major() > 0) {
                string = "Major";
            } else if (iAlarmStatus.minor() > 0) {
                string = "Minor";
            }
            string = string.length() > 0 ? ", " + string + " Alarm" : string;
        }
        db.fine("statusString=" + string);
        return string;
    }

    protected void drawOnlyOneConnector(Graphics2D graphics2D, boolean bl, boolean bl2) {
        int n = this.getConnector1XOffset();
        int n2 = this.getConnector1YOffset();
        int n3 = 0;
        if (bl) {
            n3 = 3;
        }
        Rectangle rectangle = new Rectangle(n, n2 + n3, this.getConnectorSize(), this.getConnectorSize());
        graphics2D.setColor(this.getCurrentColor());
        graphics2D.fill(this);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this);
        if (!bl2) {
            graphics2D.fill(rectangle);
        }
        this.currentPortState = this.getPortState();
        if ((this.currentPortState & 3) != 0) {
            int n4 = this.cardPainter.getPortLoopbackDist();
            graphics2D.drawLine(n, n2, n + n4, n2 + n4);
        }
    }

    protected abstract boolean isFacilityLoopback();

    protected abstract boolean isTerminalLoopback();

    protected abstract boolean isCurrentlyActive();

    protected abstract int getConnector1XOffset();

    protected abstract int getConnector2XOffset();

    protected abstract int getConnector1YOffset();

    protected abstract int getConnector2YOffset();
}

