/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.eLinkType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OsiModel;
import cerent.cms.model.RouterModel;
import cerent.cms.ui.AbstractRetrievalPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.OsiHelper;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public abstract class AbstractOsiRouterRibPane
extends AbstractRetrievalPane
implements ActionListener {
    protected final int SUBNET_TYPE_IDX = 0;
    protected final int SLOT_IDX = 1;
    protected final int DEST_NSAP_IDX = 2;
    protected final int SUBNET_ADDR_IDX = 3;
    protected final String[] columnNames = new String[]{"Subnet Type", "Location", "Destination Address", "MAC Address"};
    protected SortableRowTableModel tableModel;
    protected ArrayList tableData = new ArrayList();
    protected RouterModel routerModel;
    protected OsiModel osiModel;
    protected NodeModelDelegate nmd;
    protected JComboBox routerCB;
    protected static final SDebug db = new SDebug("OsiRouterRibPane");
    private JPanel routerPanel;
    private JPanel buttonPanel;

    public AbstractOsiRouterRibPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.nmd = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.routerModel = this.nmd.getRouterModel();
        this.osiModel = this.nmd.getOsiModel();
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new SubnetTypeColumnRenderer(), new SlotColumnRenderer(), new NsapColumnRenderer(), new SubnetAddrColumnRenderer()};
        this.tableModel = new SortableRowTableModel((RowDataSource)this.createDataSource(), columnRendererArray);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        this.table.setSelectionForeground(Color.white);
        this.tableModel.initTable(this.table);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        jPanel.add((Component)uScrollPane);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(Box.createVerticalStrut(5));
        this.routerPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.createRouterPanel();
        this.buttonPanel = super.createButtonPanel(this.routerPanel);
        jPanel.add((Component)this.buttonPanel, "South");
        this.add(jPanel);
    }

    private void createRouterPanel() {
        String[] stringArray;
        if (this.routerPanel.getComponentCount() == 0 && (stringArray = this.routerModel.getOsiRouters()).length > 1) {
            this.routerPanel.add(new JLabel("Router:"));
            this.routerCB = new JComboBox<String>(stringArray);
            this.routerCB.addActionListener(this);
            this.routerPanel.add(this.routerCB);
        }
    }

    private void removeRouterPanel() {
        if (this.routerPanel.getComponentCount() > 0) {
            this.routerPanel.removeAll();
        }
    }

    protected void updateBottomPanel() {
        if (this.osiModel.getRoutingMode() == 0) {
            this.removeRouterPanel();
        } else {
            this.createRouterPanel();
        }
        if (this.buttonPanel != null) {
            this.buttonPanel.invalidate();
        }
    }

    protected int getSelectedRouterNumber() {
        return this.routerCB == null ? 1 : this.routerCB.getSelectedIndex() + 1;
    }

    protected abstract AbstractRowDataSource createDataSource();

    protected abstract String getStringValue(Object var1, int var2);

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.routerCB)) {
            try {
                this.refresh();
            }
            catch (Exception exception) {
                this.handleRefreshException(exception);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected String subnetTypeStr(eLinkType eLinkType2) {
        switch (eLinkType2.value()) {
            case 0: {
                return "LAN";
            }
            case 2: {
                return this.nmd.getTDMTerminology().getGeneralTerms(8);
            }
            case 1: {
                return this.nmd.getTDMTerminology().getGeneralTerms(10);
            }
            case 3: {
                return "GCC";
            }
            case 4: {
                return "OSC";
            }
        }
        return "Internal";
    }

    protected String locationStr(eLinkType eLinkType2, int n) {
        switch (eLinkType2.value()) {
            case 0: {
                return "LAN";
            }
            case 5: {
                return "Router #" + Integer.toString(n);
            }
        }
        try {
            return OsiHelper.dccIndexToSlotPort((INodeModel)this.nmd, (int)n, (boolean)true);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return "!ERROR!";
        }
    }

    protected String subnetAddrStr(eLinkType eLinkType2, byte[] byArray) {
        switch (eLinkType2.value()) {
            case 0: {
                return OsiHelper.getSystemIdString((byte[])byArray);
            }
        }
        return "N/A";
    }

    public void destroy() {
        db.info("destroy");
        this.tableData.clear();
        this.tableModel = null;
        this.routerModel.deleteObserver((Observer)((Object)this));
        this.routerModel = null;
        super.destroy();
        this.nmd = null;
    }

    class SubnetAddrColumnRenderer
    extends BaseColumnRenderer {
        SubnetAddrColumnRenderer() {
        }

        public String getName() {
            return AbstractOsiRouterRibPane.this.columnNames[3];
        }

        public int getWidth() {
            return 175;
        }
    }

    class NsapColumnRenderer
    extends BaseColumnRenderer {
        NsapColumnRenderer() {
        }

        public String getName() {
            return AbstractOsiRouterRibPane.this.columnNames[2];
        }

        public int getWidth() {
            return 325;
        }
    }

    class SlotColumnRenderer
    extends BaseColumnRenderer {
        SlotColumnRenderer() {
        }

        public String getName() {
            return AbstractOsiRouterRibPane.this.columnNames[1];
        }

        public int getWidth() {
            return 75;
        }
    }

    class SubnetTypeColumnRenderer
    extends BaseColumnRenderer {
        SubnetTypeColumnRenderer() {
        }

        public String getName() {
            return AbstractOsiRouterRibPane.this.columnNames[0];
        }

        public int getWidth() {
            return 75;
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        protected BaseColumnRenderer() {
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = AbstractOsiRouterRibPane.this.getStringValue(jTable.getValueAt(n, 0), n2);
            JLabel jLabel = new JLabel(string);
            if (n2 == 2) {
                jLabel.setFont(OsiHelper.FIXED_WIDTH_FONT);
            }
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = AbstractOsiRouterRibPane.this.getStringValue(object, n);
            String string2 = AbstractOsiRouterRibPane.this.getStringValue(object2, n);
            return string.compareTo(string2);
        }
    }
}

