/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfTablePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;

public abstract class AbstractShelfEditTablePane
extends AbstractShelfTablePane
implements ActionListener,
MouseListener {
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    public static final String EDIT = "Edit...";
    protected JPanel buttons;
    protected JButton createButton;
    protected JButton deleteButton;
    protected JButton editButton;
    boolean disableAllButtons = false;

    public AbstractShelfEditTablePane(String string, TabbedView tabbedView) {
        this(string, null, tabbedView);
    }

    public AbstractShelfEditTablePane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
    }

    protected void localInit() {
        this.buttons = this.getButtonBar();
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.buttons, "South");
        this.setEditDeleteEnabled(false);
        this.setDataSourceControl();
        this.table.addMouseListener(this);
    }

    public void repopulateTable() {
        super.repopulateTable();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.model.getRowCount()) {
            this.setEditDeleteEnabled(false);
        }
    }

    public void disableAllButtons(boolean bl) {
        if (bl) {
            this.table.clearSelection();
        }
        this.disableAllButtons = bl;
        this.table.setRowSelectionAllowed(!bl);
        this.setEditDeleteEnabled(false);
    }

    public void setEditDeleteEnabled(boolean bl) {
        if (this.disableAllButtons) {
            WindowHelper.setEnabled((JComponent)this.createButton, (boolean)false);
            WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)false);
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
            return;
        }
        if (!bl) {
            this.clearTableSelection();
        } else if (!this.isUserAuthorized()) {
            bl = false;
        }
        WindowHelper.setEnabled((JComponent)this.createButton, (boolean)this.isUserAuthorized());
        WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)bl);
        WindowHelper.setEnabled((JComponent)this.editButton, (boolean)bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block12: {
            Object object = actionEvent.getSource();
            int n = this.table.getSelectedRow();
            if (object == this.createButton) {
                this.createTableEntry();
            } else if (object == this.deleteButton) {
                try {
                    if (n >= 0 && n < this.model.getRowCount()) {
                        this.deleteSelectedTableEntry(n);
                        break block12;
                    }
                    this.clearTableSelection();
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_OBJ_SEL_TO_DELETE_PARAM_1, (Object)this.ENTRY_TYPE);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DELETE_ERROR_PARAM_1, (Object)this.ENTRY_TYPE);
                }
            } else if (object == this.editButton) {
                try {
                    if (n >= 0 && n < this.model.getRowCount()) {
                        this.editSelectedTableEntry(n);
                    } else {
                        this.clearTableSelection();
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_OBJ_SEL_TO_EDIT_PARAM_1, (Object)this.ENTRY_TYPE);
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_EDIT_ERROR_PARAM_1, (Object)this.ENTRY_TYPE);
                }
            }
        }
    }

    protected abstract void createTableEntry();

    protected abstract void editSelectedTableEntry(int var1);

    protected abstract void deleteSelectedTableEntry(int var1);

    protected JPanel getButtonBar() {
        this.createButton = this.makeActionButton(CREATE);
        this.deleteButton = this.makeActionButton(DELETE);
        this.editButton = this.makeActionButton(EDIT);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(this.createButton);
        cSHelpButtonPane.addLeft(this.editButton);
        cSHelpButtonPane.addLeft(this.deleteButton);
        return cSHelpButtonPane;
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        this.enableComponent(jButton);
        return jButton;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (tableModelEvent.getType() == 0) {
            try {
                int n = this.model.getRowCount();
                boolean bl = n == 0;
                int n2 = this.getTable().getSelectedRow();
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                }
                this.setEditDeleteEnabled(!bl);
            }
            catch (Exception exception) {
                this.setEditDeleteEnabled(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.setEditDeleteEnabled(false);
        } else {
            this.setEditDeleteEnabled(true);
        }
    }

    protected abstract void setDataSourceControl();

    protected abstract void registerWithModels();

    protected void resetObservableManager() {
        this.getObservableManager().reset();
    }

    protected void setObservableManagerActive() {
        this.getObservableManager().setActive(true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
                return;
            }
            this.editSelectedTableEntry(n);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

