/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IProgressManager;
import cerent.cms.model.IServiceState;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.shelf.ColorBehaviour;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public abstract class AbstractShelfLayout
extends JPanel {
    protected JPanel labelsPanel;
    protected JLabel[] labels;
    protected JPanel slotsPanel;
    protected CardPanel[] cards;
    protected CardPanel selectedCard = null;
    protected IUiToolkit uiToolkit = null;
    private int currentSelectionIndex;
    protected IChassisModel chassis;
    protected AbstractViewController avc;
    protected Highlighter highLighter = new Highlighter(this);
    protected MouseInputAdapter mouseListener = null;
    protected static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    protected static final Border THIN_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    protected static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 3);
    protected static final Color SELECTED_FOREGROUND_COLOR = Color.white;
    protected static final Color SELECTED_BACKGROUND_COLOR;
    protected static final Color UNSELECTED_FOREGROUND_COLOR;
    protected int chassisType;
    protected Color currShelfColor = ElementDefaults.PROVISIONED_COLOR;
    private static final Color DEF_COL;
    private static final Color DEF_BORD_COL;
    protected BayViewPanel bvp;
    public static final SDebug db;

    protected AbstractShelfLayout(IChassisModel iChassisModel, AbstractViewController abstractViewController) {
        this(iChassisModel, abstractViewController, null);
    }

    protected AbstractShelfLayout(IChassisModel iChassisModel, AbstractViewController abstractViewController, BayViewPanel bayViewPanel) {
        super(new GridBagLayout());
        this.chassis = iChassisModel;
        this.avc = abstractViewController;
        this.uiToolkit = abstractViewController.getUiToolkit();
        this.bvp = bayViewPanel;
        this.init();
    }

    protected void init() {
        this.mouseListener = this.getMouseClickProcessor();
        this.chassisType = this.chassis.getEqType();
        this.cards = new CardPanel[this.getShelfSlotCount()];
        this.populateShelf();
        this.configSpecialModule();
    }

    protected void refreshShelfColor() {
    }

    protected MouseInputAdapter getMouseClickProcessor() {
        return new MouseClickProcessor();
    }

    protected abstract void addLabels();

    protected abstract void removeLabels();

    protected abstract void createLabels();

    protected abstract void createSlotsPanel();

    protected void createFanPanel() {
    }

    protected abstract void addPanels();

    protected abstract int getShelfSlotCount();

    protected abstract Font getTextFont();

    public void populateShelf() {
        EntityModel entityModel;
        Serializable serializable;
        Object object;
        this.createLabels();
        this.createSlotsPanel();
        this.createFanPanel();
        this.addPanels();
        this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        for (int i = 0; i < this.cards.length; ++i) {
            object = this.cards[i].getIcon();
            serializable = new Dimension(object.getIconWidth(), object.getIconHeight());
            this.cards[i].setPreferredSize((Dimension)serializable);
            this.cards[i].setMinimumSize((Dimension)serializable);
            this.cards[i].setBorder(THIN_BORDER);
            this.cards[i].setFont(this.getTextFont());
            this.labels[i].setForeground(UNSELECTED_FOREGROUND_COLOR);
        }
        this.addLabels();
        if (this.selectedCard != null) {
            this.selectedCard.setBorder(SELECTED_BORDER);
        } else {
            AbstractViewController.setActiveObject(null);
        }
        if (db.on()) {
            db.println("fetching chassis");
        }
        if ((entityModel = (EntityModel)((Object)this.chassis)) == null && db.on()) {
            db.println("no chassis found");
        }
        if (db.on()) {
            db.println("fetching backplanes");
        }
        if ((object = entityModel.getChildrenOfType(eClass.BACKPLANE)) == null && db.on()) {
            db.println("no backplanes found");
        }
        serializable = null;
        if (object != null && object.size() > 0) {
            serializable = (EntityModel)object.get(0);
        }
        if (serializable == null && db.on()) {
            db.println("no backplane found");
        }
        List list = null;
        if (serializable != null) {
            list = ((EntityModel)serializable).getChildren();
        }
        if (list == null && db.on()) {
            db.println("no slots found");
        }
        int n = list != null ? list.size() : this.getShelfSlotCount();
        IProgressManager iProgressManager = this.chassis.getNodeModel().getProgressManager();
        iProgressManager.startStep("Slot Initialization");
        String string = " ";
        EntityModel entityModel2 = null;
        for (int i = 1; i <= n; ++i) {
            String string2 = "Empty";
            if (i == 10) {
                string = "";
            }
            if (list != null) {
                Object object2;
                List list2;
                if (db.on()) {
                    db.println("model exists for slot " + i);
                }
                if ((list2 = (entityModel2 = (EntityModel)list.get(i - 1)).getChildren()).size() > 0 && (object2 = list2.get(0)) instanceof ModuleModel) {
                    ModuleModel moduleModel = (ModuleModel)object2;
                    string2 = moduleModel.getEqTypeName();
                }
                if (db.on()) {
                    db.println("creating card for slot " + i);
                }
                object2 = this.createCard(entityModel2);
                this.addCard(i, (CardGraphic)object2, entityModel2);
            }
            iProgressManager.addStepInfo("Slot " + string + i + " --> " + string2);
        }
        this.repaint();
    }

    protected CardGraphic createCard(EntityModel entityModel) {
        return this.chassis.getPlatform().createCard(entityModel, this);
    }

    public IChassisModel getChassis() {
        return this.chassis;
    }

    public void addCard(int n, CardGraphic cardGraphic, EntityModel entityModel) {
        if (this.validCardNumber(n)) {
            if (db.on()) {
                db.println("card number " + n + " card " + cardGraphic);
            }
            this.cards[--n].setEntityM(entityModel);
            this.cards[n].setIcon(cardGraphic);
            this.cards[n].repaint();
        }
    }

    public void removeCard(int n) {
        if (this.validCardNumber(n)) {
            this.cards[n - 1].setIcon(null);
        }
    }

    protected int getFirstRowSlotCount() {
        return this.cards.length;
    }

    private boolean validCardNumber(int n) {
        boolean bl;
        boolean bl2 = bl = n > 0 && n <= this.getShelfSlotCount();
        if (!bl && db.on()) {
            db.println("Invalid card ignored: " + n);
        }
        return bl;
    }

    public void refresh() {
        for (int i = 0; i < this.cards.length; ++i) {
            this.cards[i].repaint();
        }
        this.repaint();
    }

    public static JLabel formatLabel(JLabel jLabel) {
        if (jLabel != null) {
            jLabel.setForeground(Color.black);
        }
        return jLabel;
    }

    private void mousePressed(CardPanel cardPanel) {
        int n;
        int n2;
        int n3;
        if (this.selectedCard != null) {
            this.selectedCard.setBorder(THIN_BORDER);
            this.labels[this.currentSelectionIndex].setOpaque(false);
            this.labels[this.currentSelectionIndex].setForeground(UNSELECTED_FOREGROUND_COLOR);
            this.labels[this.currentSelectionIndex].repaint();
            if (this.selectedCard.getIcon() instanceof CardGraphic) {
                n3 = ((CardGraphic)this.selectedCard.getIcon()).getSlotsOccupied();
                n2 = this.currentSelectionIndex;
                for (n = 1; n < n3; ++n) {
                    this.labels[++n2].setOpaque(false);
                    this.labels[n2].setForeground(UNSELECTED_FOREGROUND_COLOR);
                    this.labels[n2].repaint();
                }
            }
        }
        this.currentSelectionIndex = 0;
        while (this.currentSelectionIndex < this.cards.length) {
            if (this.cards[this.currentSelectionIndex] == cardPanel) {
                this.selectedCard = cardPanel;
                this.selectedCard.setBorder(SELECTED_BORDER);
                this.selectedCard.repaint();
                this.labels[this.currentSelectionIndex].setOpaque(true);
                this.labels[this.currentSelectionIndex].setBackground(SELECTED_BACKGROUND_COLOR);
                this.labels[this.currentSelectionIndex].setForeground(SELECTED_FOREGROUND_COLOR);
                this.labels[this.currentSelectionIndex].repaint();
                if (this.selectedCard.getIcon() instanceof CardGraphic) {
                    n3 = ((CardGraphic)this.selectedCard.getIcon()).getSlotsOccupied();
                    n2 = this.currentSelectionIndex;
                    for (n = 1; n < n3; ++n) {
                        this.labels[++n2].setOpaque(true);
                        this.labels[n2].setBackground(SELECTED_BACKGROUND_COLOR);
                        this.labels[n2].setForeground(SELECTED_BACKGROUND_COLOR);
                        this.labels[n2].repaint();
                    }
                }
                EntityModel entityModel = cardPanel.getEntityModel();
                ModuleModel moduleModel = null;
                entityModel = this.cards[this.currentSelectionIndex].getEntityModel();
                if (entityModel.getChildren().size() > 0) {
                    moduleModel = (ModuleModel)entityModel.getChildren().get(0);
                }
                if (moduleModel != null) {
                    if (CardTabbedViewFactory.isCardViewAvailable(moduleModel)) {
                        AbstractViewController.setActiveObject((Object)cardPanel);
                    } else {
                        AbstractViewController.setActiveObject(null);
                    }
                } else {
                    AbstractViewController.setActiveObject(null);
                }
                return;
            }
            ++this.currentSelectionIndex;
        }
        this.currentSelectionIndex = 0;
        this.selectedCard = null;
    }

    public void destroy() {
        if (this.cards != null) {
            for (int i = 0; i < this.cards.length; ++i) {
                if (this.cards[i] == null) continue;
                this.cards[i].removeMouseListener(this.mouseListener);
                this.cards[i].destroy();
                this.cards[i] = null;
            }
            this.cards = null;
        }
        this.mouseListener = null;
        this.removeAll();
        if (this.selectedCard != null) {
            this.labels[this.currentSelectionIndex].setOpaque(false);
        }
        this.avc = null;
        this.slotsPanel = null;
        this.uiToolkit = null;
        this.chassis = null;
    }

    public CardPanel getSelectedCard() {
        return this.selectedCard;
    }

    public AbstractViewController getViewController() {
        return this.avc;
    }

    protected void configSpecialModule() {
        int n;
        for (int i = 0; i < this.cards.length; i += n) {
            CardPanel cardPanel = this.cards[i];
            cardPanel.setVisible(true);
            if (db.on()) {
                db.println("   slot#" + (i + 1) + " set visible true");
            }
            n = 1;
            if (!(cardPanel.getIcon() instanceof CardGraphic)) continue;
            n = ((CardGraphic)cardPanel.getIcon()).getSlotsOccupied();
            if (db.on() && n > 1) {
                db.println("   slot#" + (i + 1) + " width=" + n);
            }
            for (int j = 1; j < n; ++j) {
                this.cards[i + j].setVisible(false);
                if (!db.on()) continue;
                db.println("   slot#" + (i + j + 1) + " set visible false");
            }
        }
        this.repaint();
    }

    public void highlight() {
        new Thread((Runnable)this.highLighter, "Highlighter-" + this).start();
    }

    protected eEqState getState() {
        if (this.chassis instanceof MfgEntityModel) {
            return ((MfgEntityModel)((Object)this.chassis)).getState();
        }
        return null;
    }

    protected IServiceState getServiceSt() {
        if (this.chassis instanceof MfgEntityModel) {
            return ((MfgEntityModel)((Object)this.chassis)).getServiceSt();
        }
        return null;
    }

    protected void setShelfColor(eEqState eEqState2) {
        if (db.on()) {
            db.println("setShelfColor(" + ElementDefaults.eqStateToString(eEqState2) + ") for chassis " + this.chassis.getShelfId());
        }
        if (this.chassis.isMultishelf()) {
            int n = eEqState2.value();
            this.currShelfColor = ColorBehaviour.setStateColor(this.currShelfColor, n);
            if (n != 6) {
                IAlarmStatus iAlarmStatus = this.chassis.getShelfAlarmStore().getAlarmStatus();
                this.currShelfColor = ColorBehaviour.setAlarmColor(iAlarmStatus, this.currShelfColor, n);
            }
        }
    }

    public JPanel getInnerLabelPanel(LayoutManager layoutManager, TDMTerminology tDMTerminology) {
        return new InnerLabelPanel(layoutManager, tDMTerminology);
    }

    private String getAlarmStatusString() {
        IAlarmStatus iAlarmStatus;
        String string = "";
        try {
            iAlarmStatus = this.chassis.getShelfAlarmStore().getAlarmStatus();
        }
        catch (NullPointerException nullPointerException) {
            if (db.on()) {
                db.println("error retrieving alarm status string for tooltip");
            }
            return string;
        }
        if (iAlarmStatus != null) {
            if (iAlarmStatus.critical() > 0) {
                string = "Critical Alarm";
            } else if (iAlarmStatus.major() > 0) {
                string = "Major Alarm";
            } else if (iAlarmStatus.minor() > 0) {
                string = "Minor Alarm";
            }
        }
        if (db.on()) {
            db.println("statusString=" + string);
        }
        return string;
    }

    protected String getAlarmProfileString() {
        try {
            return "Alarm Profile: " + this.chassis.getAlarmProfileName();
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("error retrieving alarm profile");
            }
            return "";
        }
    }

    static {
        UNSELECTED_FOREGROUND_COLOR = SELECTED_BACKGROUND_COLOR = Color.black;
        DEF_COL = Color.LIGHT_GRAY;
        DEF_BORD_COL = Color.BLACK;
        db = new SDebug("ShelfLayout");
    }

    class InnerLabelPanel
    extends JPanel {
        private TDMTerminology _terms;

        public InnerLabelPanel(LayoutManager layoutManager, TDMTerminology tDMTerminology) {
            super(layoutManager);
            this._terms = tDMTerminology;
            this.setToolTipText("ZZZ");
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (!AbstractShelfLayout.this.chassis.isMultishelf()) {
                return "";
            }
            if (AbstractShelfLayout.this.chassis instanceof MfgEntityModel) {
                StringBuffer stringBuffer = new StringBuffer("");
                stringBuffer.append("Shelf " + AbstractShelfLayout.this.chassis.getShelfId() + " " + ElementDefaults.eqStateToString(AbstractShelfLayout.this.getState()) + "," + AbstractShelfLayout.this.getServiceSt().toString(this._terms) + ",");
                CardGraphic.appendString(stringBuffer, AbstractShelfLayout.this.getAlarmStatusString());
                CardGraphic.appendString(stringBuffer, AbstractShelfLayout.this.getAlarmProfileString());
                return stringBuffer.toString();
            }
            return "";
        }
    }

    protected class Highlighter
    implements Runnable {
        private final AbstractShelfLayout asl;
        private final Color borderColor = Color.BLACK;
        private final int borderWidth = 1;
        private final int DELTA = 5;
        private Color curColor = Color.YELLOW;
        private int curWidth = 3;
        private boolean cancel = false;
        private Thread thread = null;

        public Highlighter(AbstractShelfLayout abstractShelfLayout2) {
            this.asl = abstractShelfLayout2;
        }

        public void cancel() {
            if (this.thread != null) {
                this.cancel = true;
                this.thread.interrupt();
            }
        }

        public void run() {
            this.thread = Thread.currentThread();
            boolean bl = false;
            this.curColor = Color.YELLOW;
            this.curWidth = 3;
            this.cancel = false;
            while (!this.cancel) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Highlighter.this.asl.setBorder(BorderFactory.createLineBorder(Highlighter.this.curColor, Highlighter.this.curWidth));
                        Highlighter.this.asl.repaint();
                    }
                });
                this.curColor = this.shift(this.curColor, this.borderColor);
                if (bl) {
                    --this.curWidth;
                }
                bl = !bl;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.cancel && this.curWidth > 1) continue;
            }
            this.thread = null;
            if (!this.cancel) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Highlighter.this.asl.setBorder(BorderFactory.createLineBorder(Highlighter.this.borderColor, 1));
                        Highlighter.this.asl.repaint();
                    }
                });
            }
        }

        public Color shift(Color color, Color color2) {
            int n = color2.getRed();
            int n2 = color2.getGreen();
            int n3 = color2.getBlue();
            int n4 = color.getRed();
            int n5 = color.getGreen();
            int n6 = color.getBlue();
            double d = (double)(n - n4) * 0.4;
            double d2 = (double)(n2 - n5) * 0.4;
            double d3 = (double)(n3 - n6) * 0.4;
            if (Math.abs((double)n - ((double)n4 + d)) < 5.0 && Math.abs((double)n2 - ((double)n5 + d2)) < 5.0 && Math.abs((double)n3 - ((double)n6 + d3)) < 5.0) {
                return color2;
            }
            return new Color((int)Math.min(Math.max((double)n4 + d, 0.0), 255.0), (int)Math.min(Math.max((double)n5 + d2, 0.0), 255.0), (int)Math.min(Math.max((double)n6 + d3, 0.0), 255.0));
        }
    }

    private class MouseClickProcessor
    extends MouseInputAdapter {
        private MouseClickProcessor() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof CardPanel) {
                AbstractShelfLayout.this.mousePressed((CardPanel)mouseEvent.getSource());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof CardPanel) {
                Icon icon = ((CardPanel)object).getIcon();
                if ((mouseEvent.getModifiers() & 4) != 0) {
                    if (icon instanceof CardGraphic) {
                        ((CardGraphic)icon).rightMouseClicked(mouseEvent.getPoint(), (CardPanel)object);
                    }
                } else if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2 && icon instanceof CardGraphic) {
                    ((CardGraphic)icon).openCard();
                }
            }
        }
    }
}

