/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.idl.SonetTopology.sBlsrProvision;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.Busy;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IBlsrLimits;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IDccOspfArea;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IModel;
import cerent.cms.model.IOspfLanConfigModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OspfLanConfigModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.SdccTermConnectionModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.EntityComparator;
import cerent.cms.ui.RevertiveBehaviorCellEditor;
import cerent.cms.ui.shelf.SppRingPane;
import cerent.util.AnnotatedException;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.LetterOrDigitTextField;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class BlsrCreationDialog
extends UDialog
implements ActionListener,
Observer,
Runnable {
    public static final int GENERAL = 0;
    public static final int ONLY_2F = 1;
    public static final int UPGRADE = 2;
    public static final int DEFAULT_REVERSION_TIME = 300;
    private int dialogType;
    private JButton okButton;
    private JButton cancelButton;
    private IChassisModel chassis;
    private BlsrModel model;
    private IBlsrLimits blsrLimits;
    private boolean supports4Fiber;
    private String blsrTerm;
    private JRadioButton twoFiberRB;
    private JRadioButton fourFiberRB;
    private LetterOrDigitTextField ringIdTF;
    private JComboBox nodeIdCB;
    private JComboBox ringRevCB;
    private JComboBox spanRevCB;
    private JComboBox westLineCB;
    private JComboBox eastLineCB;
    private JComboBox westProtCB;
    private JComboBox eastProtCB;
    private static final SDebug db = new SDebug("BlsrCreationDialog");

    public static BlsrCreationDialog instance(SppRingPane sppRingPane, int n) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)sppRingPane));
        IModel iModel = sppRingPane.getUiModel();
        String string = sppRingPane.getBlsrTerm();
        String[] stringArray = new String[]{"Create " + string, "Upgrade " + string};
        String string2 = stringArray[n == 2 ? 1 : 0];
        BlsrCreationDialog blsrCreationDialog = new BlsrCreationDialog(frame, string2, iModel);
        blsrCreationDialog.setDialogType(n);
        blsrCreationDialog.blsrTerm = string;
        return blsrCreationDialog;
    }

    private BlsrCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.chassis = (IChassisModel)object;
        this.blsrLimits = this.chassis.getElementModels().getBlsrLimits();
        this.supports4Fiber = this.blsrLimits.getMax4FBlsr() > 0;
        this.setSize(new Dimension(400, 300));
        jPanel.add((Component)this.getCreatePanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        if (BlsrCreationDialog.db.on) {
            db.println("dispose");
        }
        ((DefaultComboBoxModel)this.eastLineCB.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.westLineCB.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.eastProtCB.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.westProtCB.getModel()).removeAllElements();
        this.chassis = null;
        if (this.model != null) {
            this.model.deleteObserver(this);
            this.model = null;
        }
        super.dispose();
    }

    public void update(Observable observable, Object object) {
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        CerentDialog.infoDialog((Component)((Object)this), (String)(this.blsrTerm + " has been updated; please restart the upgrade"), (String)(this.blsrTerm + " Updated"));
        this.dispose();
    }

    public void setDialogType(int n) {
        this.dialogType = n;
        switch (this.dialogType) {
            case 0: {
                this.twoFiberRB.setEnabled(true);
                this.fourFiberRB.setEnabled(true);
                this.enableCommonComponents(true);
                break;
            }
            case 1: {
                this.twoFiberRB.setSelected(true);
                this.fourFiberRB.setEnabled(false);
                this.enableCommonComponents(true);
                break;
            }
            case 2: {
                this.twoFiberRB.setEnabled(false);
                this.fourFiberRB.setSelected(true);
                this.enableCommonComponents(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported dialog type: " + this.dialogType);
            }
        }
        this.loadLineCBs();
    }

    private void enableCommonComponents(boolean bl) {
        this.ringIdTF.setEnabled(bl);
        this.nodeIdCB.setEnabled(bl);
        this.ringRevCB.setEnabled(bl);
        this.westLineCB.setEnabled(bl);
        this.eastLineCB.setEnabled(bl);
        this.spanRevCB.setEnabled(!bl);
        this.westProtCB.setEnabled(!bl);
        this.eastProtCB.setEnabled(!bl);
    }

    public void setBlsrModel(BlsrModel blsrModel) {
        if (this.dialogType != 2) {
            throw new UnsupportedOperationException("setBlsrModel() supported only for UPGRADE dialogs");
        }
        if (BlsrCreationDialog.db.on) {
            db.println("setBlsrModel");
        }
        if (this.model != null) {
            this.model.deleteObserver(this);
        }
        this.model = blsrModel;
        this.model.addObserver(this);
        sBlsrProvision sBlsrProvision2 = this.model.getProvision();
        this.ringIdTF.setText(sBlsrProvision2.ringName.toUpperCase());
        this.nodeIdCB.setSelectedIndex(sBlsrProvision2.nodeId);
        this.setCbReversionTime(this.ringRevCB, true);
        try {
            IEntityModel iEntityModel = this.model.getWestEntityModel();
            this.westLineCB.addItem(iEntityModel);
            this.westLineCB.setSelectedItem(iEntityModel);
            IEntityModel iEntityModel2 = this.model.getEastEntityModel();
            this.eastLineCB.addItem(iEntityModel2);
            this.eastLineCB.setSelectedItem(iEntityModel2);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (BlsrCreationDialog.db.on) {
                db.println("setBlsrModel: unable to set 2F line CBs");
            }
            this.westLineCB.setSelectedItem(null);
            this.eastLineCB.setSelectedItem(null);
        }
        this.loadLineCBs();
    }

    protected void setCbReversionTime(JComboBox jComboBox, boolean bl) {
        int n;
        int n2;
        if (BlsrCreationDialog.db.on) {
            db.println("setCbReversionTime (ringLevel=" + bl + ") called.");
        }
        try {
            String string = "NODE.protection.blsr.RingRevertive";
            String string2 = "NODE.protection.blsr.RingReversionTime";
            if (!bl) {
                string = "NODE.protection.blsr.SpanRevertive";
                string2 = "NODE.protection.blsr.SpanReversionTime";
            }
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.chassis.getNodeModel();
            IRevertiveBehavior iRevertiveBehavior = RevertiveBehaviorFactory.getIRevertiveBehavior(nodeModelDelegate.getDefaultValue("NODE.protection.1+1.Revertive"), nodeModelDelegate.getDefaultValue("NODE.protection.1+1.ReversionTime"));
            n2 = iRevertiveBehavior.getReversionMode();
            n = iRevertiveBehavior.getReversionTime();
            if (n == 0) {
                n2 = 1;
            }
        }
        catch (Exception exception) {
            n2 = 2;
            n = 300;
            db.severe("Using fallback values because exception caught: " + exception);
        }
        if (db.isFineEnabled()) {
            db.fine("setCbReversionTime (revMode=" + n2 + ", revTime=" + n + ") being called.");
        }
        this.setCbReversionTime(jComboBox, n2, n);
    }

    protected void setCbReversionTime(JComboBox jComboBox, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        if (n == 1) {
            n2 = 300;
        }
        for (int i = jComboBox.getItemCount() - 1; i >= 0; --i) {
            IRevertiveBehavior iRevertiveBehavior = (IRevertiveBehavior)jComboBox.getItemAt(i);
            int n4 = iRevertiveBehavior.getReversionTime();
            int n5 = iRevertiveBehavior.getReversionMode();
            if (n5 == 2 && n4 == 300) {
                n3 = i;
            }
            if (n != n5 || n2 != n4) continue;
            bl = true;
            jComboBox.setSelectedIndex(i);
            break;
        }
        if (!bl) {
            jComboBox.setSelectedIndex(n3);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.apply();
                this.dispose();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_BLSR_ACTION_ERROR_PARAM_1, this.blsrTerm, exception.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.fourFiberRB || object == this.twoFiberRB) {
            if (BlsrCreationDialog.db.on) {
                db.println("actionPerformed: selected " + (this.fourFiberRB.isSelected() ? this.fourFiberRB.getText() : this.twoFiberRB.getText()));
            }
            if (this.fourFiberRB.isSelected()) {
                this.spanRevCB.setEnabled(true);
                this.westProtCB.setEnabled(true);
                this.eastProtCB.setEnabled(true);
            } else {
                this.spanRevCB.setEnabled(false);
                this.westProtCB.setEnabled(false);
                this.eastProtCB.setEnabled(false);
                this.westProtCB.setSelectedItem(null);
                this.eastProtCB.setSelectedItem(null);
            }
            this.loadLineCBs();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private IIpAddr getOspfArea(ITdmPortModel iTdmPortModel) {
        IIpAddr iIpAddr = null;
        IOspfLanConfigModel iOspfLanConfigModel = this.chassis.getNodeModel().getOspfLanConfigModel();
        SdccTermConnectionModel sdccTermConnectionModel = (SdccTermConnectionModel)this.chassis.getSdccTermConnectionModel();
        IDccOspfArea[] iDccOspfAreaArray = ((OspfLanConfigModel)iOspfLanConfigModel).getDccOspfAreaIdArray();
        if (null != iTdmPortModel) {
            ITdmPortModel iTdmPortModel2 = null;
            for (int i = 0; i < iDccOspfAreaArray.length; ++i) {
                try {
                    IEntityModel iEntityModel = sdccTermConnectionModel.getPortModelByLineIndex(iDccOspfAreaArray[i].getDccIndex());
                    if (!(iEntityModel instanceof ITdmPortModel)) continue;
                    iTdmPortModel2 = (ITdmPortModel)iEntityModel;
                    if (BlsrCreationDialog.db.on) {
                        db.println("  testPortModel is: " + iTdmPortModel2);
                    }
                    if (null != iIpAddr || !iTdmPortModel.equals(iTdmPortModel2)) continue;
                    iIpAddr = iDccOspfAreaArray[i].getAreaId();
                    if (!BlsrCreationDialog.db.on) continue;
                    db.println("   GOT A MATCH");
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Exception caught in BlsrCreationDialog.getOspfArea(...)" + (Object)((Object)abstractCmsNoSuchEntityException));
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (BlsrCreationDialog.db.on) {
            db.println("getOspfArea returning: " + iIpAddr);
        }
        return iIpAddr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void apply() throws Exception {
        Object object;
        Model model;
        eElementType eElementType2;
        sBlsrProvision sBlsrProvision2 = new sBlsrProvision();
        boolean bl = ((NodeModelDelegate)this.chassis.getNodeModel()).getPlatform().is600();
        EntityModel entityModel = (EntityModel)this.westLineCB.getSelectedItem();
        EntityModel entityModel2 = (EntityModel)this.eastLineCB.getSelectedItem();
        if (entityModel == null || entityModel2 == null) {
            throw new Exception("West and east ports must be selected.");
        }
        int n = entityModel.getSlot();
        int n2 = entityModel2.getSlot();
        if (entityModel == entityModel2) {
            throw new Exception("West and east ports must be different.");
        }
        if (!bl && n == n2) {
            throw new Exception("West and east slots must be different.");
        }
        if (entityModel.getEqType() != entityModel2.getEqType()) {
            throw new Exception("West and east ports must have the same line rate.");
        }
        TDMTerminology tDMTerminology = this.chassis.getTDMTerminology();
        String string = BlsrModel.CreateBLSRRingName(tDMTerminology);
        String string2 = tDMTerminology.getGeneralTerms(8);
        IIpAddr iIpAddr = this.getOspfArea((ITdmPortModel)entityModel);
        IIpAddr iIpAddr2 = this.getOspfArea((ITdmPortModel)entityModel2);
        if (null == iIpAddr || null == iIpAddr2 || iIpAddr.compareTo((Object)iIpAddr2) != 0) {
            throw new Exception("West and east sides must have " + string2 + "terminations, and OSPF area " + "tables must be populated with the same area IDs.");
        }
        if (BlsrCreationDialog.db.on) {
            db.println("  ospfArea for west & east is: " + InetUtil.makeDottedString(iIpAddr));
        }
        sBlsrProvision2.eastPort = entityModel2.getEntityIndex();
        sBlsrProvision2.westPort = entityModel.getEntityIndex();
        if (this.fourFiberRB.isSelected()) {
            eElementType2 = eElementType.BLSR_4_WIRE;
            model = (EntityModel)this.westProtCB.getSelectedItem();
            object = (EntityModel)this.eastProtCB.getSelectedItem();
            if (model == null || object == null) {
                throw new Exception("West and east protect ports must be selected.");
            }
            int n3 = ((EntityModel)model).getSlot();
            int n4 = ((EntityModel)object).getSlot();
            if (model == object) {
                throw new Exception("West and east protect ports must be different.");
            }
            if (!bl && n3 == n4) {
                throw new Exception("West and east protect slots must be different.");
            }
            if (entityModel == model || entityModel == object || entityModel2 == model || entityModel2 == object) {
                throw new Exception("Working and protect ports must be different.");
            }
            if (!(bl || n != n3 && n != n4 && n2 != n3 && n2 != n4)) {
                throw new Exception("Working and protect slots must be different.");
            }
            if (((EntityModel)model).getEqType() != ((EntityModel)object).getEqType()) {
                throw new Exception("West and east protect ports must have the same line rate.");
            }
            if (entityModel.getEqType() != ((EntityModel)model).getEqType()) {
                throw new Exception("Working and protect ports must have the same line rate.");
            }
            if (n2 == n4 && n != n3 || n == n3 && n2 != n4) {
                throw new Exception("The two working ports and two protect ports of a four-fiber " + tDMTerminology.getRingTerms(1) + " cannot be distributed over three cards.");
            }
            sBlsrProvision2.eastProtectPort = ((EntityModel)object).getEntityIndex();
            sBlsrProvision2.westProtectPort = ((EntityModel)model).getEntityIndex();
        } else {
            eElementType2 = eElementType.BLSR_2_WIRE;
            sBlsrProvision2.eastProtectPort = 0;
            sBlsrProvision2.westProtectPort = 0;
        }
        if (this.ringIdTF.getText().trim().length() == 0) {
            throw new Exception("Ring name must not be empty.");
        }
        if (this.ringIdTF.getText().trim().equalsIgnoreCase("all")) {
            throw new Exception("'All' is a TL1 keyword and cannot be used as a ring name.");
        }
        sBlsrProvision2.ringName = this.ringIdTF.getText().toUpperCase();
        sBlsrProvision2.globalRingId = 0;
        sBlsrProvision2.ringMapAutoGen = true;
        sBlsrProvision2.nodeId = (short)this.nodeIdCB.getSelectedIndex();
        sBlsrProvision2.extendedRing = sBlsrProvision2.nodeId > 15;
        sBlsrProvision2.ringReversion = RevertiveBehaviorFactory.getRevertiveBehavior((IRevertiveBehavior)this.ringRevCB.getSelectedItem());
        sBlsrProvision2.spanReversion = RevertiveBehaviorFactory.getRevertiveBehavior((IRevertiveBehavior)this.spanRevCB.getSelectedItem());
        if (this.dialogType == 0 || this.dialogType == 1) {
            model = this.chassis.getElementModels();
            object = ((ElementModelsDelegate)model).getBlsrElements().iterator();
            while (object.hasNext()) {
                if (!((BlsrModel)object.next()).getProvision().ringName.equals(sBlsrProvision2.ringName)) continue;
                throw new Exception("Ring name '" + sBlsrProvision2.ringName + "' is already in use.");
            }
            try {
                ((ElementModelsDelegate)model).createBlsr(sBlsrProvision2, eElementType2, string);
                if (!BlsrCreationDialog.db.on) return;
                db.println("Successfully created " + this.blsrTerm + "...");
                return;
            }
            catch (Busy busy) {
                throw new AnnotatedException("Unable to create " + this.blsrTerm + ".\n" + "Check for existing circuits" + (eElementType2 == eElementType.BLSR_2_WIRE ? " on high " + this.blsrTerm + "'s of west and east ports,\n" : ", timing references, DCC or orderwire\n on west and east protect ports,\n") + "or an existing ring with the same ring name.", (Exception)((Object)busy));
            }
            catch (ProvisionError provisionError) {
                throw new AnnotatedException("Unable to create " + this.blsrTerm + ".\n" + "Check for path selectors on west and east ports,\n" + "and verify that the ports' medium types are compatible.\n", (Exception)((Object)provisionError));
            }
        }
        if (this.dialogType != 2) throw new Exception("Unsupported dialog type");
        try {
            boolean bl2 = true;
            if (this.model.hasPCAConnections()) {
                object = new StringBuffer("This " + this.blsrTerm);
                ((StringBuffer)object).append(" has PCA circuits. This is also sometimes referred\n");
                ((StringBuffer)object).append("to as \"Extra Traffic\".  Performing an upgrade now will cause these\n");
                ((StringBuffer)object).append("circuits to be disconnected until the upgrade is successful and all nodes\n");
                ((StringBuffer)object).append("in the " + this.blsrTerm + " have been upgraded.  Afterwards, these circuits will have\n");
                ((StringBuffer)object).append("4F " + this.blsrTerm + " protection. \n\n");
                ((StringBuffer)object).append("Are you sure?");
                bl2 = CerentDialog.yesNoDialog((Component)((Object)this), (String)((StringBuffer)object).toString(), (String)"Protection Channel Access (PCA) traffic exists");
            }
            if (!bl2) return;
            if (this.model.getEastMainState() != 0 || this.model.getWestMainState() != 0 || this.model.getEastProtState() != 1 || this.model.getWestProtState() != 1) {
                object = "A protection switch is active in this ring. \n";
                object = (String)object + "Clear the protection switch and try again.  \n";
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_BLSR_RING_UPGRADE, (String)object);
                return;
            } else {
                this.model.upgrade2FiberTo4Fiber(sBlsrProvision2.eastProtectPort, sBlsrProvision2.westProtectPort, sBlsrProvision2.spanReversion);
                if (!BlsrCreationDialog.db.on) return;
                db.println("Successfully upgraded BLSR...");
            }
            return;
        }
        catch (Busy busy) {
            throw new AnnotatedException("Unable to upgrade " + this.blsrTerm + ".\n" + "Check for existing circuits" + ", timing references, DCC or orderwire\n" + " on west and east protect ports.", (Exception)((Object)busy));
        }
        catch (ProvisionError provisionError) {
            throw new AnnotatedException("Unable to upgrade " + this.blsrTerm + ".\n" + "Check for path selectors on west and east ports,\n" + "and verify that the ports' medium types are compatible.\n", (Exception)((Object)provisionError));
        }
    }

    private JPanel getCreatePanel() {
        if (BlsrCreationDialog.db.on) {
            db.println("getCreatePanel");
        }
        ElAttributeMaps elAttributeMaps = ElementDefaults.getAttributeMap((IModel)this.chassis.getNodeModel());
        String string = elAttributeMaps.getAttributeForVal("blsrType", 2).toString();
        String string2 = elAttributeMaps.getAttributeForVal("blsrType", 3).toString();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel3.setLayout(new GridLayout(0, 2, 5, 5));
        this.twoFiberRB = new JRadioButton(string, true);
        this.twoFiberRB.addActionListener(this);
        this.fourFiberRB = new JRadioButton(string2, false);
        jPanel2.add(new JLabel("Ring Type: ", 4));
        if (this.supports4Fiber) {
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(0, 2));
            jPanel4.add(this.twoFiberRB);
            jPanel4.add(this.fourFiberRB);
            this.fourFiberRB.addActionListener(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.twoFiberRB);
            buttonGroup.add(this.fourFiberRB);
            jPanel2.add(jPanel4);
        } else {
            jPanel2.add(new JLabel(string));
        }
        jPanel3.add(new JLabel(" "));
        jPanel3.add(new JLabel(" "));
        this.fourFiberRB.setEnabled(this.supports4Fiber);
        jPanel2.add(new JLabel("Ring Name: ", 4));
        this.ringIdTF = new LetterOrDigitTextField(6);
        jPanel2.add(this.ringIdTF);
        jPanel3.add(new JLabel(" "));
        jPanel3.add(new JLabel(" "));
        jPanel2.add(new JLabel("Node ID: ", 4));
        this.nodeIdCB = new JComboBox<Integer>(this.getNodeIdChoices());
        jPanel2.add(this.nodeIdCB);
        jPanel3.add(new JLabel(string2 + " Only:", 4));
        jPanel3.add(new JLabel(" "));
        jPanel2.add(new JLabel("Ring Reversion: ", 4));
        this.ringRevCB = RevertiveBehaviorCellEditor.getComboBox(true);
        jPanel2.add(this.ringRevCB);
        this.setCbReversionTime(this.ringRevCB, true);
        jPanel3.add(new JLabel("Span Reversion: ", 4));
        this.spanRevCB = RevertiveBehaviorCellEditor.getComboBox(true);
        jPanel3.add(this.spanRevCB);
        this.setCbReversionTime(this.spanRevCB, false);
        this.spanRevCB.setEnabled(false);
        this.westLineCB = this.addLabeledComboBox(jPanel2, "West line: ", true);
        this.westProtCB = this.addLabeledComboBox(jPanel3, "West protect: ", false);
        this.eastLineCB = this.addLabeledComboBox(jPanel2, "East line: ", true);
        this.eastProtCB = this.addLabeledComboBox(jPanel3, "East protect: ", false);
        this.loadLineCBs();
        if (this.supports4Fiber) {
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            return jPanel;
        }
        return jPanel2;
    }

    private JComboBox addLabeledComboBox(JPanel jPanel, String string, boolean bl) {
        jPanel.add(new JLabel(string, 4));
        JComboBox jComboBox = new JComboBox();
        jPanel.add(jComboBox);
        jComboBox.setEnabled(bl);
        jComboBox.setRenderer(new EntityCellRenderer("slot "));
        return jComboBox;
    }

    private Integer[] getNodeIdChoices() {
        int n = 31;
        Integer[] integerArray = new Integer[n + 1];
        for (int i = 0; i <= n; ++i) {
            integerArray[i] = new Integer(i);
        }
        return integerArray;
    }

    private void loadLineCBs() {
        if (BlsrCreationDialog.db.on) {
            db.println("loadLineCBs");
        }
        TreeSet treeSet = new TreeSet(new EntityComparator());
        eElementType eElementType2 = this.fourFiberRB.isSelected() ? eElementType.BLSR_4_WIRE : eElementType.BLSR_2_WIRE;
        treeSet.addAll(this.chassis.getElementModels().getAvailableEntities(eElementType2));
        if (this.dialogType == 2) {
            int n;
            block8: {
                n = 0;
                try {
                    n = this.model.getWestEntityModel().getEqType();
                }
                catch (Exception exception) {
                    if (!BlsrCreationDialog.db.on) break block8;
                    db.println("loadLineCBs: unable to find west port eqType");
                }
            }
            List list = ((EntityModel)((Object)this.chassis)).getDescendantsOfEqType(n);
            treeSet.retainAll(list);
        }
        if (this.dialogType != 2) {
            this.eastLineCB.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
            this.westLineCB.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
        }
        this.eastProtCB.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
        this.westProtCB.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
        if (treeSet.size() > 1) {
            if (this.dialogType != 2) {
                this.westLineCB.setSelectedIndex(0);
                this.eastLineCB.setSelectedIndex(1);
            } else {
                this.westProtCB.setSelectedIndex(0);
                this.eastProtCB.setSelectedIndex(1);
            }
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

