/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.OpticsTopology.eDwdmRingType;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.CtxMaModuleModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOSConsoleDisabledException;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PimModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.IOSConfigDialog;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IOSTelnetFrame;
import java.awt.Component;
import org.omg.CORBA.UNKNOWN;

public class CardBehavior {
    public static final String DELETE_CARD = "Delete Card";
    public static final String RESET_CARD = "Reset Card";
    public static final String HARD_RESET_CARD = "Hard-reset Card";
    public static final String SOFT_RESET_CARD = "Soft-reset Card";
    protected static final String OPEN_CARD = "Open Card";
    public static final String CMD_OPEN_IOS = "Open IOS Connection...";
    public static final String CMD_IOS_CONFIG = "IOS Startup Config...";
    private AbstractOpticsLineModel[] opticsLineModels = null;
    private int[] supportedXcCardEqTypes;
    private static final String RESET_WARNING = "Are you sure you want to reset this card?";
    private static final String SOFT_RESET_WARNING = "Are you sure you want to soft-reset this card?";
    private static final String HARD_RESET_WARNING = "Are you sure you want to hard-reset this card?";
    private static final String FORCED_SOFT_RESET = "The soft-reset failed.\nForcing this reset might cause traffic disruption.\n\nDo you want to force a soft-reset of this card?";
    private static final String FORCED_HARD_RESET = "The hard-reset failed.\nForcing this reset might cause traffic disruption.\n\nDo you want to force a hard-reset of this card?";
    protected SDebug db;

    public CardBehavior(IPlatform iPlatform, SDebug sDebug) {
        this.supportedXcCardEqTypes = iPlatform.getSupportedXcCardEqTypes();
        this.db = sDebug;
    }

    protected boolean isCardResetAllowed(ModuleModel moduleModel, StringBuffer stringBuffer, eModuleOp eModuleOp2) {
        ProtectionGroupModel protectionGroupModel;
        if (moduleModel == null) {
            stringBuffer.append("Card unavailable.");
            return false;
        }
        boolean bl = true;
        String string = "";
        if (eModuleOp2 == eModuleOp.RESET) {
            string = RESET_WARNING;
        } else if (eModuleOp2 == eModuleOp.HARD_RESET) {
            string = HARD_RESET_WARNING;
        } else if (eModuleOp2 == eModuleOp.SOFT_RESET) {
            string = string + SOFT_RESET_WARNING;
        } else if (eModuleOp2 == eModuleOp.FORCE_HARD_RESET) {
            string = FORCED_HARD_RESET;
        } else if (eModuleOp2 == eModuleOp.FORCE_SOFT_RESET) {
            string = FORCED_SOFT_RESET;
        }
        eEqState eEqState2 = null;
        try {
            eEqState2 = moduleModel.getState();
        }
        catch (UNKNOWN uNKNOWN) {
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        if (eEqState2 == eEqState.ACTIVE && moduleModel.isInProtectionGroup() && (protectionGroupModel = moduleModel.getProtectionGroupModel()) != null) {
            ModuleModel moduleModel2 = (ModuleModel)protectionGroupModel.getProtectModuleModel();
            if (moduleModel2 == null) {
                string = "Protection group not ready: Traffic may be lost\n" + string;
            } else {
                ModuleModel[] moduleModelArray;
                if (moduleModel == moduleModel2 && (moduleModel2 = protectionGroupModel.getProtectedModuleModel()) == null) {
                    moduleModelArray = (ModuleModel[])protectionGroupModel.getMainModuleModels();
                    if (moduleModelArray.length == 1) {
                        moduleModel2 = moduleModelArray[0];
                    } else {
                        string = "Protection group not ready: Traffic may be lost\n" + string;
                    }
                }
                if (moduleModel2 != null) {
                    moduleModelArray = null;
                    try {
                        moduleModelArray = moduleModel2.getState();
                    }
                    catch (UNKNOWN uNKNOWN) {
                        this.db.println("isCardResetAllowed: caught UNKNOWN");
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        this.db.println("isCardResetAllowed: caught NotExist");
                    }
                    if (moduleModelArray == eEqState.NOT_PRESENT) {
                        string = "Protection group incomplete: Traffic may be lost\n" + string;
                    } else if (moduleModelArray != eEqState.STANDBY) {
                        if (moduleModel.getEqTypeEnum() == eEqType.XTC_CARD) {
                            bl = false;
                            string = "The other XTC is present but not in standby mode; cannot reset";
                        } else {
                            string = "Other card in protection group not ready: Traffic may be lost\n" + string;
                        }
                    }
                }
            }
        }
        stringBuffer.append(string);
        return bl;
    }

    protected Exception maybeAnnotateException(ModuleModel moduleModel, Exception throwable) {
        if (moduleModel.getEqTypeEnum() == eEqType.XTC_CARD) {
            throwable = new AnnotatedException("The standby XTC is not ready for this operation.\nPlease try again when initialization completes (up to 5 minutes)", (Exception)throwable);
        } else {
            String string = moduleModel.getEqTypeName();
            if (string != null && (string.startsWith("XC") || string.startsWith("CXC"))) {
                throwable = new AnnotatedException("This operation could not be performed because\nthe required standby " + string + " card was not detected or has an SWMTXMOD alarm raised.\n\n" + "Please verify that a standby " + string + " card is present or clear the alarm.\n", (Exception)throwable);
            } else if (string != null && string.startsWith("TCC")) {
                throwable = new AnnotatedException("This operation could not be performed because\nthe required standby " + string + " card was not detected.\n\n" + "Please verify that a standby " + string + " card is present.\n", (Exception)throwable);
            }
        }
        return throwable;
    }

    public void addCard(final Component component, final EntityModel entityModel, final String string) {
        new Thread("Card Provisioner"){

            public void run() {
                try {
                    EntityTableModel entityTableModel = entityModel.getNodeModelDelegate().getEntityTableModel();
                    int n = entityModel.getEntityIndex();
                    eEqType eEqType2 = EntityModel.name2EqType((NodeModelDelegate)entityModel.getNodeModel(), string);
                    if (entityTableModel != null && eEqType2 != null) {
                        entityTableModel.provisionModule(n, eEqType2);
                    }
                }
                catch (xInUse xInUse2) {
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_CARD_SLOT_IN_USE);
                }
                catch (xProvisionError xProvisionError2) {
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_CARD_PROV_ERROR_PARAM_1, (Object)"add");
                }
                catch (Exception exception) {
                    SDebug cfr_ignored_0 = CardBehavior.this.db;
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_CARD_ADD);
                }
            }
        }.start();
    }

    public boolean deleteCard(Component component, EntityModel entityModel) {
        StringBuffer stringBuffer;
        ModuleModel moduleModel;
        String string;
        boolean bl = false;
        int n = entityModel.getEqType();
        String string2 = "Deleting Card";
        if (this.isCrossConnectCard(n)) {
            string = "The cross-connect card cannot be deleted unless no circuits use this node.\nOK to continue?";
        } else if (this.isProtectInAutomaticProtectionGroup(entityModel, n)) {
            moduleModel = (ModuleModel)entityModel;
            IModuleModel[] iModuleModelArray = moduleModel.getProtectionGroupModel().getMainModuleModels();
            stringBuffer = new StringBuffer();
            stringBuffer.append("The card in slot ");
            stringBuffer.append(moduleModel.getSlot());
            stringBuffer.append(" automatically protects the card in\n");
            stringBuffer.append("Slot ");
            stringBuffer.append(iModuleModelArray[0].getSlot());
            stringBuffer.append(" (");
            stringBuffer.append(iModuleModelArray[0].getEqLabel());
            stringBuffer.append(")");
            for (int i = 1; i < iModuleModelArray.length; ++i) {
                stringBuffer.append(", Slot ");
                stringBuffer.append(iModuleModelArray[i].getSlot());
                stringBuffer.append(" (");
                stringBuffer.append(iModuleModelArray[i].getEqLabel());
                stringBuffer.append(")");
            }
            stringBuffer.append(". Deleting the protect card will leave any\n");
            stringBuffer.append("traffic on the working card unprotected.\n");
            stringBuffer.append("\nOK to continue?");
            string2 = "Deleting Protect Card";
            string = stringBuffer.toString();
        } else {
            switch (n) {
                case 129: 
                case 130: 
                case 196: 
                case 239: 
                case 240: {
                    moduleModel = (ModuleModel)entityModel;
                    if (this.isDwdmNeType(moduleModel)) {
                        string = "Are you sure?";
                        break;
                    }
                    if (this.isPortIS(moduleModel)) {
                        string = "Selected operation will be traffic affecting\nAre you sure?";
                        break;
                    }
                    string = "Are you sure?";
                    break;
                }
                case 150: {
                    return this.deletePpm(component, entityModel);
                }
                default: {
                    string = "Are you sure?";
                }
            }
        }
        if (CerentDialog.yesNoDialog((Component)component, (String)string, (String)string2)) {
            moduleModel = (ModuleModel)entityModel;
            try {
                moduleModel.unprovision();
                bl = true;
            }
            catch (ResourceInUse resourceInUse) {
                stringBuffer = entityModel.getNodeModel().getTDMTerminology();
                StringBuffer stringBuffer2 = new StringBuffer();
                if (moduleModel.isSupportingBLSR()) {
                    stringBuffer2.append("it is supporting the ");
                    stringBuffer2.append(stringBuffer.getRingTerms(1));
                    stringBuffer2.append(".");
                } else if (moduleModel.isInProtectionGroup()) {
                    stringBuffer2.append("it is part of a protection group.");
                } else if (moduleModel.isSupportingGCC()) {
                    stringBuffer2.append("the GCC is in use.");
                } else if (moduleModel.isSupportingSDCC()) {
                    stringBuffer2.append(this.getDccInUseStr((TDMTerminology)stringBuffer, 8));
                } else if (moduleModel.isSupportingLDCC()) {
                    stringBuffer2.append(this.getDccInUseStr((TDMTerminology)stringBuffer, 10));
                } else if (moduleModel.isTimingSource()) {
                    stringBuffer2.append("it is a timing source.");
                } else if (moduleModel.isEXT_1TimingSource()) {
                    stringBuffer2.append("it is a timing source.");
                } else if (moduleModel.isEXT_2TimingSource()) {
                    stringBuffer2.append("it is a timing source.");
                } else if (moduleModel.hasCircuits()) {
                    stringBuffer2.append("one or more circuits transit it.");
                } else if (moduleModel.hasOhCircuits()) {
                    stringBuffer2.append("one or more overhead circuits transit it.");
                } else if (moduleModel.hasPPC()) {
                    stringBuffer2.append("Cannot delete the card because it is the\norigination or termination for one or more provisionable patchcords.\nDelete the provisionable patchcords, then try again.");
                } else if (moduleModel instanceof DwdmModuleModel) {
                    DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)moduleModel;
                    if (dwdmModuleModel.hasRegenPeer()) {
                        stringBuffer2.append("it is part of a regeneration group.");
                    } else if (dwdmModuleModel.hasDWDMPatchCord()) {
                        stringBuffer2.append("one or more DWDM patchcords are still up.");
                    } else {
                        stringBuffer2.append("it is in use.\n");
                        stringBuffer2.append("This card cannot be deleted because \n");
                        stringBuffer2.append("at least one client or trunk port\n");
                        stringBuffer2.append("is not in the " + AdminState.getAdminTermDSBLD((TDMTerminology)stringBuffer) + " state.");
                    }
                } else if (moduleModel instanceof OpticsModuleModel) {
                    OpticsModuleModel opticsModuleModel = (OpticsModuleModel)moduleModel;
                    if (n == 128 || n == 127) {
                        if (opticsModuleModel.hasOSCMOC3UsedPorts()) {
                            stringBuffer2.append("the OSC is in use.");
                        } else if (opticsModuleModel.hasDWDMPatchCord()) {
                            stringBuffer2.append("one or more DWDM patchcords are still up.");
                        }
                    } else if (opticsModuleModel.hasDWDMPatchCord()) {
                        stringBuffer2.append("one or more DWDM patchcords are still up.");
                    }
                } else {
                    stringBuffer2.append("it is in use.");
                }
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_CARD_DELETE_PARAM_1, (Object)stringBuffer2.toString());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)component, (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
            }
        }
        return bl;
    }

    protected boolean isProtectInAutomaticProtectionGroup(EntityModel entityModel, int n) {
        boolean bl = false;
        switch (n) {
            case 233: 
            case 234: {
                bl = entityModel.getNodeModelDelegate().getPlatform().is310ma() && ((ModuleModel)entityModel).isProtectModule();
                break;
            }
        }
        return bl;
    }

    protected String getDccInUseStr(TDMTerminology tDMTerminology, int n) {
        return "the " + tDMTerminology.getGeneralTerms(n) + " is in use.";
    }

    public void resetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.RESET);
    }

    public void hardResetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.HARD_RESET);
    }

    public void softResetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.SOFT_RESET);
    }

    public void hardResetPim(Component component, PimModel pimModel) {
    }

    private void doResetCard(Component component, ModuleModel moduleModel, eModuleOp eModuleOp2) {
        block14: {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = this.isCardResetAllowed(moduleModel, stringBuffer, eModuleOp2);
            String string = "Resetting card";
            EID eID = EMC.EID_SOFT_RESET_CARD;
            boolean bl2 = false;
            if (eModuleOp2 == eModuleOp.SOFT_RESET) {
                string = "Soft-resetting card";
            } else if (eModuleOp2 == eModuleOp.HARD_RESET) {
                eID = EMC.EID_HARD_RESET_CARD;
                string = "Hard-resetting card";
            } else if (eModuleOp2 == eModuleOp.FORCE_SOFT_RESET) {
                eID = EMC.EID_SOFT_RESET_CARD;
                string = "Force Soft-reset";
                bl2 = true;
            } else if (eModuleOp2 == eModuleOp.FORCE_HARD_RESET) {
                eID = EMC.EID_HARD_RESET_CARD;
                string = "Force Hard-reset";
                bl2 = true;
            }
            if (bl) {
                boolean bl3;
                boolean bl4 = bl3 = bl2 ? CerentDialog.yesNoWarningDialog((Component)component, (String)stringBuffer.toString(), (String)string) : CerentDialog.yesNoDialog((Component)component, (String)stringBuffer.toString(), (String)string);
                if (bl3) {
                    try {
                        moduleModel.doCommand(eModuleOp2);
                    }
                    catch (ProvisionError provisionError) {
                        if (this.supportsForcedResets(moduleModel) && (eModuleOp2 == eModuleOp.SOFT_RESET || eModuleOp2 == eModuleOp.HARD_RESET)) {
                            this.offerForcedReset(component, moduleModel, eModuleOp2);
                            break block14;
                        }
                        this.doResetError(component, moduleModel, eID);
                    }
                    catch (Exception exception) {
                        ErrorMsg.displayError((Component)component, (EID)eID);
                    }
                }
            } else {
                ErrorMsg.displayDetailed(component, eID, stringBuffer.toString());
            }
        }
    }

    public boolean isCardChangeAllowed(ModuleModel moduleModel) {
        if (moduleModel == null) {
            return false;
        }
        int n = -1;
        try {
            n = moduleModel.getServiceSt().getType();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            this.db.println("AbstractCmsObjectNotExistException in addCustomMenuItems");
        }
        return n != 9;
    }

    public boolean isCrossConnectCard(int n) {
        boolean bl = false;
        for (int i = 0; i < this.supportedXcCardEqTypes.length; ++i) {
            if (n != this.supportedXcCardEqTypes[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean supportsGenericResetCard(IPlatform iPlatform, int n) {
        if (iPlatform.is600() || iPlatform.is310cl() || iPlatform.is310ma()) {
            return false;
        }
        return n != 187;
    }

    private boolean supportsForcedResets(ModuleModel moduleModel) {
        return moduleModel instanceof CtxMaModuleModel;
    }

    private boolean isDwdmNeType(ModuleModel moduleModel) {
        eDwdmRingType eDwdmRingType2;
        if (this.opticsLineModels == null) {
            this.LoadLineModels(moduleModel);
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.opticsLineModels[0].getNodeModel();
        try {
            eDwdmRingType2 = nodeModelDelegate.getDwdmOpticalSetupModel().getDwdmRingType();
        }
        catch (Exception exception) {
            eDwdmRingType2 = eDwdmRingType.METRO_CORE;
        }
        return eDwdmRingType2 != eDwdmRingType.NOT_DWDM;
    }

    public boolean isPortIS(ModuleModel moduleModel) {
        boolean bl = false;
        if (this.opticsLineModels == null) {
            this.LoadLineModels(moduleModel);
        }
        try {
            for (int i = 0; i < this.opticsLineModels.length; ++i) {
                int n = this.opticsLineModels[i].getAdminState();
                if (n != 0) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void LoadLineModels(ModuleModel moduleModel) {
        OpticsPortModel[] opticsPortModelArray = moduleModel.getChildren().toArray(new OpticsPortModel[0]);
        this.opticsLineModels = new AbstractOpticsLineModel[opticsPortModelArray.length];
        for (int i = 0; i < this.opticsLineModels.length; ++i) {
            this.opticsLineModels[i] = opticsPortModelArray[i].getOpticsLineModel();
        }
    }

    protected boolean deletePpm(Component component, EntityModel entityModel) {
        PpmModel ppmModel = (PpmModel)entityModel;
        boolean bl = CerentDialog.yesNoDialog((Component)component, (String)("Are you sure you want to delete PPM " + PluggableHelper.getHierarchyNumString(ppmModel.getHierarchyNums(), '-') + "?"), (String)"Delete PPM");
        if (bl) {
            IModuleModel iModuleModel = entityModel.getModuleModel();
            TDMTerminology tDMTerminology = entityModel.getNodeModel().getTDMTerminology();
            String string = "PPM cannot be deleted if:\n\t- It is in a protection group.\n\t- It has a DCC/GCC in use. \n\t- It has overhead circuits.\n\t- The PPM Actual Equipment Type is UNKNOWN.";
            if (iModuleModel instanceof DwdmModuleModel) {
                int n = iModuleModel.getEqType();
                if (((DwdmModuleModel)iModuleModel).supportTiming()) {
                    string = string + "\n\t- It is a timing source";
                }
                string = string + "\n\t- The client port is not in " + AdminState.getAdminTermDSBLD(tDMTerminology);
                if (n != 183 && n != 184 && n != 243) {
                    string = string + "\n\t- The trunk port is not in " + AdminState.getAdminTermDSBLD(tDMTerminology);
                }
            } else {
                string = string + "\n\t- It has circuits\n\t- It is a timing source";
            }
            string = string + "\n\t- It has LMP data links";
            try {
                ppmModel.unprovision();
                return true;
            }
            catch (ProvisionError provisionError) {
                EID eID = provisionError.getEID();
                if (eID != null && eID != EMC.EID_GENERIC_PROV_ERROR) {
                    ErrorMsg.displayError((Component)component, (EID)eID, (Object[])provisionError.getEIDParams());
                } else {
                    ErrorMsg.displayDetailed(component, EMC.EID_FAIL_PPM_DELETE, provisionError.getPrettyMessage() + string);
                }
            }
            catch (ResourceInUse resourceInUse) {
                ErrorMsg.displayDetailed(component, EMC.EID_PORT_IS_IN_USE, string);
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed(component, EMC.EID_FAIL_PPM_DELETE, exception.toString());
            }
        }
        return false;
    }

    public void openIOS(IModuleModel iModuleModel) {
        try {
            IOSTelnetFrame iOSTelnetFrame = IOSTelnetFrame.instance((IModuleModel)iModuleModel);
            iOSTelnetFrame.pack();
            iOSTelnetFrame.setVisible(true);
        }
        catch (IOSConsoleDisabledException iOSConsoleDisabledException) {
            ErrorMsg.displayError(null, (EID)EMC.EID_IOS_CONSOLE_DISABLED, (Object)new Integer(iModuleModel.getSlot()));
        }
    }

    public void openIOSConfig(Component component, IModuleModel iModuleModel) {
        IOSConfigDialog iOSConfigDialog = IOSConfigDialog.instance(component, iModuleModel);
        iOSConfigDialog.pack();
        iOSConfigDialog.setVisible(true);
    }

    protected void doForcedHardReset(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.FORCE_HARD_RESET);
    }

    protected void doForcedSoftReset(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.FORCE_SOFT_RESET);
    }

    private void offerForcedReset(Component component, ModuleModel moduleModel, eModuleOp eModuleOp2) {
        if (eModuleOp2 == eModuleOp.HARD_RESET) {
            this.doForcedHardReset(component, moduleModel);
        } else if (eModuleOp2 == eModuleOp.SOFT_RESET) {
            this.doForcedSoftReset(component, moduleModel);
        }
    }

    private void doResetError(Component component, ModuleModel moduleModel, EID eID) {
        Exception exception = this.maybeAnnotateException(moduleModel, null);
        if (exception instanceof AnnotatedException) {
            ErrorMsg.displayDetailed(component, eID, exception.getMessage());
        } else {
            ErrorMsg.displayError((Component)component, (EID)eID);
        }
    }
}

