/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Attribute;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.EMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class ChangeCardDialog
extends JDialog {
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JComboBox cbCards;
    private JLabel portsLabel;
    private JComboBox portsCB;
    private SlotModel slotModel;
    private ModuleModel module;
    private int slotNo;
    private static SDebug db = new SDebug("ChangeCardDialog");

    public ChangeCardDialog(Frame frame, ModuleModel moduleModel) {
        super(frame, "Change Card", true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChangeCardDialog.this.dispose();
            }
        });
        this.module = moduleModel;
        this.slotModel = (SlotModel)moduleModel.getAncestorOfEqType(21);
        this.slotNo = this.slotModel.getPositionInParent();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getDescPanel(), "North");
        container.add((Component)this.getComboPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JPanel getDescPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "You are about to change the provisioning of Slot " + this.slotNo + ".\nThe slot is currently provisioned for " + this.module.getEqTypeName() + ".\n\nTo continue, select " + "a new card below:";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel getComboPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Change to: "));
        this.cbCards = new JComboBox(this.getAvailCards());
        jPanel.add(this.cbCards);
        this.cbCards.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeCardDialog.this.showOrHidePortsCB();
            }
        });
        this.portsLabel = new JLabel("Port Rate: ");
        jPanel.add(this.portsLabel);
        this.portsCB = new JComboBox();
        jPanel.add(this.portsCB);
        this.showOrHidePortsCB();
        return jPanel;
    }

    private void showOrHidePortsCB() {
        Attribute attribute = (Attribute)this.cbCards.getSelectedItem();
        Vector vector = this.getAvailPortRates(attribute.getIntValue());
        this.portsCB.setModel(new DefaultComboBoxModel(vector));
        if (vector.isEmpty()) {
            this.portsLabel.setVisible(false);
            this.portsCB.setVisible(false);
        } else {
            this.portsLabel.setVisible(true);
            this.portsCB.setVisible(true);
            this.pack();
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Attribute attribute = (Attribute)ChangeCardDialog.this.cbCards.getSelectedItem();
                int[] nArray = new int[]{};
                if (ChangeCardDialog.this.getAvailPortRates(attribute.getIntValue()).size() > 0) {
                    object = (Attribute)ChangeCardDialog.this.portsCB.getSelectedItem();
                    nArray = new int[]{150, ((Attribute)object).getIntValue()};
                }
                if (ChangeCardDialog.this.module.getEqType() == 218 && attribute.getIntValue() == 4 && !CerentDialog.yesNoWarningDialog(null, (String)(object = EMC.WID_LOSS_OF_BANDWIDTH + "\nOk to continue?"), (String)"Auto Circuit Deletion")) {
                    ChangeCardDialog.this.dispose();
                    return;
                }
                if (db.on) {
                    db.println("The card selected is " + attribute.getKey() + " with eqType equals " + attribute.getIntValue());
                }
                ChangeCardDialog.this.okButton.setEnabled(false);
                ChangeCardDialog.this.cancelButton.setEnabled(false);
                final int n = attribute.getIntValue();
                final int[] nArray2 = nArray;
                final ChangeCardDialog changeCardDialog = ChangeCardDialog.this;
                new Thread(new Runnable(){

                    /*
                     * Exception decompiling
                     */
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }, "Card Changer").start();
            }

            static /* synthetic */ ChangeCardDialog access$800(3 var0) {
                return var0.ChangeCardDialog.this;
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeCardDialog.this.dispose();
            }
        });
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private Vector getAvailCards() {
        Vector<Attribute> vector = new Vector<Attribute>();
        List list = this.slotModel.getListOfValidChangeType(eEqType.from_int(this.module.getEqType()));
        Iterator iterator = list.iterator();
        TDMTerminology tDMTerminology = this.slotModel.getNodeModel().getTDMTerminology();
        while (iterator.hasNext()) {
            eEqType eEqType2 = (eEqType)iterator.next();
            vector.add(new Attribute(EntityModel.eqType2Name(tDMTerminology, eEqType2), eEqType2.value()));
        }
        return vector;
    }

    private Vector getAvailPortRates(int n) {
        Vector<Attribute> vector = new Vector<Attribute>();
        TDMTerminology tDMTerminology = this.slotModel.getNodeModel().getTDMTerminology();
        List list = this.slotModel.getListOfValidPortTypes(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            String string = EqTypeHelper.getPortRateString((TDMTerminology)tDMTerminology, (int)n2);
            vector.add(new Attribute(string, n2));
        }
        return vector;
    }

    public void dispose() {
        this.setLocation(this.getLocation().x + 1, this.getLocation().y + 1);
        super.dispose();
    }
}

