/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.DatabaseHeader;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.plaf.LabelUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DbInfoDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "Restore Database";
    private static final String RESTORE = "Restore";
    private static final String CANCEL = "Cancel";
    private static final int INITIAL_ROW_HEIGHT = 16;
    private NodeModelDelegate nodeModel;
    private Object[] columnNames = new Object[]{"Database Property", "Value"};
    private JButton restoreButton;
    private JButton cancelButton;
    private DatabaseHeader dbHr;
    private JTable table;
    private boolean restore = false;
    private static final SDebug db = new SDebug("DbInfoDialog");

    public DbInfoDialog(JComponent jComponent, NodeModelDelegate nodeModelDelegate, DatabaseHeader databaseHeader) {
        super(JOptionPane.getFrameForComponent(jComponent), TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DbInfoDialog.this.dispose();
            }
        });
        this.nodeModel = nodeModelDelegate;
        this.dbHr = databaseHeader;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.getContentPane().add((Component)this.getUpperPanel(), "Center");
        this.pack();
        this.setSize();
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(jComponent));
        this.setVisible(true);
    }

    private JTable createTable() {
        JTable jTable = new JTable(new DbInfoTableModel(this.getDbHeaderInfo(), this.columnNames));
        TableColumn tableColumn = jTable.getColumn(this.columnNames[1]);
        tableColumn.setCellRenderer(new ValueCellRenderer());
        TableColumn tableColumn2 = jTable.getColumn(this.columnNames[0]);
        TableColumn tableColumn3 = jTable.getColumn(this.columnNames[1]);
        tableColumn2.setPreferredWidth(120);
        tableColumn3.setMinWidth(200);
        int n = jTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.numLines((String)jTable.getValueAt(i, 1));
            if (n2 > 4) {
                n2 = 4;
            }
            jTable.setRowHeight(i, n2 * 16);
        }
        return jTable;
    }

    protected void setSize() {
        this.setSize(450, 280);
    }

    protected JLabel getCompatibilityInfo() {
        JLabel jLabel = new JLabel("");
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        String string = this.nodeModel.getNeType();
        String string2 = this.nodeModel.getSwVersion().substring(0, 5);
        String string3 = this.nodeModel.getName();
        boolean bl = this.nodeModel.supportsSecureMode();
        if (db.on()) {
            db.println("NE version=" + string2);
        }
        if (!this.dbHr.isNeTypeCompatible(string)) {
            jLabel.setText("Unable to restore this database:\nThe node type (" + string + ") " + "does not match the database.\n");
            jLabel.setIcon(CerentDialog.FATAL_ICON);
            this.restoreButton.setEnabled(false);
            return jLabel;
        }
        if (!this.dbHr.isSwVersionCompatible(string2)) {
            jLabel.setText("Unable to restore this database:\nThe database is not compatible with the node software (" + string2 + ").\n");
            jLabel.setIcon(CerentDialog.FATAL_ICON);
            this.restoreButton.setEnabled(false);
            return jLabel;
        }
        String string4 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        if (!this.dbHr.isSameNodeName(string3)) {
            bl2 = true;
            string4 = string4 + "The node name (" + string3 + ") " + "does not match the database.\n";
            jLabel.setIcon(CerentDialog.WARNING_ICON);
        }
        if (this.dbHr.isSwVersionCompatible(string2) && !this.dbHr.isSameSwVersion(string2)) {
            bl3 = true;
            string4 = string4 + "The node software version (" + string2 + ") " + "does not match the database.\n";
            jLabel.setIcon(CerentDialog.WARNING_ICON);
        }
        if (this.dbHr.isSecureDB() && !bl) {
            jLabel.setText("Unable to restore this database: \nSecure Mode requires TCC2P cards.");
            jLabel.setIcon(CerentDialog.FATAL_ICON);
            jLabel.setVerticalTextPosition(1);
            this.restoreButton.setEnabled(false);
            return jLabel;
        }
        if (bl2 || bl3) {
            string4 = "Warning:\n" + string4 + "Restoring the database may cause a traffic loss.\n";
        }
        jLabel.setText(string4);
        return jLabel;
    }

    private void addProperty(String string, String string2, Vector vector, Vector vector2) {
        String string3 = this.dbHr.getProperty(string);
        if (string3 != null) {
            vector.add(string2);
            vector2.add(string3);
        }
    }

    protected Object[][] getDbHeaderInfo() {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.addProperty("Info.NeDesc", "Node Description", vector, vector2);
        this.addProperty("Ne.Node-Name", "Node Name", vector, vector2);
        this.addProperty("Info.NeType", "Node Type", vector, vector2);
        this.addProperty("Ne.Software-Version", "Software Version", vector, vector2);
        this.addProperty("Ne.Date", "Backup Date", vector, vector2);
        this.addProperty("Ne.Time", "Backup Time", vector, vector2);
        this.addProperty("Ne.Secure-Mode", "Secure Mode", vector, vector2);
        Object[][] objectArray = new Object[vector.size()][2];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i][0] = vector.get(i);
            objectArray[i][1] = vector2.get(i);
        }
        return objectArray;
    }

    private JPanel getUpperPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JScrollPane(this.createTable()), "Center");
        jPanel.add((Component)this.getCompatibilityInfo(), "South");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        this.restoreButton = this.makeActionButton(RESTORE);
        jPanel.add(this.restoreButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private int numLines(String string) {
        int n = 1;
        int n2 = 0;
        while ((n2 = string.indexOf(10, n2)) != -1) {
            ++n;
            ++n2;
        }
        return n;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public boolean isOk() {
        return this.restore;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.restoreButton) {
            this.restore = true;
        }
        this.dispose();
    }

    class DbInfoTableModel
    extends AbstractTableModel {
        private Object[] columnNames;
        private Object[][] rowData;

        public DbInfoTableModel(Object[][] objectArray, Object[] objectArray2) {
            this.rowData = objectArray;
            this.columnNames = objectArray2;
        }

        public String getColumnName(int n) {
            return this.columnNames[n].toString();
        }

        public int getRowCount() {
            return this.rowData.length;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.rowData[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.rowData[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }

    class ValueCellRenderer
    implements TableCellRenderer {
        private JTextArea textArea;
        private JLabel label = new JLabel();

        public ValueCellRenderer() {
            this.label.setOpaque(true);
            this.label.setForeground(Color.black);
            this.label.setFont(this.label.getFont().deriveFont(0));
            this.textArea = new JTextArea();
            this.textArea.setOpaque(true);
            this.textArea.setForeground(Color.black);
            this.textArea.setFont(this.textArea.getFont().deriveFont(0));
            this.textArea.setLineWrap(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            Color color;
            Color color2 = bl ? jTable.getSelectionForeground() : jTable.getForeground();
            Color color3 = color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
            if (DbInfoDialog.this.numLines((String)object) == 1) {
                jComponent = this.label;
                this.label.setText((String)object);
            } else {
                jComponent = new JScrollPane(this.textArea);
                this.textArea.setText((String)object);
            }
            ((Component)jComponent).setForeground(color2);
            ((Component)jComponent).setBackground(color);
            return jComponent;
        }
    }
}

