/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.CardPanel;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DeletedCard
extends CardGraphic
implements ActionListener {
    public DeletedCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        this(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "DeletedCard:" + entityModel.getSlot()));
    }

    public DeletedCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.setDisabled(true);
    }

    protected void initSlotsOccupied() {
        int n = this.getEqType();
        switch (n) {
            case 91: 
            case 131: 
            case 132: 
            case 191: 
            case 240: 
            case 242: {
                int n2 = 2;
                this.setSlotsOccupied(n2);
            }
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("In update().");
        }
        super.update(observable, object);
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("In dispose().");
        }
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.db.on()) {
            this.db.println("In actionPerformed().");
        }
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            this.addCard(string);
        }
    }

    private void addCard(String string) {
        IEntityModel iEntityModel;
        if (this.db.on()) {
            this.db.println("In addCard().");
        }
        if ((iEntityModel = this.getModel()) instanceof ModuleModel) {
            iEntityModel = iEntityModel.getParent();
        }
        this.cardBehavior.addCard(this, (EntityModel)iEntityModel, string);
    }

    protected String getStateString() {
        return "Deleted";
    }

    public void rightMouseClicked(Point point, CardPanel cardPanel) {
        JPopupMenu jPopupMenu = new JPopupMenu("Set Card Type");
        ModuleModel moduleModel = (ModuleModel)this.getModel();
        IEntityModel iEntityModel = moduleModel.getParent();
        if (this.db.on()) {
            this.db.println("In rightMouseClicked(). entityM = " + iEntityModel + " module = " + moduleModel);
        }
        try {
            this.createPopup(jPopupMenu, this.getMapOfAllCards((SlotModel)iEntityModel));
        }
        catch (Exception exception) {
            CerentDialog.errorDialog((Component)this, (Exception)exception, (String)"Error Building Menu");
        }
        jPopupMenu.show(cardPanel, point.x, point.y);
    }
}

