/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.EtherMedia.eTransponderMode;
import cerent.cms.model.HdGeModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class G1000CardView
extends CardView {
    private static final SDebug db = new SDebug("G1000CardView");
    protected Observer transponderChangeObserver;
    protected Collection transponderPairings;
    protected Map portIndexToPort;
    protected HdGeModuleModel.TransponderChangeNotifier tco = null;

    public G1000CardView(ModuleModel moduleModel) {
        super(moduleModel);
        if (moduleModel instanceof HdGeModuleModel) {
            this.transponderChangeObserver = new TransponderChangeObserver();
            this.tco = ((HdGeModuleModel)moduleModel).getTransponderChangeNotifier();
            this.tco.addObserver(this.transponderChangeObserver);
            this.transponderPairings = this.tco.getCurrentTransponderPairingsWithoutDuplicates();
        }
    }

    protected void setAlarmColor(int n) {
        this.setBackground(severityColor[n]);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.is327) {
            this.drawTransponderCurves327((Graphics2D)graphics);
        } else {
            this.drawTransponderCurves454((Graphics2D)graphics);
        }
    }

    public void dispose() {
        if (this.transponderChangeObserver != null && this.tco != null) {
            this.tco.deleteObserver(this.transponderChangeObserver);
            this.transponderPairings = null;
            this.transponderChangeObserver = null;
        }
        super.dispose();
    }

    protected void addPorts(boolean bl) {
        if (this.portIndexToPort == null) {
            this.portIndexToPort = new HashMap();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = null;
        insets = !this.is327 ? new Insets(2, 32, 2, 22) : new Insets(32, 2, 24, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        Integer n = null;
        for (int i = 0; i < this.numPorts; ++i) {
            if (!(this.portModels.get(i) instanceof PortModel)) continue;
            PortModel portModel = (PortModel)this.portModels.get(i);
            this.ports[i] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial(), new Dimension(30, 30));
            if (bl) {
                gridBagConstraints.gridy = i + 1;
            } else {
                gridBagConstraints.gridx = i + 1;
            }
            n = new Integer(portModel.getIndex());
            this.portIndexToPort.put(n, this.ports[i]);
            this.add((Component)this.ports[i], gridBagConstraints);
        }
        this.repaint();
    }

    public static void drawArrow(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, Color color) {
        int[] nArray;
        int[] nArray2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Color color2 = graphics2D.getColor();
        graphics2D.setColor(color);
        if (bl) {
            n8 = (int)rectangle.getCenterX();
            n7 = (int)rectangle.getCenterY();
            if (!bl3) {
                n7 -= (int)rectangle.getHeight() / 6;
                n6 = Math.min((n8 += (int)rectangle.getWidth() / 2 + 2) + (int)rectangle.getWidth() / 2, (int)graphics2D.getClipBounds().getWidth() - 3);
                if (n6 < n8) {
                    n6 = n8 + (int)rectangle.getWidth() / 2;
                }
                n5 = n7;
                n4 = n6 - (int)rectangle.getWidth() / 6;
                n3 = n5 - (int)rectangle.getHeight() / 8;
                n2 = n4;
                n = n5 + (int)rectangle.getHeight() / 8;
                graphics2D.drawLine(n8, n7, n4, n5);
                nArray2 = new int[]{n6, n4, n2, n6};
                nArray = new int[]{n5, n3, n, n5};
                graphics2D.drawPolyline(nArray2, nArray, 4);
            } else {
                n6 = n8 -= (int)rectangle.getWidth() / 6;
                n5 = (n7 -= (int)rectangle.getHeight() / 2 + 2) - (int)rectangle.getHeight() / 2;
                n4 = n6 - (int)(rectangle.getWidth() / 9.0);
                n3 = n7 - (int)(rectangle.getHeight() / 5.0);
                n2 = n6 + (int)(rectangle.getWidth() / 9.0);
                n = n3;
                graphics2D.drawLine(n8, n3, n6, n5);
                nArray2 = new int[]{n4, n8, n2, n4};
                nArray = new int[]{n3, n7, n, n3};
                graphics2D.drawPolyline(nArray2, nArray, 4);
            }
        }
        if (bl2) {
            n8 = (int)rectangle.getCenterX();
            n7 = (int)rectangle.getCenterY();
            if (!bl3) {
                n7 += (int)rectangle.getHeight() / 6;
                n6 = Math.min((n8 += (int)rectangle.getWidth() / 2 + 2) + (int)rectangle.getWidth() / 2, (int)graphics2D.getClipBounds().getWidth() - 3);
                if (n6 < n8) {
                    n6 = n8 + (int)rectangle.getWidth() / 2;
                }
                n5 = n7;
                n4 = n8 + (int)rectangle.getWidth() / 6;
                n3 = n7 - (int)rectangle.getHeight() / 8;
                n2 = n4;
                n = n7 + (int)rectangle.getHeight() / 8;
                graphics2D.drawLine(n4, n7, n6, n5);
                nArray2 = new int[]{n8, n4, n2, n8};
                nArray = new int[]{n7, n3, n, n7};
                graphics2D.drawPolyline(nArray2, nArray, 4);
            } else {
                n6 = n8 += (int)rectangle.getWidth() / 6;
                n5 = (n7 -= (int)rectangle.getHeight() / 2 + 2) - (int)rectangle.getHeight() / 2;
                n4 = n6 - (int)rectangle.getWidth() / 9;
                n3 = n5 + (int)rectangle.getHeight() / 5;
                n2 = n6 + (int)rectangle.getWidth() / 9;
                n = n3;
                graphics2D.drawLine(n8, n7, n6, n3);
                nArray2 = new int[]{n6, n4, n2, n6};
                nArray = new int[]{n5, n3, n, n5};
                graphics2D.drawPolyline(nArray2, nArray, 4);
            }
        }
        graphics2D.setColor(color2);
    }

    private void drawTransponderCurves454(Graphics2D graphics2D) {
        if (this.transponderPairings != null && graphics2D != null) {
            Iterator iterator = this.transponderPairings.iterator();
            HdGeModuleModel.sGmacLineAdminInfo_4_01_Key sGmacLineAdminInfo_4_01_Key2 = null;
            double[] dArray = new double[]{2.25, 2.25, 1.0, 1.0};
            boolean bl = false;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            while (iterator.hasNext()) {
                CubicCurve2D.Double double_;
                double d;
                double d2;
                double d3;
                double d4;
                sGmacLineAdminInfo_4_01_Key2 = (HdGeModuleModel.sGmacLineAdminInfo_4_01_Key)iterator.next();
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_NONE) continue;
                int n = Math.min(sGmacLineAdminInfo_4_01_Key2.getIndex(), sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                int n2 = Math.max(sGmacLineAdminInfo_4_01_Key2.getIndex(), sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                Rectangle rectangle = ((GenericPortGraphic)this.portIndexToPort.get(new Integer(n))).getBounds();
                Rectangle rectangle2 = ((GenericPortGraphic)this.portIndexToPort.get(new Integer(n2))).getBounds();
                short s = (short)Math.abs(sGmacLineAdminInfo_4_01_Key2.getIndex() - sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode != eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL) {
                    d4 = rectangle.getCenterX();
                    d3 = rectangle.getCenterY();
                    d2 = d4 -= rectangle.getWidth() / 2.0;
                    d = rectangle2.getCenterY();
                    double_ = new CubicCurve2D.Double(d4, d3, d4 - rectangle.getWidth() / dArray[s], (d - d3) / 100.0 + d3, d2 - rectangle2.getWidth() / dArray[s], d - (d - d3) / 100.0, d2, d);
                    if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_TWO_PORT_BIDIRECTIONAL) {
                        G1000CardView.drawArrow(graphics2D, rectangle, true, true, false, Color.black);
                        G1000CardView.drawArrow(graphics2D, rectangle2, true, true, false, Color.black);
                    } else if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_TWO_PORT_RX_ONLY) {
                        if (sGmacLineAdminInfo_4_01_Key2.ifIndex == n) {
                            G1000CardView.drawArrow(graphics2D, rectangle, false, true, false, Color.black);
                            G1000CardView.drawArrow(graphics2D, rectangle2, true, false, false, Color.black);
                        } else {
                            G1000CardView.drawArrow(graphics2D, rectangle, true, false, false, Color.black);
                            G1000CardView.drawArrow(graphics2D, rectangle2, false, true, false, Color.black);
                        }
                    } else if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_TWO_PORT_TX_ONLY) {
                        if (sGmacLineAdminInfo_4_01_Key2.ifIndex == n) {
                            G1000CardView.drawArrow(graphics2D, rectangle, true, false, false, Color.black);
                            G1000CardView.drawArrow(graphics2D, rectangle2, false, true, false, Color.black);
                        } else {
                            G1000CardView.drawArrow(graphics2D, rectangle, false, true, false, Color.black);
                            G1000CardView.drawArrow(graphics2D, rectangle2, true, false, false, Color.black);
                        }
                    }
                    graphics2D.draw(double_);
                    continue;
                }
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode != eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL) continue;
                d4 = rectangle.getCenterX();
                d3 = rectangle.getCenterY() - rectangle.getHeight() / 2.0 + 3.0;
                d2 = d4 -= rectangle.getWidth() / 2.0 - 1.0;
                d = rectangle2.getCenterY() + rectangle2.getHeight() / 2.0 - 2.0;
                double_ = new CubicCurve2D.Double(d4, d3, d4 - rectangle.getWidth() / dArray[s], (d - d3) / 100.0 + d3, d2 - rectangle2.getWidth() / dArray[s], d - (d - d3) / 100.0, d2, d);
                G1000CardView.drawArrow(graphics2D, rectangle, true, true, false, Color.black);
                graphics2D.draw(double_);
            }
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private void drawTransponderCurves327(Graphics2D graphics2D) {
        if (this.transponderPairings != null && graphics2D != null) {
            Iterator iterator = this.transponderPairings.iterator();
            HdGeModuleModel.sGmacLineAdminInfo_4_01_Key sGmacLineAdminInfo_4_01_Key2 = null;
            boolean bl = false;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            while (iterator.hasNext()) {
                CubicCurve2D.Double double_;
                double d;
                double d2;
                double d3;
                double d4;
                sGmacLineAdminInfo_4_01_Key2 = (HdGeModuleModel.sGmacLineAdminInfo_4_01_Key)iterator.next();
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_NONE) continue;
                int n = Math.min(sGmacLineAdminInfo_4_01_Key2.getIndex(), sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                int n2 = Math.max(sGmacLineAdminInfo_4_01_Key2.getIndex(), sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                Rectangle rectangle = ((GenericPortGraphic)this.portIndexToPort.get(new Integer(n))).getBounds();
                Rectangle rectangle2 = ((GenericPortGraphic)this.portIndexToPort.get(new Integer(n2))).getBounds();
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode != eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL) {
                    d4 = rectangle.getCenterX();
                    d3 = rectangle.getCenterY();
                    d2 = rectangle2.getCenterX();
                    d = d3 += rectangle.getHeight() / 2.0;
                    double_ = new CubicCurve2D.Double(d4, d3, d4 + rectangle.getWidth() / 12.0, d3 + rectangle.getHeight(), d2 - rectangle2.getWidth() / 12.0, d + rectangle2.getHeight(), d2, d);
                    if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_TWO_PORT_BIDIRECTIONAL) {
                        G1000CardView.drawArrow(graphics2D, rectangle, true, true, true, Color.black);
                        G1000CardView.drawArrow(graphics2D, rectangle2, true, true, true, Color.black);
                    } else if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_TWO_PORT_RX_ONLY) {
                        G1000CardView.drawArrow(graphics2D, rectangle, false, true, true, Color.black);
                        G1000CardView.drawArrow(graphics2D, rectangle2, true, false, true, Color.black);
                    } else if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_TWO_PORT_TX_ONLY) {
                        G1000CardView.drawArrow(graphics2D, rectangle, true, false, true, Color.black);
                        G1000CardView.drawArrow(graphics2D, rectangle2, false, true, true, Color.black);
                    }
                    graphics2D.draw(double_);
                    continue;
                }
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode != eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL) continue;
                d4 = rectangle.getCenterX();
                d3 = rectangle.getCenterY();
                d2 = rectangle2.getCenterX();
                d = d3 += rectangle.getHeight() / 2.0;
                double_ = new CubicCurve2D.Double(d4 -= rectangle.getWidth() / 2.0 - 2.0, d3, d4 + rectangle.getWidth() / 12.0, d3 + rectangle.getHeight(), (d2 += rectangle2.getWidth() / 2.0 - 2.0) - rectangle2.getWidth() / 12.0, d + rectangle2.getHeight(), d2, d);
                G1000CardView.drawArrow(graphics2D, rectangle, true, true, true, Color.black);
                graphics2D.draw(double_);
            }
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private class TransponderChangeObserver
    implements Observer {
        private TransponderChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            G1000CardView.this.transponderPairings = null;
            G1000CardView.this.repaint();
            G1000CardView.this.transponderPairings = (Collection)object;
            G1000CardView.this.repaint();
        }
    }
}

