/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Common.sIpSubnet;
import cerent.cms.idl.OSI.sGreTunnel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OsiModel;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.NsapPanel;
import cerent.util.InetUtil;
import cerent.util.IpSubnet;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GreTunnelAttributesPane
extends JPanel
implements DocumentListener,
PropertyChangeListener,
IOsiConstants,
ActionListener {
    protected INodeModel nodeModel;
    protected sGreTunnel selectedGRE;
    protected sGreTunnel newGRE;
    private JTextField destTF;
    private SpinPropertyEditor maskEdit;
    private JLabel maskLB;
    private NsapPanel nsapP;
    private SpinPropertyEditor metricS;
    protected OsiModel osiModel;
    private JRadioButton cscoRB;
    private JRadioButton greRB;
    private static final SDebug db = new SDebug("GreTunnelAttributesPane");

    protected GreTunnelAttributesPane(String string, INodeModel iNodeModel) {
        if (db.on()) {
            db.println("<init>: start");
        }
        this.setLayout(new BorderLayout());
        this.setNodeModel(iNodeModel);
        this.add((Component)this.createAttributesPanel(), "Center");
        this.newGRE = new sGreTunnel(new sIpSubnet(IpAddrFactory.getIpAddr(InetUtil.makeIpAddr("0.0.0.0")), IpAddrFactory.getIpAddr(InetUtil.makeIpAddr("0.0.0.0"))), new String("0").getBytes(), 1);
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    protected String formatInternalSubnets() {
        String string;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.nodeModel;
            IpSubnet[] ipSubnetArray = nodeModelDelegate.getPlatform().getInternalSubnets(nodeModelDelegate);
            if (ipSubnetArray != null && ipSubnetArray.length > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(ipSubnetArray[0]);
                for (int i = 1; i < ipSubnetArray.length; ++i) {
                    stringBuffer.append(", ");
                    stringBuffer.append(ipSubnetArray[i]);
                }
                stringBuffer.append(")");
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    protected void setOsiModel(OsiModel osiModel) {
        this.osiModel = osiModel;
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void destroy() {
        this.nodeModel = null;
    }

    protected sGreTunnel getSelectedEntry() {
        return this.selectedGRE;
    }

    protected void setSelectedEntry(sGreTunnel sGreTunnel2) {
        block2: {
            this.selectedGRE = sGreTunnel2;
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected sGreTunnel getNewEntry() {
        return this.newGRE;
    }

    private String helpPutDefaultGreTunnel(String string, String string2) {
        try {
            string2 = this.nodeModel.getDefaultValue(string);
        }
        catch (NoSuchDefault noSuchDefault) {
            db.severe("helpPutDefaultGreTunnel(): no such default " + string);
        }
        catch (Exception exception) {
            db.severe("helpPutDefaultGreTunnel():unexpected exception from getDefaultValue():" + exception);
        }
        return string2;
    }

    protected void putDefaultGreTunnel() {
        if (this.maskEdit.isEnabled()) {
            this.maskEdit.setValue(new Integer(this.helpPutDefaultGreTunnel("NODE.osi.greTunnel.SubnetMask", "24")));
            this.updateMaskLabel();
        }
        if (this.metricS.isEnabled()) {
            this.metricS.setValue(new Integer(this.helpPutDefaultGreTunnel("NODE.osi.greTunnel.OspfCost", "110")));
        }
    }

    protected void customInit() {
        this.destTF = new JTextField(12);
        this.maskLB = new JLabel();
        this.maskEdit = new SpinPropertyEditor("", 1, 8, 32);
        this.nsapP = new NsapPanel(2);
        this.nsapP.setNsel2CSCO(false);
        this.metricS = new SpinPropertyEditor("", Integer.parseInt("1"), 110, 65535);
        this.metricS.setEditorSize(5);
        this.putDefaultGreTunnel();
    }

    private void helpAddTunnelType(GridBagPanel gridBagPanel, JRadioButton jRadioButton, JRadioButton jRadioButton2, String string, int n) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.addActionListener(this);
        jRadioButton.setSelected(true);
        jRadioButton2.addActionListener(this);
        int n2 = 0;
        gridBagPanel.add(new JLabel(string), n2++, n, 1, 1);
        gridBagPanel.add(jRadioButton, n2++, n, 1, 1);
        gridBagPanel.add(jRadioButton2, n2, n, 1, 1);
    }

    private void helpAddIP(GridBagPanel gridBagPanel, JTextField jTextField, String string, int n) {
        int n2 = 0;
        gridBagPanel.add(new JLabel(string), n2++, n, 1, 1);
        gridBagPanel.add(jTextField, n2, n, 1, 1);
        jTextField.getDocument().addDocumentListener(this);
    }

    private void helpAddMask(GridBagPanel gridBagPanel, SpinPropertyEditor spinPropertyEditor, JLabel jLabel, String string, int n) {
        int n2 = 0;
        gridBagPanel.add(new JLabel(string), n2++, n, 1, 1);
        gridBagPanel.add(spinPropertyEditor, n2++, n, 1, 1);
        spinPropertyEditor.addPropertyChangeListener(this);
        gridBagPanel.add(jLabel, n2, n, 1, 1);
    }

    private void helpAddOspfCost(GridBagPanel gridBagPanel, SpinPropertyEditor spinPropertyEditor, String string, int n) {
        int n2 = 0;
        gridBagPanel.add(new JLabel(string), n2++, n, 1, 1);
        gridBagPanel.add(spinPropertyEditor, n2, n, 1, 1);
    }

    private void helpAddNsapPanel(GridBagPanel gridBagPanel, NsapPanel nsapPanel, String string, int n) {
        int n2 = 0;
        gridBagPanel.add(new JLabel(string), n2++, n, 1, 1);
        gridBagPanel.add(nsapPanel, n2, n, 4, 1);
    }

    protected JPanel createAttributesPanel() {
        this.customInit();
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchorWest();
        gridBagPanel.inset(4, 1);
        int n = 0;
        this.greRB = new JRadioButton("GRE");
        this.cscoRB = new JRadioButton("Cisco");
        this.helpAddTunnelType(gridBagPanel, this.greRB, this.cscoRB, "Tunnel Type:", n++);
        this.helpAddIP(gridBagPanel, this.destTF, "IP Address:", n++);
        this.helpAddMask(gridBagPanel, this.maskEdit, this.maskLB, "Subnet Mask:", n++);
        this.helpAddOspfCost(gridBagPanel, this.metricS, "OSPF Cost:", n++);
        this.helpAddNsapPanel(gridBagPanel, this.nsapP, "NSAP:", n);
        return gridBagPanel;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
    }

    protected void validateFields() throws Exception {
        sIpAddr sIpAddr2;
        sIpAddr sIpAddr3;
        try {
            sIpAddr3 = IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(this.destTF.getText()));
        }
        catch (Exception exception) {
            throw new Exception("Improper destination IP address");
        }
        try {
            sIpAddr2 = IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(this.maskLB.getText()));
        }
        catch (Exception exception) {
            throw new Exception("Improper mask entry");
        }
        byte[] byArray = OsiHelper.getNsapBytes((String)this.nsapP.getText());
        int n = Integer.parseInt((String)this.metricS.getValue());
        if (n < 110 || n > 65535) {
            throw new Exception("Invalid OSPF metric, must be between 110 and 65535");
        }
        boolean bl = false;
        byte[] byArray2 = this.osiModel.getValidGreNsels();
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[byArray.length - 1] != byArray2[i]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray2.length; ++i) {
                stringBuffer.append(Integer.toHexString(byArray2[i] & 0xFF) + (i + 2 < byArray2.length ? ", " : (i + 1 < byArray2.length ? " and " : "")));
            }
            throw new Exception("Invalid GRE NSEL byte, " + Integer.toHexString(byArray[byArray.length - 1] & 0xFF) + ", valid values are " + stringBuffer.toString() + ".");
        }
        this.newGRE.ip.address = sIpAddr3;
        this.newGRE.ip.mask = sIpAddr2;
        this.newGRE.nsap = byArray;
        this.newGRE.ospfMetric = n;
    }

    public void refreshFromModel() throws Exception {
        String string = OsiHelper.getNsapString((byte[])this.selectedGRE.nsap);
        this.cscoRB.setSelected(string.endsWith("CC"));
        this.nsapP.setNsel2CSCO(this.cscoRB.isSelected());
        String string2 = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(this.selectedGRE.ip.address));
        String string3 = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(this.selectedGRE.ip.mask));
        this.nsapP.setText(string.substring(0, string.length() - 2));
        this.metricS.setValue(new Integer(this.selectedGRE.ospfMetric));
        this.maskLB.setText(string3);
        this.maskEdit.setValue(new Integer(InetUtil.maskToPrefix(IpAddrFactory.getIIpAddr(this.selectedGRE.ip.mask))));
        this.destTF.setText(string2);
    }

    protected void updateMaskLabel() {
        try {
            int n = Integer.parseInt((String)this.maskEdit.getValue());
            int n2 = InetUtil.makeNetMask(n);
            this.maskLB.setText(InetUtil.makeDottedString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            db.severe("NumberFormatException: " + numberFormatException);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButton) {
            this.nsapP.setNsel2CSCO(this.cscoRB.isSelected());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this.maskEdit) {
            this.updateMaskLabel();
        }
    }

    protected void documentModified(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.destTF.getDocument()) {
            String string = this.destTF.getText();
            if (string.equals("0.0.0.0")) {
                this.maskLB.setText("0.0.0.0");
                this.maskLB.setEnabled(false);
                this.maskEdit.setEnabled(false);
            } else {
                this.maskEdit.setEnabled(true);
                this.maskLB.setEnabled(true);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }
}

