/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sGreTunnel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.GreTunnelAttributesPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;

public class GreTunnelEditPane
extends GreTunnelAttributesPane {
    private static SDebug db = new SDebug("GreTunnelEditPane");

    public GreTunnelEditPane(String string) {
        super(string, null);
    }

    private boolean isSameTunnel(sGreTunnel sGreTunnel2, sGreTunnel sGreTunnel3) {
        String string;
        String string2 = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sGreTunnel2.ip.address));
        if (!string2.equals(string = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sGreTunnel3.ip.address)))) {
            return false;
        }
        string2 = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sGreTunnel2.ip.mask));
        if (!string2.equals(string = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sGreTunnel3.ip.mask)))) {
            return false;
        }
        if (sGreTunnel2.ospfMetric != sGreTunnel3.ospfMetric) {
            return false;
        }
        string2 = OsiHelper.getNsapString((byte[])sGreTunnel2.nsap);
        string = OsiHelper.getNsapString((byte[])sGreTunnel3.nsap);
        return string2.equals(string);
    }

    public void applyChangesToModel() throws Exception {
        sGreTunnel sGreTunnel2;
        sGreTunnel sGreTunnel3;
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        if (this.isSameTunnel(sGreTunnel3 = this.getSelectedEntry(), sGreTunnel2 = this.getNewEntry())) {
            return;
        }
        if (this.osiModel.hasGreTunnel(sGreTunnel2.ip.address, sGreTunnel2.ip.mask, sGreTunnel2.nsap, sGreTunnel2.ospfMetric)) {
            throw new Exception("Changing to an existing IP Over CLNS Tunnel not allowed.");
        }
        boolean bl = false;
        try {
            this.osiModel.removeGreTunnel(sGreTunnel3.ip.address, sGreTunnel3.ip.mask, sGreTunnel3.nsap);
            bl = true;
            this.osiModel.createGreTunnel(sGreTunnel2.ip.address, sGreTunnel2.ip.mask, sGreTunnel2.nsap, sGreTunnel2.ospfMetric);
        }
        catch (Exception exception) {
            if (bl) {
                if (db.on()) {
                    db.println("new GRE tunnel creation failed, restore old one");
                }
                this.osiModel.createGreTunnel(sGreTunnel3.ip.address, sGreTunnel3.ip.mask, sGreTunnel3.nsap, sGreTunnel3.ospfMetric);
            }
            throw exception;
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }
}

