/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class HexTextField
extends JTextField {
    private static String hexString = "0123456789abcdefABCDEF";
    private String extraChars = null;

    public HexTextField(int n) {
        this(n, null);
    }

    protected HexTextField(int n, String string) {
        super(n);
        this.extraChars = string;
    }

    protected Document createDefaultModel() {
        return new HexDocument(this.getColumns());
    }

    class HexDocument
    extends PlainDocument {
        int documentMaxLength;

        public HexDocument(int n) {
            this.documentMaxLength = n;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            if (string != null) {
                if (string.length() + this.getLength() > this.documentMaxLength && HexTextField.this.extraChars == null) {
                    bl = false;
                } else {
                    for (int i = 0; bl && i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (-1 != hexString.indexOf(c) || -1 != HexTextField.this.extraChars.indexOf(c)) continue;
                        bl = false;
                    }
                }
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

