/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OpticsTopology.eApcAdminStatus;
import cerent.cms.idl.OpticsTopology.eApcProgressStatus;
import cerent.cms.idl.OpticsTopology.sAPCLastModification;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.ui.shelf.MaintApcTableColumnRenderer;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class MaintApcDataSource
extends AbstractRowDataSource
implements Observer {
    private DwdmOpticalSetupModel dwdmOpticalSetupModel;
    private sAPCLastModification[] ApcList = new sAPCLastModification[0];
    private static final SDebug db = new SDebug("MaintApcDataSource");

    public MaintApcDataSource(DwdmOpticalSetupModel dwdmOpticalSetupModel) {
        this.dwdmOpticalSetupModel = dwdmOpticalSetupModel;
        this.dwdmOpticalSetupModel.addObserver(this);
    }

    public void runApc() throws Busy, CannotPerform {
        this.dwdmOpticalSetupModel.runApc();
    }

    public void setApcAdminState(eApcAdminStatus eApcAdminStatus2) {
        this.dwdmOpticalSetupModel.setApcAdminState(eApcAdminStatus2);
    }

    public int getApcAdminState() {
        eApcAdminStatus eApcAdminStatus2 = this.dwdmOpticalSetupModel.getApcAdminState();
        if (eApcAdminStatus2 == eApcAdminStatus.APC_FORCE_DISABLE) {
            return 0;
        }
        return 1;
    }

    public int getApcProgressState() {
        eApcProgressStatus eApcProgressStatus2 = this.dwdmOpticalSetupModel.getApcProgressState();
        if (eApcProgressStatus2 == eApcProgressStatus.APC_PROGRESS_ENDED) {
            return 0;
        }
        if (eApcProgressStatus2 == eApcProgressStatus.APC_PROGRESS_ABORTED) {
            return 1;
        }
        return 2;
    }

    public int getApcState() {
        int n = this.dwdmOpticalSetupModel.getApcState();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getApcList() {
        try {
            sAPCLastModification[] sAPCLastModificationArray = this.dwdmOpticalSetupModel.getAllApcLastModif();
            ArrayList<sAPCLastModification> arrayList = new ArrayList<sAPCLastModification>();
            for (int i = 0; i < sAPCLastModificationArray.length; ++i) {
                sAPCLastModification sAPCLastModification2 = sAPCLastModificationArray[i];
                arrayList.add(sAPCLastModification2);
            }
            this.ApcList = arrayList.toArray(new sAPCLastModification[0]);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.finest("Exception in getApcList() " + (Object)((Object)abstractCmsIOException));
            }
        }
        finally {
            this.fireDataSourceChanged();
        }
    }

    private boolean validSlotPort(OptLinkModel optLinkModel) {
        int n;
        block2: {
            n = -1;
            try {
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.dwdmOpticalSetupModel.getNodeModel();
                n = MaintApcTableColumnRenderer.getSlotInt(nodeModelDelegate, optLinkModel.getIndex());
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("validSlotPort encountered exception for " + optLinkModel);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return n != -1;
    }

    public void dispose() {
        if (db.on()) {
            db.println("MainApcDataSource Dispose");
        }
    }

    public void update(Observable observable, Object object) {
        this.fireDataSourceChanged();
    }

    public Object getObjectAtRow(int n) {
        return this.ApcList[n];
    }

    public int getRowCount() {
        return this.ApcList.length;
    }

    public Collection getAllObjects() {
        return Arrays.asList(this.ApcList);
    }

    public NodeModelDelegate getNodeModel() {
        return (NodeModelDelegate)this.dwdmOpticalSetupModel.getNodeModel();
    }
}

