/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OpticsTopology.eApcAdminStatus;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.MaintApcDataSource;
import cerent.cms.ui.shelf.MaintApcTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class MaintApcPane
extends AbstractPane
implements Observer,
ActionListener {
    private static final String RUN_APC = "Run APC";
    private static final String REFRESH = "Refresh";
    private static final String DISABLE_APC = "Disable APC";
    private JButton runapcButton = new JButton("Run APC");
    private JButton disableapcButton = new JButton("Disable APC");
    private JButton refreshapcButton = new JButton("Refresh");
    private MaintApcTableModel dataModel;
    private MaintApcDataSource dataSource;
    private boolean initialized = true;
    private int ApcAdminState;
    private int ApcProgressState;
    private int[] sortCols = new int[]{0};
    private boolean[] sortDir = new boolean[]{false};
    private TabbedView parent;
    private NodeModelDelegate nodeModel;
    private DwdmOpticalSetupModel opticalSetupModel;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "MaintApcPane");

    public MaintApcPane(String string, TabbedView tabbedView, DwdmOpticalSetupModel dwdmOpticalSetupModel) {
        super(string, tabbedView);
        this.parent = tabbedView;
        this.opticalSetupModel = dwdmOpticalSetupModel;
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        this.opticalSetupModel.addObserver(this);
        this.setLayout(new BorderLayout());
        this.nodeModel = (NodeModelDelegate)this.opticalSetupModel.getNodeModel();
        this.dataSource = new MaintApcDataSource(this.opticalSetupModel);
        this.dataModel = new MaintApcTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        ((MaintApcTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.add(this.makeControlPanel(), "South");
        this.add((Component)new UScrollPane((Component)this.table), "Center");
    }

    private JPanel makeControlPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.MaintApcPane);
        this.runapcButton.addActionListener(this);
        this.enableComponent(this.runapcButton, this.nodeModel);
        this.disableapcButton.addActionListener(this);
        this.enableComponent(this.disableapcButton, this.nodeModel);
        this.refreshapcButton.addActionListener(this);
        this.enableComponent(this.refreshapcButton, this.nodeModel);
        cSHelpButtonPane.addLeft(this.runapcButton);
        cSHelpButtonPane.addLeft(this.disableapcButton);
        cSHelpButtonPane.addLeft(this.refreshapcButton);
        return cSHelpButtonPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.runapcButton) {
            try {
                this.dataSource.runApc();
            }
            catch (Busy busy) {
                CerentDialog.infoDialog((Component)((Object)this), (String)"APC busy.", (String)RUN_APC);
            }
            catch (CannotPerform cannotPerform) {}
        } else if (object == this.refreshapcButton) {
            try {
                this.refresh();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ANS);
            }
        } else if (object == this.disableapcButton) {
            if (this.disableapcButton.getText().equals("Enable APC")) {
                this.runapcButton.setEnabled(!this.runapcButton.isEnabled());
                this.dataSource.setApcAdminState(eApcAdminStatus.APC_FREE_TO_RUN);
                this.disableapcButton.setText(DISABLE_APC);
            } else {
                this.runapcButton.setEnabled(!this.runapcButton.isEnabled());
                this.dataSource.setApcAdminState(eApcAdminStatus.APC_FORCE_DISABLE);
                this.disableapcButton.setText("Enable APC");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            if (this.initialized) {
                this.dataSource.getApcList();
                this.readApcStatus();
                this.initialized = false;
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.initialized = true;
    }

    public void refresh() {
        this.dataSource.getApcList();
        this.readApcStatus();
    }

    public void readApcStatus() {
        int n = this.dataSource.getApcState();
        this.ApcAdminState = this.dataSource.getApcAdminState();
        if (n != 1) {
            this.runapcButton.setEnabled(false);
        } else if (this.isUserAuthorized()) {
            this.runapcButton.setEnabled(true);
        }
        if (this.ApcAdminState == 0) {
            this.disableapcButton.setText("Enable APC");
        } else {
            this.disableapcButton.setText(DISABLE_APC);
        }
        if (n == 0) {
            this.disableapcButton.setEnabled(false);
        } else if (this.isUserAuthorized()) {
            this.disableapcButton.setEnabled(true);
        }
    }

    public void readApcProgressStatus() {
        this.ApcProgressState = this.dataSource.getApcProgressState();
        if (this.ApcProgressState == 0) {
            CerentDialog.infoDialog((Component)((Object)this), (String)"APC successfully ended.", (String)RUN_APC);
        } else if (this.ApcProgressState == 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_APC_ABORTED);
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
        this.opticalSetupModel.deleteObserver(this);
    }

    public void update(Observable observable, Object object) {
        if (((Integer)object).equals(new Integer(10))) {
            this.readApcProgressStatus();
        }
        this.refresh();
    }
}

