/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OpticsTopology.sAPCLastModification;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class MaintApcTableColumnRenderer
extends AbstractColumnRenderer {
    public static final int POSITION_INDEX = 0;
    public static final int LASTMOD_INDEX = 1;
    public static final int PARAM_INDEX = 2;
    public static final int LASTCHECK_INDEX = 3;
    private static final int COLUMN_NO = 4;
    private static AttributeMaps attributeMap = new AttributeMaps();
    private JLabel label;
    private NodeModelDelegate nm;
    private EventUtilities eventutilities;
    private boolean isMultiShelf = false;
    private Color[] status_color = new Color[]{Color.black};
    private static final String OPEN = "(";
    private static final String CLOSE = ")";
    private static final String COMMA = ",";
    private static final String SPACE = " ";

    public MaintApcTableColumnRenderer(NodeModelDelegate nodeModelDelegate, String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.nm = nodeModelDelegate;
        this.isMultiShelf = nodeModelDelegate.isMultishelf();
        this.eventutilities = EventUtilities.getInstance(nodeModelDelegate);
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        sAPCLastModification sAPCLastModification2;
        String string = "";
        long l = 0L;
        String string2 = "";
        JLabel jLabel = this.label;
        try {
            sAPCLastModification2 = (sAPCLastModification)object;
        }
        catch (Exception exception) {
            this.label.setText("");
            return jLabel;
        }
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = this.getPosition(sAPCLastModification2.index);
                break;
            }
            case 2: {
                string = this.getApcParameter(sAPCLastModification2);
                break;
            }
            case 1: {
                if (sAPCLastModification2.lastModification > 0) {
                    l = this.eventutilities.convertSecondsToMilliSeconds(sAPCLastModification2.lastModification);
                    string = this.eventutilities.formatAbsoluteNeTimeasCtcTimeZoneString(l);
                    break;
                }
                string = new String("N/A");
                break;
            }
            case 3: {
                if (sAPCLastModification2.lastChecked > 0) {
                    l = this.eventutilities.convertSecondsToMilliSeconds(sAPCLastModification2.lastChecked);
                    string = this.eventutilities.formatAbsoluteNeTimeasCtcTimeZoneString(l);
                    break;
                }
                string = new String("N/A");
            }
        }
        this.label.setToolTipText("");
        this.label.setText(string);
        ((Component)jLabel).setBackground(color);
        return jLabel;
    }

    private String getPosition(int n) {
        StringBuffer stringBuffer = new StringBuffer(50);
        PortModel portModel = null;
        try {
            portModel = (PortModel)this.nm.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return "N/A";
        }
        if (this.nm.isMultishelf()) {
            stringBuffer.append("Shelf ");
            stringBuffer.append(portModel.getShelfId());
            stringBuffer.append(COMMA);
        }
        stringBuffer.append("Slot ");
        stringBuffer.append(portModel.getSlot());
        stringBuffer.append(SPACE);
        stringBuffer.append(OPEN);
        stringBuffer.append(portModel.getModuleModel().getEqTypeName());
        stringBuffer.append(CLOSE);
        stringBuffer.append(COMMA);
        stringBuffer.append("Port ");
        if (portModel instanceof OpticsPortModel) {
            try {
                stringBuffer.append(portModel.getPort());
                stringBuffer.append(SPACE);
                stringBuffer.append(OPEN);
                stringBuffer.append(((OpticsPortModel)portModel).getOpticsLineModel().getPortTypeString());
                stringBuffer.append(CLOSE);
            }
            catch (Exception exception) {
                stringBuffer.append("N/A");
            }
        } else if (portModel instanceof PortModel) {
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            stringBuffer.append(entityCellRenderer.getPortString(portModel, false));
        }
        return stringBuffer.toString();
    }

    private String getApcParameter(sAPCLastModification sAPCLastModification2) {
        String string = "Unknown";
        switch (sAPCLastModification2.attr.value()) {
            case 1: {
                string = "Working Mode";
                break;
            }
            case 2: {
                string = "Per Channel Power";
                break;
            }
            case 3: {
                string = "Gain";
                break;
            }
            case 4: {
                string = "Tilt";
                break;
            }
            case 5: {
                string = "LOS-P Thresold";
                break;
            }
            case 6: {
                string = "LOS-O Thresold";
                break;
            }
            case 7: {
                string = "Voa Target Attenuation";
                break;
            }
            case 8: {
                string = "Voa Target Power";
                break;
            }
            case 9: {
                string = "Total Power";
                break;
            }
        }
        return string;
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return -1;
        }
        if (entityModel != null && entityModel instanceof PortModel) {
            return entityModel.getSlot();
        }
        return -1;
    }

    static ColumnRenderer[] createTableRenderers(NodeModelDelegate nodeModelDelegate) {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[4];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = MaintApcTableColumnRenderer.createColumnRenderer(nodeModelDelegate, i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(NodeModelDelegate nodeModelDelegate, int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Position";
                n3 = 400;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Parameter";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Last Modification";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Last Check";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new MaintApcTableColumnRenderer(nodeModelDelegate, string, n3, bl, n2);
    }
}

