/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.DuplicateMAT;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.MaxMAT;
import cerent.cms.model.TarpModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.MatAttributePane;
import cerent.cms.ui.shelf.OsiTarpAdjacencyPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MatAddDialog
extends UDialog
implements ActionListener {
    private static String TITLE = "Add Manual Adjacency Table Entry";
    private JButton okButton;
    private JButton cancelButton;
    MatAttributePane attributePane;
    static Object model;

    public static MatAddDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        model = pane.getUiModel();
        return new MatAddDialog(frame, model, ((OsiTarpAdjacencyPane)pane).tarpModel);
    }

    private MatAddDialog(Frame frame, Object object, TarpModel tarpModel) {
        super(frame, TITLE, true, object);
        this.attributePane.setTarp(tarpModel);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.createAttributesPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.attributePane = null;
        super.dispose();
        model = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.attributePane.onValidate();
                this.apply();
                this.dispose();
            }
            catch (MaxMAT maxMAT) {
                SDebug.printStackTrace((Throwable)maxMAT);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAT_MAX);
            }
            catch (DuplicateMAT duplicateMAT) {
                SDebug.printStackTrace((Throwable)duplicateMAT);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DUPLICATE_MAT);
            }
            catch (InternalCommError internalCommError) {
                SDebug.printStackTrace((Throwable)internalCommError);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSI_OPERATION_FAILURE);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_CANT_ADD_DEL_MAT_ENTRY_PARAM_2, "add", exception.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.attributePane.applyChangesToModel();
    }

    private JPanel createAttributesPanel() {
        this.attributePane = new MatAttributePane(this);
        return this.attributePane;
    }

    public JPanel getAttributesPanel() {
        return this.attributePane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

