/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class OCNPortGraphic
extends OpticalPortGraphic {
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfLayout.db, "OCNPortGraphic");

    public OCNPortGraphic(CardGraphic cardGraphic, int n, int n2, PortModel portModel) {
        super(cardGraphic, n, n2, portModel, 0);
    }

    public OCNPortGraphic(CardGraphic cardGraphic, int n, int n2, int n3, int n4, PortModel portModel) {
        super(cardGraphic, n, n2, n3, n4, portModel, 1);
    }

    protected TdmLineModel getTdmLineModel() {
        InterfaceModel interfaceModel = this.getIfModel();
        if (!(interfaceModel instanceof TdmLineModel)) {
            return null;
        }
        return (TdmLineModel)this.getIfModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLoopback(int n) {
        boolean bl = false;
        Throwable throwable = null;
        TdmLineModel tdmLineModel = this.getTdmLineModel();
        if (tdmLineModel != null) {
            try {
                bl = this.getTdmLineModel().getLoopback().value() == n;
            }
            catch (NoSuchInterface noSuchInterface) {
                throwable = noSuchInterface;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                throwable = wrongInterfaceType;
            }
            finally {
                if (throwable != null) {
                    db.severe("Caught exception in isLoopback");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)throwable);
                    }
                }
            }
        }
        return bl;
    }

    public boolean isFacilityLoopback() {
        return this.isLoopback(2);
    }

    public boolean isTerminalLoopback() {
        return this.isLoopback(1);
    }

    protected boolean isCurrentlyActive() {
        try {
            return this.getTdmLineModel().isCurrentlyActive();
        }
        catch (Exception exception) {
            db.severe("Caught exception in isCurrentlyActive");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    protected String getPhysicalMediumDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        TdmLineModel tdmLineModel = this.getTdmLineModel();
        String string = tdmLineModel != null ? this.myPortRenderer.getMediumTypeStr(tdmLineModel) : this.myPortRenderer.getMediumTypeStr(this.getPortModel());
        if (!string.equals("")) {
            stringBuffer.append(" (");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

