/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JLabel;

public class OscCardView
extends CardView {
    private static final SDebug db;
    private JLabel[] labels;
    private static final String[] RX_LABELS;
    private static final String[] LABELS_EXT;
    private static final String[] ETSI_LABELS_EXT;
    private static final String[] OSC_CSM_LABELS;
    private static JLabel[] rxLabels;
    private static JLabel[] extLabels;
    private static JLabel[] etsi_extLabels;
    private static JLabel[] OSCCSMLabels;

    public OscCardView(ModuleModel moduleModel) {
        super(moduleModel);
        this.portModels = moduleModel.getChildren();
        this.numPorts = this.portModels.size();
        NodeModelDelegate nodeModelDelegate = moduleModel.getNodeModelDelegate();
        this.addLabels(nodeModelDelegate.getPlatform().is455());
        this.refreshAlarmInfo();
    }

    protected void addLabels(boolean bl) {
        int n;
        int n2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(2, 3, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        for (n2 = 0; n2 < this.numPorts; ++n2) {
            this.labels = rxLabels;
        }
        gridBagConstraints.gridy = 0;
        this.add((Component)this.labels[0], gridBagConstraints);
        n2 = 2;
        for (n = 1; n < this.numPorts; n += 2) {
            gridBagConstraints.gridy = n + n2 - 1;
            ++n2;
            this.add((Component)this.labels[n], gridBagConstraints);
        }
        n2 = 1;
        for (n = 2; n < this.numPorts; n += 2) {
            gridBagConstraints.gridy = n2 * 3 - 1;
            gridBagConstraints.gridx = 2;
            ++n2;
            this.add((Component)this.labels[n], gridBagConstraints);
        }
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        Insets insets2 = new Insets(2, 3, 2, 2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = insets;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        if (bl) {
            this.add((Component)etsi_extLabels[1], gridBagConstraints2);
        } else {
            this.add((Component)extLabels[1], gridBagConstraints2);
        }
        if (this.model.getEqType() == 128) {
            this.labels = OSCCSMLabels;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            for (int i = 0; i < this.labels.length; ++i) {
                this.add((Component)this.labels[i], gridBagConstraints2);
                ++gridBagConstraints2.gridy;
            }
        }
    }

    protected void addPorts(boolean bl) {
        Serializable serializable;
        int n;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        Insets insets = new Insets(2, 3, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = insets;
        for (n = 0; n < this.numPorts; ++n) {
            this.labels = rxLabels;
        }
        if (this.portModels.get(0) instanceof PortModel) {
            PortModel portModel = (PortModel)this.portModels.get(0);
            this.ports[0] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
            if (bl) {
                gridBagConstraints2.gridy = 1;
                gridBagConstraints.gridy = 0;
            } else {
                gridBagConstraints2.gridx = 1;
            }
            this.add((Component)this.ports[0], gridBagConstraints2);
        }
        n = 2;
        for (int i = 1; i < this.numPorts; i += 2) {
            if (!(this.portModels.get(i) instanceof PortModel)) continue;
            serializable = (PortModel)this.portModels.get(i);
            this.ports[i] = new GenericPortGraphic(this, (EntityModel)serializable, ((EntityModel)serializable).getPort(), ((PortModel)serializable).isSpecial());
            if (this.pci.positionPortsVertically()) {
                gridBagConstraints2.gridy = i + n;
                gridBagConstraints.gridy = i + n - 1;
                ++n;
            } else {
                gridBagConstraints2.gridx = i + 1;
            }
            this.add((Component)this.ports[i], gridBagConstraints2);
        }
        this.numPorts = this.ports.length;
        this.repaint();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        serializable = new GridBagConstraints();
        Insets insets2 = new Insets(2, 3, 2, 2);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.insets = insets2;
        ((GridBagConstraints)serializable).gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).insets = insets2;
        n = 1;
        for (int i = 2; i < this.numPorts; i += 2) {
            if (!(this.portModels.get(i) instanceof PortModel)) continue;
            PortModel portModel = (PortModel)this.portModels.get(i);
            this.ports[i] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
            ((GridBagConstraints)serializable).gridy = n * 3;
            ((GridBagConstraints)serializable).gridx = 2;
            gridBagConstraints3.gridy = n * 3 - 1;
            gridBagConstraints3.gridx = 2;
            ++n;
            this.add((Component)this.ports[i], serializable);
        }
        this.numPorts = this.ports.length;
        this.repaint();
    }

    static {
        int n;
        db = new SDebug("OscCardView");
        RX_LABELS = new String[]{"", "RX", "TX", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        LABELS_EXT = new String[]{"", "OC3:", ""};
        ETSI_LABELS_EXT = new String[]{"", "STM-1:", ""};
        OSC_CSM_LABELS = new String[]{"", "COM:", "", "", "LINE:", "", "", "OSC:"};
        rxLabels = new JLabel[RX_LABELS.length];
        extLabels = new JLabel[LABELS_EXT.length];
        etsi_extLabels = new JLabel[ETSI_LABELS_EXT.length];
        OSCCSMLabels = new JLabel[OSC_CSM_LABELS.length];
        for (n = 0; n < RX_LABELS.length; ++n) {
            OscCardView.rxLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(RX_LABELS[n], 2));
        }
        for (n = 0; n < OSC_CSM_LABELS.length; ++n) {
            OscCardView.OSCCSMLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OSC_CSM_LABELS[n], 2));
        }
        for (n = 0; n < LABELS_EXT.length; ++n) {
            OscCardView.extLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(LABELS_EXT[n], 2));
        }
        for (n = 0; n < ETSI_LABELS_EXT.length; ++n) {
            OscCardView.etsi_extLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(ETSI_LABELS_EXT[n], 2));
        }
    }
}

