/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sRouter;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OsiModel;
import cerent.cms.model.RouterModel;
import cerent.cms.model.SubnetModel;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.OsiAreaAddressDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OsiRouterEditPane
extends JPanel
implements ActionListener,
ListSelectionListener {
    private sRouter selectedRouter;
    private RouterModel routerModel;
    private SubnetModel subnetModel;
    private OsiModel osiModel;
    private final int MAX_MAA = 3;
    private String ASTERISK = "*";
    private String SPACE = " ";
    private String NSAP_IMPACT = "* impacts local NSAP";
    private JLabel sysIdL = null;
    private JCheckBox enabledCB = null;
    private JList areaAddrList = null;
    private DefaultListModel areaAddrListModel = null;
    private JButton maaAddB = null;
    private JButton maaEditB = null;
    private JButton maaDeleteB = null;
    private JLabel nsapImpactLB;
    private static final SDebug db = new SDebug("OsiRouterEditPane");

    public OsiRouterEditPane(NodeModelDelegate nodeModelDelegate) {
        this.routerModel = nodeModelDelegate.getRouterModel();
        this.subnetModel = nodeModelDelegate.getSubnetModel();
        this.osiModel = nodeModelDelegate.getOsiModel();
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder("Router " + (this.selectedRouter != null ? Integer.toString(this.selectedRouter.routerNumber) : "1")));
        Box box = Box.createVerticalBox();
        box.add(this.createSysIdRow());
        box.add(Box.createVerticalGlue());
        box.add(this.createEnabledRow());
        box.add(Box.createVerticalGlue());
        box.add(this.createAreaAddrRow());
        this.add(box);
    }

    protected void setSelectedRouter(sRouter sRouter2) {
        this.selectedRouter = sRouter2;
        if (this.selectedRouter != null && this.selectedRouter.routerNumber == 1) {
            this.nsapImpactLB.setText(this.NSAP_IMPACT);
        }
        this.setBorder(BorderFactory.createTitledBorder("Router " + (this.selectedRouter != null ? Integer.toString(this.selectedRouter.routerNumber) : "1")));
        this.refreshFromModel();
    }

    private void showAddDialog() {
        OsiAreaAddressDialog osiAreaAddressDialog = new OsiAreaAddressDialog(this, true);
        osiAreaAddressDialog.show();
        osiAreaAddressDialog.dispose();
    }

    private void showEditDialog() {
        OsiAreaAddressDialog osiAreaAddressDialog = new OsiAreaAddressDialog(this, false);
        String string = (String)this.areaAddrList.getSelectedValue();
        int n = this.areaAddrList.getSelectedIndex();
        string = string.substring(this.ASTERISK.length());
        osiAreaAddressDialog.setAreaAddress(string);
        osiAreaAddressDialog.show();
        osiAreaAddressDialog.dispose();
    }

    protected void doAdd(String string) throws Exception {
        if (this.areaAddrListModel.getSize() < 3) {
            OsiHelper.getAreaAddressBytes((String)string);
            this.areaAddrListModel.addElement(this.SPACE + OsiHelper.formatAreaAddressString((String)string));
        }
        this.helpEnable();
    }

    protected void doEdit(String string) throws Exception {
        db.fine("actionPerformed(): editing " + this.areaAddrList.getSelectedIndex());
        int n = this.areaAddrList.getSelectedIndex();
        String string2 = (String)this.areaAddrList.getSelectedValue();
        string2 = string2.substring(this.ASTERISK.length());
        if (string.replaceAll("\\.", "").equals(string2.replaceAll("\\.", ""))) {
            return;
        }
        for (int i = 1; i < this.areaAddrListModel.getSize(); ++i) {
            String string3 = (String)this.areaAddrListModel.get(i);
            if (!(string3 = this.normalize(string3.substring(this.ASTERISK.length()))).equals(this.normalize(string))) continue;
            throw new Exception("Changing to an existing MAA not allowed.");
        }
        this.areaAddrListModel.remove(n);
        String string4 = n == 0 && this.selectedRouter.routerNumber == 1 ? this.ASTERISK : this.SPACE;
        this.areaAddrListModel.insertElementAt(string4 + OsiHelper.formatAreaAddressString((String)string), n);
        this.areaAddrList.clearSelection();
        this.helpEnable();
    }

    private void removeSelectedMAA() {
        if (this.areaAddrList.getSelectedIndex() > -1) {
            db.fine("actionPerformed(): removing " + this.areaAddrList.getSelectedIndex());
            this.areaAddrListModel.remove(this.areaAddrList.getSelectedIndex());
            this.areaAddrList.clearSelection();
        }
        this.helpEnable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.enabledCB)) {
            this.helpEnable();
        } else if (object.equals(this.maaAddB)) {
            this.showAddDialog();
        } else if (object.equals(this.maaEditB)) {
            this.showEditDialog();
        } else if (object.equals(this.maaDeleteB)) {
            this.removeSelectedMAA();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        db.fine("valueChanged()");
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.helpEnable();
        }
    }

    public void onValidate() throws Exception {
        if (this.selectedRouter.routerNumber == 1 && !this.enabledCB.isSelected()) {
            for (int i = 2; i <= this.routerModel.getOsiRouters().length; ++i) {
                if (!this.routerModel.getEnabled(i)) continue;
                throw new Exception("Router #1 may not be disabled until router #" + i + " is disabled.");
            }
        } else if (this.selectedRouter.routerNumber > 1 && this.enabledCB.isSelected() && !this.routerModel.getEnabled(1)) {
            throw new Exception("Router #" + this.selectedRouter.routerNumber + " may not be enabled until router #1 is enabled.");
        }
    }

    public void destroy() {
        this.selectedRouter = null;
        this.routerModel = null;
        this.subnetModel = null;
        this.osiModel = null;
        this.enabledCB = null;
        this.areaAddrList = null;
        this.areaAddrListModel = null;
        this.maaAddB = null;
        this.maaEditB = null;
        this.maaDeleteB = null;
    }

    String normalize(String string) {
        return OsiHelper.formatAreaAddressString((String)string.trim());
    }

    public void applyChangesToModel() throws Exception {
        try {
            String string;
            int n;
            int n2;
            int n3;
            Object object;
            if (this.osiModel.getRoutingMode() == 1 && this.enabledCB.isSelected()) {
                object = this.routerModel.getRouterList();
                boolean bl = true;
                block2: for (n3 = 0; n3 < ((sRouter[])object).length; ++n3) {
                    if (object[n3].routerNumber == this.selectedRouter.routerNumber || !object[n3].enabled) continue;
                    int n4 = object[n3].addrList.length;
                    n2 = this.areaAddrListModel.getSize();
                    if (n4 == n2) {
                        for (n = 0; n < n4; ++n) {
                            string = OsiHelper.getAreaAddressString((byte[])((sRouter)object[n3]).addrList[n]);
                            String string2 = (String)this.areaAddrListModel.get(n);
                            if (string.equals(string2 = this.normalize(string2.substring(this.ASTERISK.length())))) continue;
                            bl = false;
                            continue block2;
                        }
                        continue;
                    }
                    bl = false;
                }
                if (!bl) {
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_OSI_AREA_NOT_SAME);
                    return;
                }
            }
            if (this.selectedRouter.enabled != this.enabledCB.isSelected()) {
                if (!this.enabledCB.isSelected() && this.subnetModel.getSubnetList(this.selectedRouter.routerNumber).length > 0 && !CerentDialog.yesNoDialog((Component)this, (String)(ErrorMsg.getString((EID)EMC.WID_OSI_ROUTER_HAS_SUBNET) + "Are you sure you want to disable the selected router?"), (String)"Disable Router")) {
                    return;
                }
                this.routerModel.setEnabled(this.selectedRouter.routerNumber, this.enabledCB.isSelected());
            }
            object = new ArrayList();
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            for (n3 = 1; n3 < this.selectedRouter.addrList.length; ++n3) {
                String string3 = OsiHelper.getAreaAddressString((byte[])this.selectedRouter.addrList[n3]);
                n2 = 0;
                for (n = 1; n < this.areaAddrListModel.getSize(); ++n) {
                    string = (String)this.areaAddrListModel.get(n);
                    if (!string3.equals(string = this.normalize(string.substring(this.ASTERISK.length())))) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) continue;
                ((ArrayList)object).add(this.selectedRouter.addrList[n3]);
            }
            for (n3 = 1; n3 < this.areaAddrListModel.getSize(); ++n3) {
                String string4 = (String)this.areaAddrListModel.get(n3);
                string4 = this.normalize(string4.substring(this.ASTERISK.length()));
                n2 = 0;
                for (n = 1; n < this.selectedRouter.addrList.length; ++n) {
                    string = OsiHelper.getAreaAddressString((byte[])this.selectedRouter.addrList[n]);
                    if (!string4.equals(string)) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) continue;
                arrayList.add(OsiHelper.getAreaAddressBytes((String)string4));
            }
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                this.routerModel.removeMAA(this.selectedRouter.routerNumber, (byte[])iterator.next());
            }
            String string5 = (String)this.areaAddrListModel.get(0);
            string5 = this.normalize(string5.substring(this.ASTERISK.length()));
            if (this.selectedRouter.addrList.length > 0 && !OsiHelper.getAreaAddressString((byte[])this.selectedRouter.addrList[0]).equals(string5)) {
                this.routerModel.changePAA(this.selectedRouter.routerNumber, OsiHelper.getAreaAddressBytes((String)string5));
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.routerModel.addMAA(this.selectedRouter.routerNumber, (byte[])iterator.next());
            }
        }
        catch (Exception exception) {
            db.severe(exception.toString());
            throw exception;
        }
    }

    public void refreshFromModel() {
        this.enabledCB.setSelected(this.selectedRouter.enabled);
        this.sysIdL.setText(OsiHelper.getSystemIdString((byte[])this.selectedRouter.sysId));
        this.areaAddrListModel.clear();
        for (int i = 0; i < this.selectedRouter.addrList.length; ++i) {
            String string = i == 0 && this.selectedRouter.routerNumber == 1 ? this.ASTERISK : this.SPACE;
            this.areaAddrListModel.addElement(string + OsiHelper.getAreaAddressString((byte[])this.selectedRouter.addrList[i]));
        }
        this.areaAddrList.clearSelection();
        this.helpEnable();
    }

    private JComponent createSysIdRow() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("System ID: "));
        if (this.sysIdL == null) {
            this.sysIdL = new JLabel("");
        }
        box.add(this.sysIdL);
        box.add(Box.createHorizontalStrut(10));
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    private JComponent createEnabledRow() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createHorizontalBox();
        if (this.enabledCB == null) {
            this.enabledCB = new JCheckBox("Enable Router");
            this.enabledCB.addActionListener(this);
        }
        box.add(this.enabledCB);
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    private JComponent createAreaAddrRow() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(370, 140));
        Box box = Box.createVerticalBox();
        this.areaAddrListModel = new DefaultListModel();
        this.areaAddrList = new JList(this.areaAddrListModel);
        this.areaAddrList.setFont(OsiHelper.FIXED_WIDTH_FONT);
        this.areaAddrList.addListSelectionListener(this);
        this.areaAddrList.setSelectionMode(0);
        box.add((Component)new UScrollPane((Component)this.areaAddrList));
        box.add(Box.createVerticalGlue());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.nsapImpactLB = new JLabel(this.SPACE);
        jPanel2.add((Component)this.nsapImpactLB, "West");
        box.add(jPanel2);
        box.add(Box.createVerticalGlue());
        box.add(this.createAreaAddrButtonBar());
        jPanel.add((Component)box, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("Manual Area Addresses"));
        return jPanel;
    }

    private JComponent createAreaAddrButtonBar() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        if (this.maaAddB == null) {
            this.maaAddB = this.makeActionButton("Add...");
        }
        if (this.maaEditB == null) {
            this.maaEditB = this.makeActionButton("Edit...");
        }
        if (this.maaDeleteB == null) {
            this.maaDeleteB = this.makeActionButton("Delete");
        }
        jPanel.add(this.maaAddB);
        jPanel.add(this.maaEditB);
        jPanel.add(this.maaDeleteB);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private void helpEnable() {
        if (this.areaAddrListModel != null && this.areaAddrList != null && this.maaAddB != null && this.maaEditB != null && this.maaDeleteB != null) {
            this.maaAddB.setEnabled(this.enabledCB.isSelected() && this.areaAddrListModel.getSize() < 3);
            this.maaDeleteB.setEnabled(this.enabledCB.isSelected() && this.areaAddrList.getSelectedIndex() > 0);
            this.maaEditB.setEnabled(this.enabledCB.isSelected() && this.areaAddrList.getSelectedIndex() > -1);
        }
    }
}

