/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.eLinkType;
import cerent.cms.idl.OSI.sRouter;
import cerent.cms.idl.OSI.sSubnet;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NoSuchSubnet;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OsiModel;
import cerent.cms.model.RouterModel;
import cerent.cms.model.SubnetModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OsiSubnetDialog
extends UDialog
implements ActionListener {
    public static final int CREATING = 0;
    public static final int EDITING = 1;
    public static final int DELETING = 2;
    private int action;
    public static final String CREATE_TITLE = "Enable LAN Subnet";
    public static final String EDIT_TITLE = "Edit";
    public static final String EDIT_TITLE_LAN = "Edit LAN Subnet";
    public static final String DELETE_TITLE = "Disable LAN Subnet";
    public static final String DEFAULT = "Default";
    private JButton okButton;
    private JButton defaultButton;
    private JButton cancelButton;
    OsiSubnetPane attributesPane;
    static Object model;
    private static final SDebug db;

    public static OsiSubnetDialog instance(Pane pane, int n) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        model = pane.getUiModel();
        return new OsiSubnetDialog(frame, model, n);
    }

    private OsiSubnetDialog(Frame frame, Object object, int n) {
        super(frame, OsiSubnetDialog.actionToTitle(n), true, object);
        this.action = n;
    }

    private static String actionToTitle(int n) {
        switch (n) {
            case 0: {
                return CREATE_TITLE;
            }
            case 1: {
                return EDIT_TITLE_LAN;
            }
            case 2: {
                return DELETE_TITLE;
            }
        }
        return "";
    }

    private int titleToAction() {
        String string = this.getTitle();
        if (string.equals(CREATE_TITLE)) {
            return 0;
        }
        if (string.startsWith(EDIT_TITLE)) {
            return 1;
        }
        if (string.equals(DELETE_TITLE)) {
            return 2;
        }
        return -1;
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.createAttributesPanel(object, this.titleToAction()), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    private void setTitle(sSubnet sSubnet2) {
        if (sSubnet2.type.value() == 0) {
            this.setTitle(EDIT_TITLE_LAN);
            return;
        }
        String string = "";
        String string2 = "";
        TDMTerminology tDMTerminology = ((IChassisModel)model).getNodeModelDelegate().getTDMTerminology();
        switch (sSubnet2.type.value()) {
            case 1: {
                string2 = " " + tDMTerminology.getGeneralTerms(10) + " ";
                break;
            }
            case 2: {
                string2 = " " + tDMTerminology.getGeneralTerms(8) + " ";
                break;
            }
            case 3: {
                string2 = " GCC ";
                break;
            }
            case 4: {
                string2 = " OSC ";
            }
        }
        try {
            string = EDIT_TITLE + string2 + "Subnet " + OsiHelper.dccIndexToSlotPort((INodeModel)((IChassisModel)model).getNodeModelDelegate(), (int)sSubnet2.dccIndex, (boolean)true);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            string = EDIT_TITLE + string2 + "Subnet SLOT/PORT unavailable";
        }
        this.setTitle(string);
    }

    public void setSelectedSubnet(sSubnet sSubnet2) {
        this.setTitle(sSubnet2);
        this.attributesPane.setSelectedSubnet(sSubnet2);
    }

    public void dispose() {
        if (this.attributesPane != null) {
            this.attributesPane.destroy();
            this.attributesPane = null;
        }
        super.dispose();
        model = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.onValidate();
                this.apply();
                this.dispose();
            }
            catch (NoSuchSubnet noSuchSubnet) {
                CerentDialog.errorDialog((Component)((Object)this), (String)"This subnet no longer exists");
                SDebug.printStackTrace((Throwable)noSuchSubnet);
            }
            catch (Exception exception) {
                CerentDialog.errorDialog((Component)((Object)this), (String)("Failed to  " + (this.action == 0 ? "create" : (this.action == 1 ? "edit" : "delete")) + " subnet:" + exception));
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (object == this.defaultButton) {
            if (this.attributesPane != null) {
                this.attributesPane.putDefaultSubnet();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void onValidate() throws Exception {
        this.attributesPane.onValidate();
    }

    protected void apply() throws Exception {
        this.attributesPane.applyChangesToModel();
    }

    private JPanel createAttributesPanel(Object object, int n) {
        this.attributesPane = new OsiSubnetPane(this.okButton, ((IChassisModel)object).getNodeModelDelegate(), n);
        return this.attributesPane;
    }

    public JPanel getAttributesPanel() {
        return this.attributesPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        if (this.action != 2) {
            this.defaultButton = this.makeActionButton(DEFAULT);
            jPanel.add(this.defaultButton);
        }
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    static {
        db = new SDebug((KDebug)AbstractShelfProvPane.db, "OsiSubnetDialog");
    }

    public class OsiSubnetPane
    extends JPanel
    implements IOsiConstants,
    ActionListener,
    PropertyChangeListener {
        private sSubnet mySubnet;
        private SubnetModel subnetModel;
        private RouterModel routerModel;
        private OsiModel osiModel;
        private JLabel routerL;
        JComponent[] disPrioComponents;
        GridBagPanel gridBagPanel;
        private SpinPropertyEditor eshSpinner;
        private SpinPropertyEditor ishSpinner;
        private SpinPropertyEditor iihSpinner;
        private SpinPropertyEditor disPrioSpinner;
        private SpinPropertyEditor metricCostSpinner;
        JButton okButton;
        private int action;

        public OsiSubnetPane(JButton jButton, NodeModelDelegate nodeModelDelegate, int n) {
            this.okButton = jButton;
            this.subnetModel = nodeModelDelegate.getSubnetModel();
            this.routerModel = nodeModelDelegate.getRouterModel();
            this.osiModel = nodeModelDelegate.getOsiModel();
            this.action = n;
            this.mySubnet = new sSubnet();
            this.mySubnet.dccIndex = 0;
            this.mySubnet.routerNumber = 1;
            this.mySubnet.type = eLinkType.LINK_TYPE_SDCC;
            db.fine("Action is " + this.action + "/" + n);
            this.init();
        }

        private void init() {
            if (this.action == 0 || this.action == 1) {
                db.fine("Creating subnet enable/edit pane");
                this.add(this.createSubnetPane());
                this.helpEnable(true);
                if (this.okButton != null) {
                    this.okButton.setEnabled(false);
                }
            } else if (this.action == 2) {
                db.fine("Creating subnet disable pane");
                this.add(this.createSubnetDeletionPane());
                if (this.okButton != null) {
                    this.okButton.setEnabled(true);
                }
            }
        }

        public void setSelectedSubnet(sSubnet sSubnet2) {
            this.mySubnet.esh = sSubnet2.esh;
            this.mySubnet.ish = sSubnet2.ish;
            this.mySubnet.iih = sSubnet2.iih;
            this.mySubnet.routerNumber = sSubnet2.routerNumber;
            this.mySubnet.disPrio = sSubnet2.disPrio;
            this.mySubnet.metric = sSubnet2.metric;
            this.mySubnet.dccIndex = sSubnet2.dccIndex;
            this.mySubnet.type = sSubnet2.type;
            if (sSubnet2.type.value() != 0 && sSubnet2.type.value() != 5) {
                this.gridBagPanel.remove(this.disPrioComponents[0]);
                this.gridBagPanel.remove(this.disPrioComponents[1]);
                this.gridBagPanel.remove(this.disPrioComponents[2]);
                OsiSubnetDialog.this.getContentPane().validate();
            }
            if (this.action == 0 || this.action == 1) {
                this.putSubnetToPane(sSubnet2);
                this.helpEnable(true);
            }
        }

        private void helpEnable(boolean bl) {
            this.eshSpinner.setEnabled(bl);
            this.ishSpinner.setEnabled(bl && this.osiModel.getRoutingMode() != 0);
            this.iihSpinner.setEnabled(bl && this.osiModel.getRoutingMode() != 0);
            boolean bl2 = this.osiModel.getRoutingMode() == 0;
            boolean bl3 = this.action == 0;
            this.metricCostSpinner.setEnabled(bl3 && !bl2);
            if (this.mySubnet.type.equals(eLinkType.LINK_TYPE_LAN)) {
                this.disPrioSpinner.setEnabled(bl3 && !bl2);
            }
        }

        private JPanel createSubnetDeletionPane() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)new JLabel("Really disable subnet?"), "Center");
            return jPanel;
        }

        private SpinPropertyEditor helpAddSpinner(ArrayList arrayList, SpinPropertyEditor spinPropertyEditor, String string) {
            spinPropertyEditor.addPropertyChangeListener(this);
            arrayList.add(new JLabel(spinPropertyEditor.getLabelText()));
            spinPropertyEditor.setLabelText("");
            arrayList.add(spinPropertyEditor);
            arrayList.add(new JLabel(string));
            return spinPropertyEditor;
        }

        private JPanel createSubnetPane() {
            int n;
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            this.routerL = new JLabel("");
            jPanel2.add(this.routerL);
            jPanel.add((Component)jPanel2, "North");
            ArrayList arrayList = new ArrayList();
            this.eshSpinner = this.helpAddSpinner(arrayList, new SpinPropertyEditor("ESH", 10, 10, 1000), "sec");
            this.ishSpinner = this.helpAddSpinner(arrayList, new SpinPropertyEditor("ISH", 10, 10, 1000), "sec");
            this.iihSpinner = this.helpAddSpinner(arrayList, new SpinPropertyEditor("IIH", Integer.parseInt("1"), 1, 600), "sec");
            this.metricCostSpinner = this.helpAddSpinner(arrayList, new SpinPropertyEditor("IS-IS Cost", Integer.parseInt("1"), 1, 63), "");
            this.gridBagPanel = new GridBagPanel();
            ArrayList arrayList2 = new ArrayList();
            this.disPrioSpinner = this.helpAddSpinner(arrayList2, new SpinPropertyEditor("DIS Priority", Integer.parseInt("1"), 1, 127), "");
            this.gridBagPanel.anchorWest();
            this.gridBagPanel.inset(4, 1);
            JComponent[] jComponentArray = arrayList.toArray(new JComponent[0]);
            this.disPrioComponents = arrayList2.toArray(new JComponent[0]);
            int n2 = 0;
            for (n = 0; n < jComponentArray.length; n += 3) {
                this.gridBagPanel.add(jComponentArray[n], n % 3, n2++, 1, 1);
            }
            this.gridBagPanel.add(this.disPrioComponents[0], n % 3, n2, 1, 1);
            this.gridBagPanel.fillBoth(100, 0);
            n2 = 0;
            for (n = 1; n < jComponentArray.length; n += 3) {
                this.gridBagPanel.add((Component)jComponentArray[n], n % 3, n2++);
            }
            this.gridBagPanel.add(this.disPrioComponents[1], n % 3, n2, 1, 1);
            n2 = 0;
            for (n = 2; n < jComponentArray.length; n += 3) {
                this.gridBagPanel.add((Component)jComponentArray[n], n % 3, n2++);
            }
            this.gridBagPanel.add(this.disPrioComponents[2], n % 3, n2, 1, 1);
            jPanel.add((Component)this.gridBagPanel, "Center");
            this.putDefaultSubnet();
            return jPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof SpinPropertyEditor && this.okButton != null) {
                this.okButton.setEnabled(true);
            }
        }

        public void onValidate() throws Exception {
        }

        private String getRouterId(int n) {
            sRouter sRouter2 = this.routerModel.getRouter(n);
            return OsiHelper.getRouterId((short)sRouter2.routerNumber, (byte[])(sRouter2.addrList.length > 0 ? sRouter2.addrList[0] : new byte[]{}), (byte[])sRouter2.sysId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void helpPutDefaultSubnet(String string, String string2, SpinPropertyEditor spinPropertyEditor) {
            try {
                string2 = ((IChassisModel)model).getNodeModelDelegate().getDefaultValue(string);
            }
            catch (NoSuchDefault noSuchDefault) {
                db.severe("putDefaultSubnet(): NoSuchDefault " + string);
            }
            catch (Exception exception) {
                if (db.isSevereEnabled()) {
                    db.severe("putDefaultSubnet():unexpected exception from getDefaultValue():" + exception);
                    db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            finally {
                spinPropertyEditor.setValue(new Integer(string2));
            }
        }

        private void putDefaultSubnet() {
            this.routerL.setText(this.getRouterId(1));
            if (this.eshSpinner.isEnabled()) {
                this.helpPutDefaultSubnet("NODE.osi.subnet.ESH", "10", this.eshSpinner);
            }
            if (this.ishSpinner.isEnabled()) {
                this.helpPutDefaultSubnet("NODE.osi.subnet.ISH", "10", this.ishSpinner);
            }
            if (this.iihSpinner.isEnabled()) {
                this.helpPutDefaultSubnet("NODE.osi.subnet.IIH", "3", this.iihSpinner);
            }
            if (this.disPrioSpinner.isEnabled()) {
                this.helpPutDefaultSubnet("NODE.osi.subnet.DISPriority", "63", this.disPrioSpinner);
            }
            if (this.metricCostSpinner.isEnabled()) {
                this.helpPutDefaultSubnet("NODE.osi.subnet.LANISISCost", "20", this.metricCostSpinner);
            }
        }

        private void putSubnetToPane(sSubnet sSubnet2) {
            if (sSubnet2 != null) {
                this.routerL.setText(this.getRouterId(sSubnet2.routerNumber));
                this.eshSpinner.setValue(new Integer(sSubnet2.esh));
                this.ishSpinner.setValue(new Integer(sSubnet2.ish));
                this.iihSpinner.setValue(new Integer(sSubnet2.iih));
                this.disPrioSpinner.setValue(new Integer(sSubnet2.disPrio));
                this.metricCostSpinner.setValue(new Integer(sSubnet2.metric));
            } else {
                db.severe("putSubnetToPane(): null subnet");
            }
        }

        private sSubnet getSubnetFromPane() {
            db.fine("getSubnetFromPane(): begin " + Integer.toString(this.mySubnet.dccIndex));
            this.mySubnet.ish = Short.parseShort((String)this.ishSpinner.getValue());
            this.mySubnet.esh = Short.parseShort((String)this.eshSpinner.getValue());
            this.mySubnet.iih = Short.parseShort((String)this.iihSpinner.getValue());
            this.mySubnet.disPrio = Short.parseShort((String)this.disPrioSpinner.getValue());
            this.mySubnet.metric = Short.parseShort((String)this.metricCostSpinner.getValue());
            db.fine("getSubnetFromPane(): end " + "DCC=" + this.mySubnet.dccIndex + "ISH=" + this.mySubnet.ish + "ESH=" + this.mySubnet.esh + "IIH=" + this.mySubnet.iih + "DISPRIO=" + this.mySubnet.disPrio + "METRIC" + this.mySubnet.metric);
            return this.mySubnet;
        }

        private void applyChangesToSubnet(sSubnet sSubnet2) throws Exception {
            db.fine("Applying changes to subnet (1)");
            if (sSubnet2 != null) {
                db.fine("Applying changes to subnet (2)");
                sSubnet sSubnet3 = null;
                try {
                    if (this.mySubnet.type.equals(eLinkType.LINK_TYPE_LAN)) {
                        db.fine("Getting lan subnet");
                        sSubnet3 = this.subnetModel.getLanSubnet();
                    } else {
                        db.fine("Getting non lan subnet");
                        sSubnet3 = this.subnetModel.getSubnetByIndex(this.mySubnet.dccIndex);
                    }
                }
                catch (Exception exception) {
                    db.severe("Exception when getting Subnet: " + this.mySubnet.dccIndex + " " + exception);
                    throw exception;
                }
                if (sSubnet3 != null) {
                    if (this.mySubnet.ish != sSubnet3.ish) {
                        db.fine("ISH Timer");
                        this.subnetModel.setISHTimer(sSubnet3.routerNumber, sSubnet3.type, sSubnet3.dccIndex, this.mySubnet.ish);
                    }
                    if (this.mySubnet.esh != sSubnet3.esh) {
                        db.fine("ESH Timer");
                        this.subnetModel.setESHTimer(sSubnet3.routerNumber, sSubnet3.type, sSubnet3.dccIndex, this.mySubnet.esh);
                    }
                    if (this.mySubnet.iih != sSubnet3.iih) {
                        db.fine("IIH Timer");
                        this.subnetModel.setIIHTimer(sSubnet3.routerNumber, sSubnet3.type, sSubnet3.dccIndex, this.mySubnet.iih);
                    }
                } else {
                    db.severe("applyChangesToSubnet(): null subnet");
                }
            }
        }

        public void applyChangesToModel() throws Exception {
            db.fine("applyChanges action is " + this.action);
            switch (this.action) {
                case 0: {
                    sSubnet sSubnet2 = this.getSubnetFromPane();
                    if (!this.routerModel.getEnabled(sSubnet2.routerNumber)) {
                        ErrorMsg.displayError((Component)this, (EID)EMC.EID_OSI_ROUTER_DISABLED);
                        break;
                    }
                    this.subnetModel.provisionLanSubnet(sSubnet2);
                    break;
                }
                case 1: {
                    this.applyChangesToSubnet(this.getSubnetFromPane());
                    break;
                }
                case 2: {
                    if (this.mySubnet.type.equals(eLinkType.LINK_TYPE_LAN)) {
                        this.subnetModel.deprovisionLanSubnet();
                        break;
                    }
                    this.subnetModel.removeSubnetBody(this.mySubnet.dccIndex, this.mySubnet.type);
                    break;
                }
                default: {
                    db.println("Unknown action() " + this.action);
                }
            }
        }

        public void destroy() {
        }
    }
}

